<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js" />
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext" >
<uix:bundle name="qMsg" class="oracle.sysman.db.rsc.streams.QueueScheduleMsg" />
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
<uix:bundle name="sMsg" class="oracle.sysman.db.rsc.streams.StreamsMsg" />
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<%
      String dbVersion = (String)request.getAttribute("DBVERSION");
%>
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="SETUP_PROPAGATION@qMsg"/>
          </uix:metaContainer>
          <db:form name="queueProp" method="post" destination="/console/database/dist/streams/propagate" copyParams="target,type, otype,objectType,sname, oname, QNAME, QTYPE, QTABLENAME, QSCHEMA">
          <uix:formValue name="pageName" value="/database/dist/streams/queue/queueProp" />
          <uix:formValue name="owner"  valueBinding="loginUser@servletRequest" />
          <uix:pageLayout titleBinding="SETUP_PROPAGATION@qMsg" >
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>
<oem:messageBox messageType="info"
                             errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
             <oem:messageBox messageType="error"
                             errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

               <uix:spacer height="10" width="10" />

<uix:tableLayout>
    <uix:contents>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:messageStyledText textBinding="PROPAGATION_NAME@qMsg" styleClass="OraInstructionText" labeledNodeId="propName" required="yes"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:messageTextInput name="propName" textBinding="propName@queueSetupPropBean@servletRequest" id="propName" />
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="srcQueueName" textBinding="SOURCE_QUEUE@qMsg" required="yes"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:contents>
		     <uix:messageLovField name="srcQueueName" id="srcQueueName" textBinding="queueName@queueSetupPropBean@servletRequest" onClick="setSearchFilter('owner'); startLov('srcQueueName', 'ListAnydataQueue')" shortDescBinding="queueName@queueSetupPropBean@servletRequest" />
		     </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:spacer height="10" width="10"/>
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
<%--
                      <uix:submitButton text="Manage Rule Set" value="posRuleSet" name="event"/>
--%>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>



      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="destDBLink" textBinding="DESTINATION_DBLINK@qMsg" required="yes"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:contents>
                    
                      <uix:switcher childNameBinding="DBLinkCreated@servletRequest" >
                        <uix:case name="true">
                            <uix:messageLovField name="destDBLink" id="destDBLink" textBinding="newlyCreatedDBLinkName@servletRequest"  onClick="startLov('destDBLink', 'ListSchemaDBLink')"/>
                        </uix:case>
                        <uix:default>
                            <uix:messageLovField name="destDBLink" id="destDBLink" textBinding="destDBLink@queueSetupPropBean@servletRequest" onClick="startLov('destDBLink','ListSchemaDBLink')" />
                        </uix:default>
                      </uix:switcher>
                      
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:spacer height="10" width="10"/>
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:submitButton textBinding="CREATE_DBLINK@qMsg" name="event" value="createDBLink" shortDescBinding="CREATE_DBLINK@qMsg"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:messageStyledText styleClass="OraInstructionText" textBinding="DESTINATION_QUEUE@qMsg" labeledNodeId="destQueueName" required="yes" />
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:messageTextInput name="destQueueName" textBinding="destQueueName@queueSetupPropBean@servletRequest" id="destQueueName"/>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <uix:contents>
            <%--  <uix:styledText styleClass="OraInstructionText" labeledNodeId="posRuleSet" textBinding="POSITIVE_RULESET@qMsg"/> --%>

             <uix:switcher childNameBinding="DBVERSION@servletRequest">
              <uix:case name="10g">
                <uix:styledText styleClass="OraInstructionText" textBinding="POSITIVE_RULESET@qMsg"/>
              </uix:case>
              <uix:case name="9i">
                <uix:styledText styleClass="OraInstructionText" textBinding="RULE_SET_NAME@sMsg"/>
              </uix:case>
            </uix:switcher>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:messageLovField name="posRuleSet" id="posRuleSet" textBinding="posRuleSet@queueSetupPropBean@servletRequest" onClick="setSearchFilter('owner'); startLov('posRuleSet', 'ListRuleSet')" />
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:spacer height="10" width="10"/>
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
<%--
                      <uix:submitButton text="Manage Rule Set" value="posRuleSet" name="event"/>
--%>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
<%
      
      if(dbVersion.equals("10g"))
      {
%>      
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:styledText styleClass="OraInstructionText" textBinding="NEGATIVE_RULESET@qMsg" labeledNodeId="negRuleSet" />
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:messageLovField name="negRuleSet" id="negRuleSet" textBinding="negRuleSet@queueSetupPropBean@servletRequest" onClick="setSearchFilter('owner'); startLov('negRuleSet', 'ListRuleSet')" />
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:spacer height="10" width="10"/>
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
<%--
                      <uix:submitButton text="Manage Rule Set" value="negRuleSet" name="event"/>
--%>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>

	<%-- Q2Q Propagation begin --%>
      <uix:rowLayout renderedBinding="Q2QPropRendered@servletRequest">
        <uix:contents>
          <uix:cellFormat hAlign="right">
            <uix:contents>
              <uix:styledText styleClass="OraInstructionText" textBinding="QUEUE_TO_QUEUE_PROP@aqMsgs" 
			  labeledNodeId="queue2queueProp" />
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="10"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:contents>
                    <uix:messageCheckBox name="queue2queueProp" shortDescBinding="QUEUE_TO_QUEUE_PROP@aqMsgs" 
                     checkedBinding="queue2queueProp@queueSetupPropBean@servletRequest" />
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:spacer height="10" width="10"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>

		<uix:rowLayout renderedBinding="Q2QPropRendered@servletRequest">
		  <uix:contents>
			<uix:cellFormat hAlign="left">
			  <uix:contents>
			  </uix:contents>
			</uix:cellFormat>
			<uix:cellFormat>
			  <uix:contents>
				<uix:spacer height="10" width="5"/>
			  </uix:contents>
			</uix:cellFormat>
			<uix:cellFormat hAlign="left">
			  <uix:contents>
				<uix:rowLayout>
				  <uix:contents>
					<uix:messageStyledText  styleClass="OraInlineInfoText" 
					textBinding="QUEUE_TO_QUEUE_PROP_TIP@aqMsgs"/>
				  </uix:contents>
				</uix:rowLayout>
			  </uix:contents>
			</uix:cellFormat>
		  </uix:contents>
		</uix:rowLayout>

	<%-- Q2Q Propagation end --%>


<%
      }
%>
    </uix:contents>
  </uix:tableLayout>

</uix:contents>
 <uix:pageButtons>
             <uix:pageButtonBar>
                <uix:contents>
                    <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancelSetupPropagation" shortDescBinding="CANCEL@dbMsgs"/>
                    <uix:submitButton textBinding="OK@dbMsgs" name="event" value="okSetupPropagation" shortDescBinding="OK@dbMsgs" />
                </uix:contents>
             </uix:pageButtonBar>
        </uix:pageButtons>
        
        <uix:pageStatus>
             <uix:styledText styleClass="OraInstructionText" textBinding="PROPAGATE_PAGEINFO@qMsg"/>

        </uix:pageStatus>



  </uix:pageLayout>
  </db:form>
 </uix:document>

</uix:renderingContext>




