<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
    <uix:document>
        <uix:metaContainer>
        <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="createQueue" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype, objectType, oname, sname">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/queueStartStopOption"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest" messageType="confirmation">
                    <%@ include file="/database/global.jspf" %>
                    <!-- main contents -->
                    <uix:contents>
                        <uix:switcher childNameBinding="startQueueAction@queueActionBean@servletRequest">
                            <uix:case name="true">
                                <uix:stackLayout>
                                    <uix:switcher childNameBinding="notExceptionQueue@servletRequest">
                                        <uix:case name="true">
                                            <uix:messageStyledText renderedBinding="enqueueEnabled@servletRequest" textBinding="ENQ_ALREADY_ENABLED@aqMsgs" styleClass="OraDataText"/>
                                        </uix:case>
                                    </uix:switcher>
                                    <uix:messageStyledText renderedBinding="dequeueEnabled@servletRequest" textBinding="DEQ_ALREADY_ENABLED@aqMsgs" styleClass="OraDataText"/>                                 
                                </uix:stackLayout>
                            </uix:case>
                            <uix:case name="false"> 
                                <uix:stackLayout>
                                    <uix:switcher childNameBinding="notExceptionQueue@servletRequest">
                                        <uix:case name="true">
                                            <uix:messageStyledText renderedBinding="enqueueDisabled@servletRequest" textBinding="ENQ_ALREADY_DISABLED@aqMsgs" styleClass="OraDataText"/>
                                        </uix:case>
                                    </uix:switcher> 
                                    <uix:messageStyledText renderedBinding="dequeueDisabled@servletRequest" textBinding="DEQ_ALREADY_DISABLED@aqMsgs" styleClass="OraDataText"/>                                 
                                </uix:stackLayout>
                            </uix:case>
                        </uix:switcher>
                        <uix:spacer height="10" width="5"/>
                        <uix:tableLayout hAlign="center" width="100%">
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat columnSpan="2" >
                                            <uix:contents>
                                                <uix:switcher childNameBinding="startQueueAction@queueActionBean@servletRequest">
                                                    <uix:case name="true">
                                                        <uix:messageStyledText textBinding="QUEUE_START_OPTIONS_INSTR@aqMsgs" styleClass="OraInstructionText"/>
                                                    </uix:case>
                                                    <uix:case name="false">
                                                        <uix:messageStyledText textBinding="QUEUE_STOP_OPTIONS_INSTR@aqMsgs" styleClass="OraInstructionText"/>
                                                    </uix:case>
                                                </uix:switcher>
                                    
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%">
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="5"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat renderedBinding="notExceptionQueue@servletRequest">
                                            <uix:contents>
                                                <uix:switcher childNameBinding="startQueueAction@queueActionBean@servletRequest">
                                                    <uix:case name="true">
	      						<%-- <uix:messageCheckBox disabledBinding="enqueueEnabled@servletRequest" checkedBinding="startEnqueue@queueActionBean@servletRequest" name="startEnqueue" shortDescBinding="ENQUEUE@aqMsgs" textBinding="ENQUEUE@aqMsgs" messageBinding="enqueueTip@servletRequest"/> --%>
						    	<uix:switcher childNameBinding="enqueueEnabled@servletRequest">
							  <uix:case name="true">
                                                        <uix:messageCheckBox rendered="false" checkedBinding="startEnqueue@queueActionBean@servletRequest" name="startEnqueue" shortDescBinding="ENQUEUE@aqMsgs" textBinding="ENQUEUE@aqMsgs" messageBinding="enqueueTip@servletRequest"/>
							    </uix:case>
							  <uix:case name="false">
                                                        <uix:messageCheckBox rendered="true" checkedBinding="startEnqueue@queueActionBean@servletRequest" name="startEnqueue" shortDescBinding="ENQUEUE@aqMsgs" textBinding="ENQUEUE@aqMsgs" messageBinding="enqueueTip@servletRequest"/>
							    </uix:case>							    
							</uix:switcher>
						    </uix:case>
						    
                                                    <uix:case name="false">
							<%-- <uix:messageCheckBox disabledBinding="enqueueDisabled@servletRequest" checkedBinding="stopEnqueue@queueActionBean@servletRequest" name="stopEnqueue" shortDescBinding="ENQUEUE@aqMsgs" textBinding="ENQUEUE@aqMsgs" messageBinding="enqueueTip@servletRequest"/>--%>
						    	<uix:switcher childNameBinding="enqueueDisabled@servletRequest">
							  <uix:case name="true">
                                                        <uix:messageCheckBox rendered="false" checkedBinding="stopEnqueue@queueActionBean@servletRequest" name="stopEnqueue" shortDescBinding="ENQUEUE@aqMsgs" textBinding="ENQUEUE@aqMsgs" messageBinding="enqueueTip@servletRequest"/>
							    </uix:case>
							  <uix:case name="false">
							<uix:messageCheckBox rendered="true" checkedBinding="stopEnqueue@queueActionBean@servletRequest" name="stopEnqueue" shortDescBinding="ENQUEUE@aqMsgs" textBinding="ENQUEUE@aqMsgs" messageBinding="enqueueTip@servletRequest"/>
							    </uix:case>							    
							</uix:switcher>
                                                    </uix:case>
                                                </uix:switcher>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="5"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:switcher childNameBinding="startQueueAction@queueActionBean@servletRequest">
                                                    <uix:case name="true">
                                                        <%-- <uix:messageCheckBox disabledBinding="dequeueEnabled@servletRequest" checkedBinding="startDequeue@queueActionBean@servletRequest" name="startDequeue" shortDescBinding="DEQUEUE@aqMsgs" textBinding="DEQUEUE@aqMsgs" messageBinding="dequeueTip@servletRequest"/>--%>

						    	<uix:switcher childNameBinding="dequeueEnabled@servletRequest">
							  <uix:case name="true">
                                                        <uix:messageCheckBox rendered="false" checkedBinding="startDequeue@queueActionBean@servletRequest" name="startDequeue" shortDescBinding="DEQUEUE@aqMsgs" textBinding="DEQUEUE@aqMsgs" messageBinding="dequeueTip@servletRequest"/>
							    </uix:case>
							  <uix:case name="false">
							<uix:messageCheckBox rendered="true" checkedBinding="startDequeue@queueActionBean@servletRequest" name="startDequeue" shortDescBinding="DEQUEUE@aqMsgs" textBinding="DEQUEUE@aqMsgs" messageBinding="dequeueTip@servletRequest"/>
							    </uix:case>							    
							</uix:switcher>

                                                    </uix:case>
                                                    <uix:case name="false">
                                                        <%--<uix:messageCheckBox disabledBinding="dequeueDisabled@servletRequest" checkedBinding="stopDequeue@queueActionBean@servletRequest" name="stopDequeue" shortDescBinding="DEQUEUE@aqMsgs" textBinding="DEQUEUE@aqMsgs" messageBinding="dequeueTip@servletRequest"/> --%>
						    	<uix:switcher childNameBinding="dequeueDisabled@servletRequest">
							  <uix:case name="true">
                                                        <uix:messageCheckBox rendered="false" checkedBinding="stopDequeue@queueActionBean@servletRequest" name="stopDequeue" shortDescBinding="DEQUEUE@aqMsgs" textBinding="DEQUEUE@aqMsgs" messageBinding="dequeueTip@servletRequest"/>
							    </uix:case>
							  <uix:case name="false">
							<uix:messageCheckBox rendered="true" checkedBinding="stopDequeue@queueActionBean@servletRequest" name="stopDequeue" shortDescBinding="DEQUEUE@aqMsgs" textBinding="DEQUEUE@aqMsgs" messageBinding="dequeueTip@servletRequest"/>
							    </uix:case>							    
							</uix:switcher>
                                                        
                                                    </uix:case>
                                                </uix:switcher>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:switcher childNameBinding="startQueueAction@queueActionBean@servletRequest">
                                    <uix:case name="false">
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="5"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                        <uix:messageCheckBox checkedBinding="noWait@queueActionBean@servletRequest" name="noWait" shortDescBinding="NO_WAIT@aqMsgs" textBinding="NO_WAIT@aqMsgs" messageBinding="NO_WAIT_TIP@aqMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:tableLayout>
                    </uix:contents>                   
                    <!-- navigation -->
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="applyStartStop"/>
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
      
                </uix:pageLayout>    


            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
