<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
    <uix:bundle name="captureMsgs" class="oracle.sysman.db.rsc.streams.CaptureMsg"/>   
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>    
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="queuesList" method="post" destination="/console/database/dist/streams/queue" copyParams="target,type,otype,objectType">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/queuesList"/>    
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:switcher childNameBinding="display@servletRequest">
                        <uix:case name="true">
                            <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                            textBinding="CONFIRMATION@aqMsgs"/>
                        </uix:case>
                        <uix:default>
                        </uix:default>
                    </uix:switcher>

                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <%--uix:subTabLayout>
                    
                        <uix:subTabs>
                            <uix:subTabBar selectedIndex="6">
                                <uix:contents> 
                                    <uix:link renderedBinding="IsStreamsRendered@servletRequest" destinationBinding="OVERVIEW_DEST@servletRequest" textBinding="OVERVIEW@streamsMsgs"/>
    				    <uix:link renderedBinding="IsStreamsRendered@servletRequest" destinationBinding="DASHBOARD_DEST@servletRequest" textBinding="DASHBOARD@streamsMsgs"/>
    				    <uix:link renderedBinding="IsStreamsRendered@servletRequest" destinationBinding="TOPOLOGY_DEST@servletRequest" textBinding="TOPOLOGY@streamsMsgs"/>
                                    <uix:link renderedBinding="IsStreamsRendered@servletRequest" destinationBinding="CAPTUREDEST@servletRequest" textBinding="CAPTURE@streamsMsgs"/>
                                    <uix:link renderedBinding="IsStreamsRendered@servletRequest" destinationBinding="PROPAGATEDEST@servletRequest" textBinding="PROPAGATION@streamsMsgs"/>
                                    <uix:link renderedBinding="IsStreamsRendered@servletRequest" destinationBinding="APPLYDEST@servletRequest" textBinding="APPLY@streamsMsgs"/>
                                    <uix:link destinationBinding="MESSAGINGDEST@servletRequest" textBinding="MESSAGING@servletRequest"/>
                                </uix:contents>
                            </uix:subTabBar>
                        </uix:subTabsi--%>
                        <uix:contents>
                            <uix:header textBinding="SEARCH@dbMsgs">
                                <uix:contents>
                                    <%-- UI exit review changes 
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="QUEUES_INSTR@aqMsgs"/> --%>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:tableLayout width="45%" cellSpacing="5">
                                        <uix:contents>
                                            <uix:rowLayout width="100%">
                                                <uix:contents>
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:contents>
                                                            <uix:messageStyledText labeledNodeId="schemaSearchName" styleClass="OraInstructionText" textBinding="SCHEMA@dbMsgs"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat/>
                                          
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:contents>
                                                            
                                                            <uix:messageLovField id="schemaSearchName" name="schemaSearchName" onClick="startLov('schemaSearchName','ListSchema')"  searchDescBinding="SCHEMA@dbMsgs" shortDescBinding="SCHEMA@dbMsgs"
                                                            textBinding="schemaSearchName@QUEUE_LIST_BEAN@servletRequest"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                    
                                                    <uix:cellFormat/>
                                                </uix:contents>
                                            </uix:rowLayout>
                                        
                                            <uix:rowLayout width="100%">
                                                <uix:contents>
                                                    <uix:cellFormat hAlign="right">
                                                        <uix:contents>
                                                            <uix:messageStyledText labeledNodeId="queueSearchName" styleClass="OraInstructionText" textBinding="QNAME@aqMsgs"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>            
                                                    <uix:cellFormat/>
                                       
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:contents>
                                                            <uix:messageTextInput id="queueSearchName" name="queueSearchName" shortDescBinding="QNAME@aqMsgs" 
								textBinding="queueSearchName@QUEUE_LIST_BEAN@servletRequest"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                    <uix:cellFormat/>
                                        
                                                </uix:contents>
                                            </uix:rowLayout>
                                            <uix:rowLayout width="100%">
                                                <uix:contents>
                                                    <uix:cellFormat/>
                                                    <uix:cellFormat/>
                                          
                                                    <uix:cellFormat hAlign="left">
                                                        <uix:contents>
                                                            <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                        </uix:contents>
                                                    </uix:cellFormat>
                                                </uix:contents>
                                            </uix:rowLayout>         
                                        </uix:contents>
                                    </uix:tableLayout>
                                    <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                                    <uix:separator/>
                                    <uix:tableLayout width="100%">
                                        <uix:contents>
                                            <uix:rowLayout >
                                                <uix:contents>
                                                    <uix:messageCheckBox name="displaySystemQueues" 
													shortDescBinding="DISPLAY_SYSTEM_QUEUES@aqMsgs" 
													textBinding="DISPLAY_SYSTEM_QUEUES@aqMsgs" 
													checkedBinding="displaySystemQueues@QUEUE_LIST_BEAN@servletRequest" 
													onClick="submitForm('queuesList', true, {'event':'displaySystemQueues'})" />
                                                </uix:contents>
                                            </uix:rowLayout>

                                            <uix:rowLayout hAlign="right">
                                                <uix:contents>
                                                    <uix:submitButton  shortDescBinding="CREATE@dbMsgs" textBinding="CREATE@dbMsgs" name="event" value="create"/>
                                                </uix:contents>
                                            </uix:rowLayout>
                                            <oem:table name="UIDataSource" width="100%" blockSize="25" summaryBinding="QUEUE_LIST_SUMMARY@aqMsgs" 
                                                beanKey="QUEUE_LIST_BEAN" 
                                                alternateTextBinding="tableAlterText@UIDataSource@QUEUE_LIST_BEAN@servletRequest"
                                                formSubmitted="true"
                                                dataSourceProp="UIDataSource">
                                                <uix:tableSelection>
                                                    <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT_QUEUE@aqMsgs">
                                                        <uix:contents>
                                                            <uix:submitButton shortDescBinding="EDIT@dbMsgs" textBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                                            <uix:submitButton shortDescBinding="DELETE@dbMsgs" textBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                                            <uix:styledText styleClass="OraPromptText" textBinding="ACTIONS@dbMsgs"/>
                                                            <oem:choice   name="actionType" shortDescBinding="ACTIONS@dbMsgs" 
                                                            optionsBinding = "actionTypes@UIDataSource@QUEUE_LIST_BEAN@servletRequest"
                                                            selectedValueBinding = "actionType@UIDataSource@QUEUE_LIST_BEAN@servletRequest" />
                                                            <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" name="event" value="action"/>
                                                        </uix:contents>
                                                    </uix:singleSelection>
                                                </uix:tableSelection>
    
                                            </oem:table>
                                        </uix:contents>
                                    </uix:tableLayout>
                                </uix:contents>
                            </uix:header>
                
                            <!-- To add related links  -->
                            <uix:tableLayout>    
                            <uix:rowLayout width="20%">
                            <uix:header textBinding="RELATED_LINKS@streamsMsgs">
                                <uix:bulletedList>
                                    <uix:link textBinding="MANAGE_QUEUE_TABLES@streamsMsgs" destinationBinding="QueueTablesURL@servletRequest"/>
                                    <uix:link renderedBinding="IsTransRendered@servletRequest" textBinding="MANAGE_TRANSFORMATIONS@streamsMsgs" destinationBinding="TransformationsURL@servletRequest"/>
                                </uix:bulletedList>
                                <uix:spacer height="5" width="10"/>
                            </uix:header>
                           </uix:rowLayout> 
                           </uix:tableLayout>
                
                        </uix:contents>
                    <%--/uix:subTabLayout--%>  

                    <%-- To add common related links                      
                        <jsp:include page="relatedLinksInclude.jsp" />
                        <uix:ref refID="relatedLinksInclude" /> --%>
                                            
                </uix:pageLayout>                
            </db:form>
        </uix:body>                  
    </uix:document>
</uix:renderingContext>

