<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.QueueScheduleMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="scheduleMsgs" class="oracle.sysman.db.rsc.streams.QueueScheduleMsg"/> 
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="createSchedule" method="post" destination="/console/database/dist/streams/queueSchedule" copyParams="target,type,otype,objectType,QNAME,QSCHEMA">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/schedule/createSchedule"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="50%" >
                            <uix:contents>
              
                                <uix:rowLayout width="100%" hAlign="left">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:spacer height="10" width="10"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%"  hAlign="left">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:messageStyledText labeledNodeId="destination" styleClass="OraInstructionText" textBinding="DBLINK@scheduleMsgs"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="3"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left" width="10%">
                                            <uix:contents>
                                                <uix:rowLayout>
                                                
                                                  <uix:switcher childNameBinding="DBLinkCreated@servletRequest" >
                                                    <uix:case name="true">
                                                        <uix:messageLovField name="destination" columns="20" id="destination" 
                                                            searchDescBinding="DBLINK@scheduleMsgs" 
                                                            shortDescBinding="DBLINK@scheduleMsgs" 
                                                            textBinding="newlyCreatedDBLinkName@servletRequest" 
                                                            onClick="startLov('destination', 'ListSchemaDBLink')"/>
                                                    </uix:case>
                                                    <uix:default>
                                                        <uix:messageLovField name="destination" columns="20" id="destination" 
                                                            searchDescBinding="DBLINK@scheduleMsgs" 
                                                            shortDescBinding="DBLINK@scheduleMsgs"
                                                            textBinding="destination@scheduleMainBean@servletRequest"
                                                            onClick="startLov('destination', 'ListSchemaDBLink')"/>
                                                    </uix:default>
                                                  </uix:switcher>
                                                
                                                  <%--  <uix:messageLovField name="destination" columns="20" textBinding="destination@scheduleMainBean@servletRequest" onClick="startLov('destination', 'ListSchemaDBLink')"/> --%>
                                                    <uix:submitButton textBinding="CREATE_DBLINK@scheduleMsgs" name="event" value="createDBLink"/>
                                                </uix:rowLayout>
                                            </uix:contents>
                                        </uix:cellFormat>
                                
                                    </uix:contents>
                                </uix:rowLayout>


								<%-- Q2Q Propagation Begin--%>
                                <uix:rowLayout width="100%" hAlign="left">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:spacer height="5" width="10"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>

                                <uix:rowLayout width="100%"  hAlign="left" renderedBinding="IsVersion102OrAbove@servletRequest">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:messageStyledText labeledNodeId="destinationQueue" styleClass="OraInstructionText" textBinding="DESTINATION_QUEUE@scheduleMsgs"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="3"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left" >
                                            <uix:contents>
                                                <uix:rowLayout>                                                
													<uix:messageTextInput columns="34" shortDescBinding="DESTINATION_QUEUE@scheduleMsgs" 
													textBinding="destinationQueue@scheduleMainBean@servletRequest" 
													name="destinationQueue" id="destinationQueue" />

                                                </uix:rowLayout>
                                            </uix:contents>
                                        </uix:cellFormat>
                                
                                    </uix:contents>
                                </uix:rowLayout>

								<uix:rowLayout renderedBinding="IsVersion102OrAbove@servletRequest">
								  <uix:contents>
									<uix:cellFormat hAlign="left">
									  <uix:contents>
									  </uix:contents>
									</uix:cellFormat>
									<uix:cellFormat>
									  <uix:contents>
										<uix:spacer height="10" width="5"/>
									  </uix:contents>
									</uix:cellFormat>
									<uix:cellFormat hAlign="left">
									  <uix:contents>
										<uix:rowLayout>
										  <uix:contents>
											<uix:messageStyledText  styleClass="OraInlineInfoText" textBinding="DESTINATION_QUEUE_TIP@scheduleMsgs"/>
										  </uix:contents>
										</uix:rowLayout>
									  </uix:contents>
									</uix:cellFormat>
								  </uix:contents>
								</uix:rowLayout>			    

								<%-- Q2Q Propagation End  --%>

                            </uix:contents>
                        </uix:tableLayout>
                        <uix:tableLayout width="100%">
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat width="50%" vAlign="top">
                                            <uix:contents>
                                                <uix:header textBinding="START_TIME@scheduleMsgs">
                                                    <uix:contents>
                                                        <uix:stackLayout>
                                                            <uix:radioButton name="startTimeFrame"
                                                            textBinding="IMMEDIATELY@scheduleMsgs"
                                                            shortDescBinding="IMMEDIATELY@scheduleMsgs"
                                                            value="0"
                                                            selectedValueBinding="startTimeFrameString@scheduleMainBean@servletRequest"/>
                                                            <uix:radioButton name="startTimeFrame"
                                                            textBinding="LATER@scheduleMsgs"
                                                            shortDescBinding="LATER@scheduleMsgs"
                                                            value="1"
                                                            selectedValueBinding="startTimeFrameString@scheduleMainBean@servletRequest"/>
                                                        </uix:stackLayout>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:tableLayout>
                                                            <uix:contents>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText labeledNodeId="startDateString" styleClass="OraInstructionText" textBinding="DATE@scheduleMsgs"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left">
                                                                            <uix:contents>
                                                                                <uix:messageDateField columns="9" tipBinding="startDateTip@scheduleMainBean@servletRequest" id="startDateString" name="startDateString" valueBinding="startDateString@scheduleMainBean@servletRequest" shortDescBinding="DATE@scheduleMsgs">
                                                                                    <uix:onSubmitValidater>
                                                                                        <uix:date dateStyle="medium"/>
                                                                                    </uix:onSubmitValidater>
                                                                                </uix:messageDateField>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="TIME@scheduleMsgs"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left">
                                                                            <uix:contents>
                                                                                <uix:rowLayout>
                                                                                    <uix:contents>
                                                                                        <oem:choice  shortDescBinding="startHour@scheduleMainBean@servletRequest" name="startHour"  optionsBinding="hours@scheduleMainBean@servletRequest"        
                                                                                        selectedValueBinding="startHour@scheduleMainBean@servletRequest"/>
                                                                                        <oem:choice shortDescBinding="startMinute@scheduleMainBean@servletRequest" 
											name="startMinute"  optionsBinding="minutes@scheduleMainBean@servletRequest"        
                                                                                        selectedValueBinding="startMinute@scheduleMainBean@servletRequest"/>
                                                                                        <oem:choice  shortDescBinding="startSecond@scheduleMainBean@servletRequest" 
											name="startSecond"  optionsBinding="seconds@scheduleMainBean@servletRequest"        
                                                                                        selectedValueBinding="startSecond@scheduleMainBean@servletRequest"/>
                                                                                    </uix:contents>
                                                                                </uix:rowLayout>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:radioButton name="startDayTimeFrame"
                                                                                textBinding="AM@scheduleMsgs"
                                                                                shortDescBinding="AM@scheduleMsgs"
                                                                                value="0"
                                                                                selectedValueBinding="startDayTimeFrameString@scheduleMainBean@servletRequest"/>
			               
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:radioButton name="startDayTimeFrame"
                                                                                textBinding="PM@scheduleMsgs"
                                                                                shortDescBinding="PM@scheduleMsgs"
                                                                                value="1"
                                                                                selectedValueBinding="startDayTimeFrameString@scheduleMainBean@servletRequest"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout >
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="TIMEZONE@scheduleMsgs"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:messageStyledText textBinding="timeZone@scheduleMainBean@servletRequest" styleClass="OraDataText"/>                                        
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                                           <uix:rowLayout >
                                                                                               <uix:cellFormat/>
                                                                                               <uix:cellFormat/>
                                                                                               <uix:cellFormat/>
                                                                                               <uix:cellFormat>
                                                                                                   <uix:contents>
                                                                                                       <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="TIMEZONE_HINT@scheduleMsgs"/>
                                                                                                   </uix:contents>
                                                                                               </uix:cellFormat>
                                     
                                                                
                                                                                           </uix:rowLayout>
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                    </uix:contents>
                                                </uix:header>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="50%" vAlign="top">
                                            <uix:contents>
                                                <uix:header textBinding="PROPAGATION_DURATION@scheduleMsgs">
                                                    <uix:contents>
                                                        <uix:stackLayout>								     
                                                            <uix:radioButton name="durationType"
                                                            textBinding="INFINITE@scheduleMsgs"
                                                            shortDescBinding="INFINITE@scheduleMsgs"
                                                            value="0" onClick="submitForm('createSchedule',true,{'event':'durationChanged'})"
                                                            selectedValueBinding="durationTypeString@scheduleMainBean@servletRequest"/>
                                                            <uix:radioButton name="durationType"
                                                            textBinding="FINITE@scheduleMsgs"
                                                            shortDescBinding="FINITE@scheduleMsgs"
                                                            value="1" onClick="submitForm('createSchedule',true,{'event':'durationChanged'})"
                                                            selectedValueBinding="durationTypeString@scheduleMainBean@servletRequest"/>								
                                                        <uix:tableLayout>
                                                            <uix:rowLayout hAlign="left">
                                                                <uix:contents>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="35"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="right">
                                                                        <uix:contents>
                                                                            <uix:styledText labeledNodeId="duration" styleClass="OraInstructionText" textBinding="DURATION@scheduleMsgs"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="3"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="left">
                                                                        <uix:contents>
                                                                            <uix:rowLayout>
                                                                                <uix:textInput id="duration" columns="10" name="duration" 
										     shortDescBinding="DURATION@scheduleMsgs" 
										     textBinding="duration@scheduleMainBean@servletRequest"/>
                                                                                <oem:choice  name="durationUnit" 
										shortDescBinding="durationUnit@scheduleMainBean@servletRequest" 
                                                                                optionsBinding = "durationUnits@scheduleMainBean@servletRequest"          
                                                                                selectedValueBinding = "durationUnit@scheduleMainBean@servletRequest" />
                                                          
                                                                            </uix:rowLayout>
                                                                    
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                
                                                                </uix:contents>
                                                            </uix:rowLayout>
                                                            <uix:rowLayout>
                                                                <uix:cellFormat/>
                                                                <uix:cellFormat/>
                                                                <uix:cellFormat/>
                                                                <uix:cellFormat>
                                                                    <uix:messageText messageBinding="Duration@errors@servletRequest" messageType="error"/>
                                                                </uix:cellFormat>
                                                            </uix:rowLayout>
                                                        </uix:tableLayout>
                                                        </uix:stackLayout>
                                                      
                                                    </uix:contents>
                                                </uix:header>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat columnSpan="2" width="50%">
                                            <uix:contents>
                                                <uix:spacer height="10" width="20"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="50%"/>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                    <uix:cellFormat width="40%" vAlign="top">
                                        <uix:contents>
                                            <uix:header textBinding="LATENCY@scheduleMsgs">
                                                <uix:contents>
                                                    <uix:spacer height="8" width="10"/>
                                                    <uix:messageStyledText textBinding="LATENCY_TIP@scheduleMsgs" styleClass="OraInstructionText"/>
                                                    <uix:spacer height="8" width="10"/>
                                                    <uix:tableLayout>
                                                        <uix:contents>
                                                            <uix:rowLayout>
                                                                <uix:contents>
                                                                <uix:cellFormat>
                                                                <uix:spacer height="10" width="10"/>
                                                                </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="right">
                                                                        <uix:contents>
                                                                            <uix:messageStyledText labeledNodeId="latency" styleClass="OraInstructionText" textBinding="LATENCY_SECONDS@scheduleMsgs"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="3"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="left">
                                                                        <uix:contents>
                                                     
                                                                            <uix:messageTextInput columns="8" id="latency" name="latency" 
										shortDescBinding="LATENCY_SECONDS@scheduleMsgs" 
										textBinding="latency@scheduleMainBean@servletRequest"/>
                                        
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                    
                                                                </uix:contents>
                                                            </uix:rowLayout>
                                                            <uix:rowLayout>
                                                                <uix:contents>
                                                                    <uix:cellFormat/>
                                                                    <uix:cellFormat/>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="3"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat columnSpan="2">
                                                                        <uix:contents>
                                                                            <uix:messageText messageBinding="Latency@errors@servletRequest" messageType="error"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                </uix:contents>
                                                            </uix:rowLayout>
                                                        </uix:contents>
                                                    </uix:tableLayout>
                                                </uix:contents>
                                            </uix:header>
                                        </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="40%" vAlign="top">
                                            <uix:contents>
                                                <uix:header textBinding="NEXT_TIME@scheduleMsgs">
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:tableLayout>
                                                            <uix:contents>
                      
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                      
                                                                                <uix:radioButton name="nextTimeExpType"
                                                                                textBinding="SIMPLE@scheduleMsgs"
                                                                                shortDescBinding="SIMPLE@scheduleMsgs"
                                                                                value="0"
                                                                                selectedValueBinding="nextTimeExpTypeString@scheduleMainBean@servletRequest" disabledBinding="infiniteDuration@servletRequest"/>							
                                                           
                                                                                <uix:spacer height="10" width="10"/>
                                                                                <uix:rowLayout>
                                                                                    <uix:contents>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:spacer height="10" width="20"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                        <uix:cellFormat width="95%">
                                                                                            <uix:contents>
                                                                                                <uix:tableLayout width="100%">
                                                                                                    <uix:contents>
                                                                                                        <uix:rowLayout width="65%">
                                                                                                            <uix:contents>
                                                                                                                <uix:cellFormat>
                                                                                                                    <uix:contents>
                                                                                                                        <uix:spacer height="10" width="40"/>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                                <uix:cellFormat hAlign="left">
                                                                                                                    <uix:contents>
                                                                                                                        <uix:tableLayout hAlign="left">
                                                                                                                            <uix:contents>
                                                                                 
                                                                                                                                <uix:rowLayout>
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:cellFormat hAlign="right">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:styledText styleClass="OraInstructionText" textBinding="REPEAT_PROPAGATION@scheduleMsgs"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>
                                                                                                                                        <uix:cellFormat>
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:spacer height="10" width="10"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>
                                                                                                                                        <uix:cellFormat hAlign="left">
                                                                                                                                            <uix:contents>
                                                                                                                                                <oem:choice   name="repeatIntervalUnit"
                                                                                                                                                optionsBinding = "repeatIntervals@scheduleMainBean@servletRequest"
																		shortDescBinding="repeatIntervalUnit@scheduleMainBean@servletRequest"   
                                                                                                                                                selectedValueBinding = "repeatIntervalUnit@scheduleMainBean@servletRequest" disabledBinding="infiniteDuration@servletRequest"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:rowLayout>

                                                                                                                                <uix:rowLayout>
                                                                                                                                    <uix:contents> 
                                                                                                                                        <uix:cellFormat hAlign="right">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:styledText labeledNodeId="repeatFrequency" styleClass="OraInstructionText" textBinding="FREQUENCY@scheduleMsgs"/>
                                                                                                                                            </uix:contents>
                                                                                                                                            <uix:cellFormat>
                                                                                                                                                <uix:contents>
                                                                                                                                                    <uix:spacer height="10" width="10"/>
                                                                                                                                                </uix:contents>
                                                                                                                                            </uix:cellFormat>
                                                                                                                                        </uix:cellFormat> 
                                                                                                                                        <uix:cellFormat hAlign="left">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:messageTextInput columns="8" id="repeatFrequency" name="repeatFrequency" textBinding="repeatFrequency@scheduleMainBean@servletRequest" shortDescBinding="FREQUENCY@scheduleMsgs" disabledBinding="infiniteDuration@servletRequest"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>                                                                     

                                                                                                                                    </uix:contents>
                                                                                                                                </uix:rowLayout>                                                                              
                                                                                                                
                                                                                                                            </uix:contents>
                                                                                                                        </uix:tableLayout>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                            </uix:contents>
                                                                                                        </uix:rowLayout>
                                                                                                    </uix:contents>
                                                                                                </uix:tableLayout>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                    </uix:contents>
                                                                                </uix:rowLayout>
                                                                                <uix:radioButton name="nextTimeExpType"
                                                                                textBinding="ADVANCED@scheduleMsgs"
                                                                                shortDescBinding="ADVANCED@scheduleMsgs"
                                                                                value="1"
                                                                                selectedValueBinding="nextTimeExpTypeString@scheduleMainBean@servletRequest" disabledBinding="infiniteDuration@servletRequest"/>
                                                       
                                                                                <uix:spacer height="10" width="10"/>
                                                                                <uix:rowLayout>
                                                                                    <uix:contents>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:spacer height="10" width="15"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:tableLayout>
                                                                                                    <uix:contents>
                                                                                                        <uix:rowLayout>
                                                                                                            <uix:contents>
                                                                                                                <uix:cellFormat>
                                                                                                                    <uix:contents>
                                                                                                                        <uix:spacer height="10" width="12"/>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                                <uix:cellFormat hAlign="center">
                                                                                                                    <uix:contents>
                                                                                                                        <uix:messageTextInput
															columns="34" shortDescBinding="ADVANCED@scheduleMsgs" 
															textBinding="advExpression@scheduleMainBean@servletRequest" 
															name="advExpression" messageBinding="ADVANCED_TIP@scheduleMsgs" 
															disabledBinding="infiniteDuration@servletRequest"/>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                            </uix:contents>
                                                                                                        </uix:rowLayout>
                                                                                                    </uix:contents>
                                                                                                </uix:tableLayout>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                    </uix:contents>
                                                                                </uix:rowLayout>
                                                         
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                 
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                        <uix:spacer height="20" width="10"/>
                                                    </uix:contents>
                                                </uix:header>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        
                                    </uix:contents>
                                </uix:rowLayout>
                            
                            </uix:contents>
                        </uix:tableLayout>
                        <uix:spacer height="10" width="10"/>
                          

                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                                <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
