<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.QueueScheduleMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/utils.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="scheduleMsgs" class="oracle.sysman.db.rsc.streams.QueueScheduleMsg"/> 
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="editSchedule" method="post" destination="/console/database/dist/streams/queueSchedule" copyParams="target,type,otype,oname,objectType,QNAME,QSCHEMA">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/schedule/editSchedule"/> 
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:contents>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="50%" >
                            <uix:contents>
              
                                <uix:rowLayout width="100%" hAlign="left">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:spacer height="10" width="10"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout width="100%"  hAlign="left" renderedBinding="DestinationRendered@servletRequest">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="DBLINK@scheduleMsgs"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="3"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:contents>
                                                <uix:messageStyledText styleClass="OraDataText" textBinding="destination@scheduleMainBean@servletRequest"/>                                    
                                            </uix:contents>
                                        </uix:cellFormat>
                                
                                    </uix:contents>
                                </uix:rowLayout>

								<%-- Q2Q Prop begin--%>
                                <uix:rowLayout width="100%"  hAlign="left" renderedBinding="DestQandDBLinkRendered@servletRequest">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="DBLINK@scheduleMsgs"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="3"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:contents>
                                                <uix:messageStyledText styleClass="OraDataText" textBinding="DB_LINK@servletRequest"/>                                    
                                            </uix:contents>
                                        </uix:cellFormat>
                                
                                    </uix:contents>
                                </uix:rowLayout>

                                <uix:rowLayout width="100%"  hAlign="left" renderedBinding="DestQandDBLinkRendered@servletRequest">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="DESTINATION_QUEUE@scheduleMsgs"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="3"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:contents>
                                                <uix:messageStyledText styleClass="OraDataText" textBinding="DESTINATION_QUEUE@servletRequest"/>                    
                                            </uix:contents>
                                        </uix:cellFormat>
                                
                                    </uix:contents>
                                </uix:rowLayout>

								<%-- Q@Q Prop end--%>

                            </uix:contents>
                        </uix:tableLayout>
                        <uix:tableLayout width="100%">
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat width="50%" vAlign="top">
                                            <uix:contents>
                                                <uix:header textBinding="START_TIME@scheduleMsgs">
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:tableLayout>
                                                            <uix:contents>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="TIME@scheduleMsgs"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText styleClass="OraDataText" textBinding="startTimeForEditString@scheduleMainBean@servletRequest"/> 
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout >
                                                                    <uix:contents>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="right">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="TIMEZONE@scheduleMsgs"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                                                <uix:spacer height="10" width="10"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left">
                                                                            <uix:contents>
                                                                                <uix:messageStyledText textBinding="timeZone@scheduleMainBean@servletRequest" styleClass="OraDataText"/>                                        
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:rowLayout >
                                                                    <uix:cellFormat/>
                                                                    <uix:cellFormat/>
                                                                    <uix:cellFormat/>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="TIMEZONE_HINT@scheduleMsgs"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                     
                                                                
                                                                </uix:rowLayout>
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                    </uix:contents>
                                                </uix:header>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="50%" vAlign="top">
                                            <uix:contents>
                                                <uix:header textBinding="PROPAGATION_DURATION@scheduleMsgs">
                                                    <uix:contents>
                                                        <uix:stackLayout>								     
                                                            <uix:radioButton name="durationType"
                                                            textBinding="INFINITE@scheduleMsgs"
                                                            shortDescBinding="INFINITE@scheduleMsgs"
                                                            value="0" onClick="submitForm('editSchedule',true,{'event':'durationChanged'})"
                                                            selectedValueBinding="durationTypeString@scheduleMainBean@servletRequest"/>
                                                            <uix:radioButton name="durationType"
                                                            textBinding="FINITE@scheduleMsgs"
                                                            shortDescBinding="FINITE@scheduleMsgs"
                                                            value="1" onClick="submitForm('editSchedule',true,{'event':'durationChanged'})"
                                                            selectedValueBinding="durationTypeString@scheduleMainBean@servletRequest"/>								
                                                        <uix:tableLayout>
                                                            <uix:rowLayout hAlign="left">
                                                                <uix:contents>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="35"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="right">
                                                                        <uix:contents>
                                                                            <uix:styledText styleClass="OraInstructionText" textBinding="DURATION@scheduleMsgs"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="3"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="left">
                                                                        <uix:contents>
                                                                            <uix:rowLayout>
                                                                                <uix:textInput columns="10" shortDescBinding="DURATION@scheduleMsgs" name="duration" textBinding="duration@scheduleMainBean@servletRequest"/>
                                                                                <oem:choice  name="durationUnit" shortDescBinding="durationUnit@scheduleMainBean@servletRequest"
                                                                                 optionsBinding = "durationUnits@scheduleMainBean@servletRequest"          
                                                                                selectedValueBinding = "durationUnit@scheduleMainBean@servletRequest" />
                                                                            </uix:rowLayout>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                
                                                                </uix:contents>
                                                            </uix:rowLayout>
                                                            <uix:rowLayout>
                                                                <uix:cellFormat/>
                                                                <uix:cellFormat/>
                                                                <uix:cellFormat/>
                                                                <uix:cellFormat>
                                                                    <uix:messageText messageBinding="Duration@errors@servletRequest" messageType="error"/>
                                                                </uix:cellFormat>
                                                            </uix:rowLayout>
                                                        </uix:tableLayout>
                                             </uix:stackLayout>
                                                    </uix:contents>
                                                </uix:header>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat columnSpan="2" width="50%">
                                            <uix:contents>
                                                <uix:spacer height="10" width="20"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="50%"/>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                    <uix:cellFormat width="40%" vAlign="top">
                                        <uix:contents>
                                            <uix:header textBinding="LATENCY@scheduleMsgs">
                                                <uix:contents>
                                                    <uix:spacer height="8" width="10"/>
                                                    <uix:messageStyledText textBinding="LATENCY_TIP@scheduleMsgs" styleClass="OraInstructionText"/>
                                                    <uix:spacer height="8" width="10"/>
                                                    <uix:tableLayout>
                                                        <uix:contents>
                                                            <uix:rowLayout>
                                                                <uix:contents>
                                                                <uix:cellFormat>
                                                                <uix:spacer height="10" width="10"/>
                                                                </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="right">
                                                                        <uix:contents>
                                                                            <uix:messageStyledText labeledNodeId="latency" styleClass="OraInstructionText" textBinding="LATENCY_SECONDS@scheduleMsgs"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="3"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="left">
                                                                        <uix:contents>
                                                     
                                                                            <uix:messageTextInput columns="8" id="latency" name="latency" 
										shortDescBinding="LATENCY_SECONDS@scheduleMsgs"
										textBinding="latency@scheduleMainBean@servletRequest"/>
                                        
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                    
                                                                </uix:contents>
                                                            </uix:rowLayout>
                                                            <uix:rowLayout>
                                                                <uix:contents>
                                                                    <uix:cellFormat/>
                                                                    <uix:cellFormat/>
                                                                    <uix:cellFormat>
                                                                        <uix:contents>
                                                                            <uix:spacer height="10" width="3"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat columnSpan="2">
                                                                        <uix:contents>
                                                                            <uix:messageText messageBinding="Latency@errors@servletRequest" messageType="error"/>
                                                                        </uix:contents>
                                                                    </uix:cellFormat>
                                                                </uix:contents>
                                                            </uix:rowLayout>
                                                        </uix:contents>
                                                    </uix:tableLayout>
                                                </uix:contents>
                                            </uix:header>
                                        </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="40%" vAlign="top">
                                            <uix:contents>
                                                <uix:header textBinding="NEXT_TIME@scheduleMsgs">
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:tableLayout>
                                                            <uix:contents>
                      
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                          
                                                                        <uix:cellFormat>
                                                                            <uix:contents>
                                                      
                                                                                <uix:radioButton name="nextTimeExpType"
                                                                                textBinding="SIMPLE@scheduleMsgs"
                                                                                shortDescBinding="SIMPLE@scheduleMsgs"
                                                                                value="0"
                                                                                selectedValueBinding="nextTimeExpTypeString@scheduleMainBean@servletRequest" disabledBinding="infiniteDuration@servletRequest"/>							
                                                           
                                                                                <uix:spacer height="10" width="10"/>
                                                                                <uix:rowLayout>
                                                                                    <uix:contents>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:spacer height="10" width="20"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                        <uix:cellFormat width="95%">
                                                                                            <uix:contents>
                                                                                                <uix:tableLayout width="100%">
                                                                                                    <uix:contents>
                                                                                                        <uix:rowLayout width="65%">
                                                                                                            <uix:contents>
                                                                                                                <uix:cellFormat>
                                                                                                                    <uix:contents>
                                                                                                                        <uix:spacer height="10" width="40"/>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                                <uix:cellFormat hAlign="left">
                                                                                                                    <uix:contents>
                                                                                                                        <uix:tableLayout hAlign="left">
                                                                                                                            <uix:contents>
                                                                                 
                                                                                                                                <uix:rowLayout>
                                                                                                                                    <uix:contents>
                                                                                                                                        <uix:cellFormat hAlign="right">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:styledText styleClass="OraInstructionText" textBinding="REPEAT_PROPAGATION@scheduleMsgs"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>
                                                                                                                                        <uix:cellFormat>
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:spacer height="10" width="10"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>
                                                                                                                                        <uix:cellFormat hAlign="left">
                                                                                                                                            <uix:contents>
                                                                                                                                                <oem:choice   name="repeatIntervalUnit"
                                                                                                                                                optionsBinding = "repeatIntervals@scheduleMainBean@servletRequest"  shortDescBinding="repeatIntervalUnit@scheduleMainBean@servletRequest"                              
                                                                                                                                                selectedValueBinding = "repeatIntervalUnit@scheduleMainBean@servletRequest" disabledBinding="infiniteDuration@servletRequest"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>
                                                                                                                                    </uix:contents>
                                                                                                                                </uix:rowLayout>

                                                                                                                                <uix:rowLayout>
                                                                                                                                    <uix:contents> 
                                                                                                                                        <uix:cellFormat hAlign="right">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:styledText labeledNodeId="repeatFrequency" styleClass="OraInstructionText" textBinding="FREQUENCY@scheduleMsgs"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat> 
                                                                                                                                        <uix:cellFormat>
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:spacer height="10" width="10"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>
                                                                                                                                        <uix:cellFormat hAlign="left">
                                                                                                                                            <uix:contents>
                                                                                                                                                <uix:messageTextInput columns="8" id="repeatFrequency" name="repeatFrequency" shortDescBinding="FREQUENCY@scheduleMsgs" textBinding="repeatFrequency@scheduleMainBean@servletRequest" disabledBinding="infiniteDuration@servletRequest"/>
                                                                                                                                            </uix:contents>
                                                                                                                                        </uix:cellFormat>                                                                     

                                                                                                                                    </uix:contents>
                                                                                                                                </uix:rowLayout>                                                                              
                                                                                                                
                                                                                                                            </uix:contents>
                                                                                                                        </uix:tableLayout>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                            </uix:contents>
                                                                                                        </uix:rowLayout>
                                                                                                    </uix:contents>
                                                                                                </uix:tableLayout>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                    </uix:contents>
                                                                                </uix:rowLayout>
                                                                                <uix:radioButton name="nextTimeExpType"
                                                                                textBinding="ADVANCED@scheduleMsgs"
                                                                                shortDescBinding="ADVANCED@scheduleMsgs"
                                                                                value="1"
                                                                                selectedValueBinding="nextTimeExpTypeString@scheduleMainBean@servletRequest" disabledBinding="infiniteDuration@servletRequest"/>
                                                       
                                                                                <uix:spacer height="10" width="10"/>
                                                                                <uix:rowLayout>
                                                                                    <uix:contents>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:spacer height="10" width="15"/>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                        <uix:cellFormat>
                                                                                            <uix:contents>
                                                                                                <uix:tableLayout>
                                                                                                    <uix:contents>
                                                                                                        <uix:rowLayout>
                                                                                                            <uix:contents>
                                                                                                                <uix:cellFormat>
                                                                                                                    <uix:contents>
                                                                                                                        <uix:spacer height="10" width="10"/>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                                <uix:cellFormat hAlign="center">
                                                                                                                    <uix:contents>
                                                                                                                        <uix:messageTextInput columns="20" textBinding="advExpression@scheduleMainBean@servletRequest" 
							name="advExpression" messageBinding="ADVANCED_TIP@scheduleMsgs" 
							 shortDescBinding="ADVANCED@scheduleMsgs"  disabledBinding="infiniteDuration@servletRequest"/>
                                                                                                                    </uix:contents>
                                                                                                                </uix:cellFormat>
                                                                                                            </uix:contents>
                                                                                                        </uix:rowLayout>
                                                                                                    </uix:contents>
                                                                                                </uix:tableLayout>
                                                                                            </uix:contents>
                                                                                        </uix:cellFormat>
                                                                                    </uix:contents>
                                                                                </uix:rowLayout>
                                                         
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                 
                                                            </uix:contents>
                                                        </uix:tableLayout>
                                                        <uix:spacer height="20" width="10"/>
                                                    </uix:contents>
                                                </uix:header>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        
                                    </uix:contents>
                                </uix:rowLayout>
                                
                            </uix:contents>
                        </uix:tableLayout>
                        <uix:spacer height="10" width="10"/>
                          

                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                                <uix:submitButton shortDescBinding="REVERT@dbMsgs" textBinding="REVERT@dbMsgs" name="event" value="revert"/>
                                <uix:submitButton shortDescBinding="APPLY@dbMsgs" textBinding="APPLY@dbMsgs" name="event" value="apply"/>
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
