<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.QueueScheduleMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/utils.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="scheduleMsgs" class="oracle.sysman.db.rsc.streams.QueueScheduleMsg"/>   
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="schedulesList" method="post" destination="/console/database/dist/streams/queueSchedule" copyParams="target,type,otype,objectType,QNAME,QSCHEMA">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/schedule/schedulesList"/>    
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="60%">
                            <uix:contents>
                                <uix:rowLayout width="60%">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:submitButton  shortDescBinding="CREATE@dbMsgs" textBinding="CREATE@dbMsgs" name="event" value="create"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:dataScope currentDataBinding="schedulesListBean@servletRequest">
                                            <uix:table name="schedulesList" 
                                            alternateTextBinding="NO_PROPAGATIONS_FOUND@scheduleMsgs"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="rowData"
                                            minValue="1"
                                            valueBinding="startIndex"
                                            blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                            maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
											shortDescBinding="PROP_SUMMARY@scheduleMsgs" 
                                            summaryBinding="PROP_SUMMARY@scheduleMsgs">
               
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="DESTINATION@scheduleMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
                                            <uix:text textBinding="<%= QueueScheduleMsgID.DESTINATION %>" />
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="ENABLED@scheduleMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="iconButtonFormat" width="25%"/>
                                            <uix:image sourceBinding="<%= QueueScheduleMsgID.STATUS_IMAGE_URL %>" shortDescBinding="ENABLED@scheduleMsgs"/>
                                            </uix:column>
                                            <uix:tableSelection>
                                                <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT_PROP@scheduleMsgs">
                                                    <uix:contents>
                                                        <uix:submitButton shortDescBinding="ENABLE_DISABLE@scheduleMsgs" textBinding="ENABLE_DISABLE@scheduleMsgs" name="event" value="changeState"/>
                                                        <uix:submitButton shortDescBinding="EDIT@dbMsgs" textBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                                        <uix:submitButton shortDescBinding="DELETE@dbMsgs" textBinding="DELETE@dbMsgs" name="event" value="delete"/>
                          
                                                    </uix:contents>
                                                </uix:singleSelection>
                                            </uix:tableSelection>		
                                            </uix:table>
                                        </uix:dataScope>

                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                    </uix:contents>

                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
