<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.AQMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_CONS@aqMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>
      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('subsList');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('Name', selectedIndex);
            var selectedElement2 = proxy.getFormElement('Address', selectedIndex);
            lovField.value = selectedElement.value + ":" + selectedElement2.value;
            window.close();
          }
        }
      </script>
    </uix:metaContainer>
    <uix:body>
<uix:dataScope currentDataBinding="SUBS_LOV_BEAN@servletRequest">
   <db:form name="subsLov" method="post" 
            destinationBinding="destination@servletRequest"
            copyParams="target,type, QTABLENAME, oname, sname, otype,objectType, IS_80_COMPATIBLE">
      <uix:pageLayout titleBinding="SEARCH_AND_SELECT_CONS@aqMsgs">
        <uix:formValue name="pageName" value="/database/dist/streams/queue/selectQueueSubs"/>


          <uix:tableLayout cellSpacing="2" width="80%">

            <%-- Search Criteria and Instruction --%>
            <uix:rowLayout>
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH_AND_SELECT_CONS@aqMsgs">
	               <uix:tableLayout>
	                <uix:rowLayout>
	                <cellFormat>
	                  <uix:messageStyledText labeledNodeId="subsSearchName" styleClass="OraInstructionText" textBinding="NAME@dbMsgs"/>
	                </cellFormat>
	                <cellFormat>
	                  <uix:spacer height="10" width="3"/>
	                </cellFormat>
	                <cellFormat>
	                  <uix:messageTextInput id="subsSearchName" name="subsSearchName" 
                                     shortDescBinding="NAME@dbMsgs"
                                     textBinding="subsSearchName"/>
	                </cellFormat>
	                </uix:rowLayout>
	                <uix:rowLayout>
	                <cellFormat>
	                  <uix:messageStyledText labeledNodeId="subsSearchAddress" styleClass="OraInstructionText" textBinding="ADDRESS@aqMsgs"/>
	                </cellFormat>
	                <cellFormat>
	                  <uix:spacer height="10" width="3"/>
	                </cellFormat>
	                <cellFormat>
                          <uix:messageTextInput id="subsSearchAddress" name="subsSearchAddress" 
                                     shortDescBinding="ADDRESS@aqMsgs"
                                     textBinding="subsSearchAddress"/>
	                </cellFormat>
	                </uix:rowLayout>
	                <uix:rowLayout>
	                <cellFormat>
	                <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" name="event" 
                                            value="search"/>
	                </cellFormat>
	                <cellFormat>
	                </cellFormat>
	                <cellFormat>
	                </cellFormat>
	                </uix:rowLayout>
	               </uix:tableLayout>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                    <uix:table name="subsList" 
                                                alternateTextBinding="subsAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NAME@dbMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text textBinding="<%= AQMsgID.CONS_NAME %>" />
                                                <uix:formValue name="Name" valueBinding="<%= AQMsgID.CONS_NAME %>"/>
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="ADDRESS@aqMsgs" sortable="true"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                                <uix:text textBinding="<%= AQMsgID.CONS_ADDR %>" />
                                                <uix:formValue name="Address" valueBinding="<%= AQMsgID.CONS_ADDR %>"/>
                                                </uix:column>
                                                <uix:tableSelection>
                                                <uix:singleSelection selectedIndex="0">
                                                </uix:singleSelection>
                                            </uix:tableSelection>
                                                </uix:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" />
            <uix:button shortDescBinding="SELECT@dbMsgs" textBinding="SELECT@dbMsgs" destinationBinding="subsLovSelect@servletRequest"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
</uix:dataScope>
   </uix:body>
  </uix:document>
</uix:renderingContext>
