<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.SubscriberMsgID" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="subsMsgs" class="oracle.sysman.db.rsc.streams.SubscriberMsg"/>  
          <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="createSubscriber" method="post" destination="/console/database/dist/streams/queueSubscriber" copyParams="target,type,objectType,otype, QNAME, QTABLENAME, QSCHEMA, IS_80_COMPATIBLE, IS_RENDEREDFOR_80_COMPATIBLE, IS_SECURE_QTABLE">
    <uix:formValue name="pageName" value="/database/dist/streams/queue/subscr/createSubscriber"/>   
    <uix:formValue name="loggedInUser" valueBinding="loggedInUser@servletRequest"/>    
    <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/> 
    <uix:pageLayout titleBinding="header@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <%-- <uix:messages> --%>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
   <%-- </uix:messages> --%>
<uix:contents>
<uix:spacer height="10" width="10"/>
           <uix:tableLayout hAlign="center" width="75%">
                          <uix:contents>
			<uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText textBinding="NAME@dbMsgs" styleClass="OraInstructionText" labeledNodeId="subscriberName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="subscriberName" id="subscriberName" 
                                                          shortDescBinding="NAME@dbMsgs"
                                                          textBinding="subscriberName@subscriberMainBean@servletRequest" 
                                                          columns="50"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="address" textBinding="ADDRESS@subsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput columns="50" name="address" id="address" 
                                                          textBinding="address@subscriberMainBean@servletRequest" 
                                                          shortDescBinding="ADDRESS@subsMsgs"/>
                                    <uix:messageText messageBinding="address@errors@servletRequest" messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
			    
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" textBinding="ADDRESS_HINT@subsMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>			    

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
                                    <uix:messageStyledText textBinding="DEST_DB@subsMsgs" styleClass="OraInstructionText"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                
                                <uix:cellFormat>
                                <uix:contents>
                                <uix:stackLayout>
                                <uix:contents>

                                <uix:radioButton name="dbLocation"
                                                textBinding="LOCAL_DB@subsMsgs"
                                                value="0"
                                                selectedValueBinding="selectedDBLocation@servletRequest"
                                                onClick="submitForm( 'createSubscriber', true, {'event':'onLocalDBSelect'} )"/>  

                                                <%-- Local DB fields begin--%>

                                                <uix:tableLayout>
                                                  <uix:contents>
                                                    <uix:rowLayout>
                                                      <uix:contents>
                                                        <uix:cellFormat>
                                                          <uix:contents>
                                                            <uix:spacer height="10" width="20"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>

                                                        <uix:cellFormat>
                                                          <uix:contents>
                                                            <uix:rowLayout>
                                                              <uix:contents>
                                                                <uix:cellFormat hAlign="right" width="45%">
                                                                  <uix:contents>
                                                                    <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="localDBLink" textBinding="DBLINK@subsMsgs"/>
                                                                  </uix:contents>
                                                                </uix:cellFormat>
                                                                <uix:cellFormat>
                                                                  <uix:contents>
                                                                    <uix:spacer height="10" width="3"/>
                                                                  </uix:contents>
                                                                </uix:cellFormat>
                                                                <uix:cellFormat hAlign="left">
                                                                  <uix:contents>

                                                                  <uix:switcher childNameBinding="DBLinkCreated@servletRequest" >
                                                                    <uix:case name="true">
                                                                        <uix:messageLovField columns="32" name="localDBLink" id="localDBLink" 
                                                                            shortDescBinding="DBLINK@subsMsgs"
                                                                            searchDescBinding="DBLINK@subsMsgs" 
                                                                            disabledBinding="disableLocalDBFields@servletRequest" 
                                                                            textBinding="newlyCreatedLocalDBLinkName@servletRequest"  
                                                                            onClick="startLov('localDBLink', 'ListSchemaLoopbackDBLink')"/>
                                                                    </uix:case>
                                                                    <uix:default>
                                                                        <uix:messageLovField columns="32" name="localDBLink" id="localDBLink"
                                                                            shortDescBinding="DBLINK@subsMsgs"
                                                                            searchDescBinding="DBLINK@subsMsgs"
                                                                            disabledBinding="disableLocalDBFields@servletRequest" 
                                                                            textBinding="localDBLink@subscriberMainBean@servletRequest"  
                                                                            onClick="startLov('localDBLink', 'ListSchemaLoopbackDBLink')"/>
                                                                    </uix:default>
                                                                  </uix:switcher>

                                                                  </uix:contents>
                                                                </uix:cellFormat>
                                                              <uix:cellFormat hAlign="left" width="60%">
                                                                  <uix:contents>
                                                                    <uix:submitButton textBinding="CREATE_DBLINK@subsMsgs" shortDescBinding="CREATE_DBLINK@subsMsgs" disabledBinding="disableLocalDBFields@servletRequest" name="event" value="createDBLink"/>
                                                                  </uix:contents>
                                                                </uix:cellFormat>
                                                              </uix:contents>
                                                            </uix:rowLayout>
							    
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="87"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" textBinding="LOCAL_DBLINK_MESSAGE@subsMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>			    
							    
							    
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                      </uix:contents>
                                                    </uix:rowLayout>
                                                  </uix:contents>
                                                </uix:tableLayout>

                                                
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:cellFormat>
                                                      <uix:contents>
                                                        <uix:spacer height="10" width="20"/>
                                                      </uix:contents>
                                                    </uix:cellFormat>

                                                    <uix:cellFormat>
                                                      <uix:contents>
                                                        <uix:rowLayout renderedBinding = "IS_SECURE_QTABLE@servletRequest" >
                                                          <uix:contents>
                                                            <uix:cellFormat hAlign="right" width="80">
                                                              <uix:contents>
                                                                <uix:messageStyledText styleClass="OraInstructionText" required="yes" labeledNodeId="userName" textBinding="USER@dbMsgs"/>
                                                              </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat>
                                                              <uix:contents>
                                                                <uix:spacer height="10" width="5"/>
                                                              </uix:contents>
                                                            </uix:cellFormat>
                                                            <uix:cellFormat hAlign="left">
                                                              <uix:contents>
                                                                <uix:messageLovField columns="32" name="userName" id="userName"
                                                                                    searchDescBinding="USER@dbMsgs"
                                                                                     shortDescBinding="USER@dbMsgs"
                                                                                     disabledBinding="disableLocalDBFields@servletRequest"  
                                                                                     textBinding="userName@subscriberMainBean@servletRequest" 

                                                                                     onClick="setBindSqlParm('loggedInUser');startLov('userName','ListSecureSubscriberUser')" 
                                                                                     />
                                                                <uix:messageText messageBinding="userName@errors@servletRequest" messageType="error"/>
                                                              </uix:contents>
                                                            </uix:cellFormat>
                                                          </uix:contents>
                                                        </uix:rowLayout>
							
                            <uix:rowLayout renderedBinding = "IS_SECURE_QTABLE@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="87"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" textBinding="USER_MESSAGE@subsMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>			    							
							
                                                      </uix:contents>
                                                    </uix:cellFormat>
                                                  </uix:contents>
                                                </uix:rowLayout>                                                
                                                
                                                <%-- Local DB fields end--%>
                                                
                                <uix:radioButton name="dbLocation"
                                                textBinding="REMOTE_DB@subsMsgs"
                                                value="1"
                                                selectedValueBinding="selectedDBLocation@servletRequest"
                                                onClick="submitForm( 'createSubscriber', true, {'event':'onRemoteDBSelect'} )"/>
                                </uix:contents>
                                </uix:stackLayout>
                                 
                                 <uix:tableLayout>
                                          <uix:contents>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:spacer height="10" width="20"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:rowLayout>
                                                      <uix:contents>
                                                        <uix:cellFormat hAlign="right" width="45%">
                                                          <uix:contents>
                                                            <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="dbLink" textBinding="DBLINK@subsMsgs"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat>
                                                          <uix:contents>
                                                            <uix:spacer height="10" width="3"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="left">
                                                          <uix:contents>

                                                          <uix:switcher childNameBinding="DBLinkCreated@servletRequest" >
                                                            <uix:case name="true">
                                                                <uix:messageLovField columns="32" name="dbLink" id="dbLink"
                                                                    searchDescBinding="DBLINK@subsMsgs"
                                                                    shortDescBinding="DBLINK@subsMsgs" 
                                                                    disabledBinding="disableRemoteDBFields@servletRequest" 
                                                                    textBinding="newlyCreatedDBLinkName@servletRequest" 
                                                                    onClick="startLov('dbLink', 'ListSchemaDBLink')"/>
                                                            </uix:case>
                                                            <uix:default>
                                                                <uix:messageLovField columns="32" name="dbLink" id="dbLink" 
                                                                    shortDescBinding="DBLINK@subsMsgs"
                                                                    searchDescBinding="DBLINK@subsMsgs" 
                                                                    disabledBinding="disableRemoteDBFields@servletRequest" 
                                                                    textBinding="dbLink@subscriberMainBean@servletRequest"  
                                                                    onClick="startLov('dbLink', 'ListSchemaDBLink')"/>
                                                            </uix:default>
                                                          </uix:switcher>
                                                            
                                                          </uix:contents>
                                                        </uix:cellFormat>
					              <uix:cellFormat hAlign="left" width="60%">
                                                          <uix:contents>
                                                            <uix:submitButton textBinding="CREATE_DBLINK@subsMsgs" shortDescBinding="CREATE_DBLINK@subsMsgs" disabledBinding="disableRemoteDBFields@servletRequest" name="event" value="createDBLink"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                      </uix:contents>
                                                    </uix:rowLayout>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:tableLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout renderedBinding="IsTransRendered@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="transformation" textBinding="TRANSFORMATION@subsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageLovField columns="50" textBinding="transformation@subscriberMainBean@servletRequest" 
                                                         name="transformation" 
                                                         id="transformation" 
                                                         shortDescBinding="TRANSFORMATION@subsMsgs" 
                                                         searchDescBinding="TRANSFORMATION@subsMsgs" 
                                                         onClick="startLov('transformation', 'ListSchemaTransformation')"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout renderedBinding="IS_RENDEREDFOR_80_COMPATIBLE@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="rule" textBinding="RULE@subsMsgs"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="rule" id="rule" 
                                                          textBinding="rule@subscriberMainBean@servletRequest" 
                                                          shortDescBinding="RULE@subsMsgs" 
                                                          rows="5" wrap="soft" columns="52"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <%-- <uix:rowLayout renderedBinding="IS_RENDEREDFOR_80_COMPATIBLE@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top">
                                  <uix:contents/>
                                </uix:cellFormat>
                                <uix:cellFormat columnSpan="2">
                                  <uix:contents>
                                    <uix:tip>
                                      <uix:contents>
                                        <uix:formattedText textBinding="RULE_HINT@subsMsgs"/>
                                      </uix:contents>
                                    </uix:tip>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            --%>
                          </uix:contents>
                        </uix:tableLayout>
                    
</uix:contents>
<uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="SHOWSQL@dbMsgs" shortDescBinding="SHOWSQL@dbMsgs" name="event" value="showSql"/>
                            <uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                            <uix:submitButton textBinding="OK@dbMsgs" shortDescBinding="OK@dbMsgs" name="event" value="apply"/>
                          </uix:contents>
                        </uix:pageButtonBar>  
                      </uix:pageButtons>
                      
                      <%-- UI exit review changes
                      <uix:pageStatus>   
                        <uix:formattedText styleClass="OraInstructionText" 
                         textBinding="CREATE_SUBSCRIBER_INSTR@subsMsgs"/>
                      </uix:pageStatus>
                      --%>
                      
</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>


</uix:renderingContext>
