<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.SubscriberMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/utils.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="subsMsgs" class="oracle.sysman.db.rsc.streams.SubscriberMsg"/>   
          <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="npSubscribersList" method="post" destination="/console/database/dist/streams/queueSubscriber" copyParams="target,type,otype,objectType,QTYPE,QNAME, QTABLENAME, QSCHEMA">
    <uix:formValue name="pageName" value="/database/dist/streams/queue/subscr/npSubscribersList"/>    
    <uix:pageLayout titleBinding="header@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
<uix:contents>
                        <uix:spacer height="10" width="10"/>
                        
                            <!--  Search contents begin   -->
                        <uix:header textBinding="SEARCH@dbMsgs">

                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="SUBSCRIBER_SEARCH_INSTR@subsMsgs"/>
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout cellSpacing="5">
                                  <uix:contents>
                                  
                                    <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="subscriberSearchName" textBinding="NAME@dbMsgs"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageTextInput name="subscriberSearchName" 
                                                                  id="subscriberSearchName"
                                                                  shortDescBinding="NAME@dbMsgs" 
                                                                  textBinding="subscriberSearchName@subscribersListBean@servletRequest"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    
                                    <uix:rowLayout width="100%">
                                        <uix:contents>
                                            <uix:cellFormat/>
                                            <uix:cellFormat/>
                                            <uix:cellFormat hAlign="left" width="75%">
                                                <uix:contents>
                                                    <uix:submitButton textBinding="GO@dbMsgs" shortDescBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                </uix:contents>
                                            </uix:cellFormat>
                                        </uix:contents>
                                    </uix:rowLayout>
                                    
                                  </uix:contents>
                                </uix:tableLayout>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                                <uix:separator/>                                                            
                            <!--   Search contents end  -->                        
                        
                        <uix:tableLayout width="65%">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                              <uix:dataScope currentDataBinding="subscribersListBean@servletRequest">
                                <uix:table name="subscribersListBean" 
                                    alternateTextBinding="tableAlternateText"
                                    formSubmitted="true"
                                    width="40%"
                                    tableDataBinding="rowData"
                                    minValue="1"
                                    valueBinding="startIndex"
                                    blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                    maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
                                    shortDescBinding="SUBSCRIBERS_LIST@subsMsgs"
                                    summaryBinding="SUBSCRIBERS_LIST@subsMsgs">

               
                                    <uix:tableFormat tableBanding="rowBanding"/>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="NAME@subsMsgs" />
                                      </uix:columnHeader> 
                                      <uix:columnFormat width="50%"/>
                                      <uix:messageTextInput shortDescBinding="NAME@dbMsgs"  disabledBinding="<%= SubscriberMsgID.IS_READ_ONLY %>" name="subscriberName" textBinding="<%= SubscriberMsgID.NAME %>"/>
                                    </uix:column>
                                    
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="DELETE@dbMsgs" />
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="iconButtonFormat" width="15%"/>
                                      <uix:image  sourceBinding="<%= SubscriberMsgID.DELETE_IMAGE %>" shortDescBinding="DELETE@dbMsgs" destinationBinding="<%= SubscriberMsgID.DELETE_NP_SUBS_URL %>"/>
                                    </uix:column>
                                    
                                  <uix:columnFooter>
                                     <uix:submitButton textBinding="ADD_A_ROW@subsMsgs" shortDescBinding="ADD_A_ROW@subsMsgs" name="event" value="addRow"/>
                                  </uix:columnFooter>		
                            </uix:table> 
                            </uix:dataScope>
                               </uix:contents>
                             </uix:rowLayout>
				
                          </uix:contents>
                        </uix:tableLayout>
                        </uix:header>
                      </uix:contents>
<uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="REVERT@dbMsgs" shortDescBinding="REVERT@dbMsgs" name="event" value="cancelnp"/>
                            <uix:submitButton textBinding="APPLY@dbMsgs" shortDescBinding="APPLY@dbMsgs" name="event" value="applynp"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
<uix:pageStatus>
                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="NP_SUBSCRIBERS_INSTR@subsMsgs"/>
                      </uix:pageStatus>

</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>


</uix:renderingContext>
