<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.SubscriberMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
    <db:script src="/database/utils.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="subsMsgs" class="oracle.sysman.db.rsc.streams.SubscriberMsg"/>   
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>    
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="subscribersList" method="post" destination="/console/database/dist/streams/queueSubscriber" copyParams="target,type,otype,objectType,QTYPE,QNAME, QTABLENAME, QSCHEMA, IS_80_COMPATIBLE, IS_RENDEREDFOR_80_COMPATIBLE, IS_SECURE_QTABLE">
                <uix:formValue name="pageName" value="/database/dist/streams/queue/subscr/subscribersList"/>    
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <%-- <uix:messages> --%>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <%-- </uix:messages> --%>
                    <uix:contents>
                        <uix:spacer height="10" width="10"/>
                        
                            <!--  Search contents begin   -->
                        <uix:header textBinding="SEARCH@dbMsgs">

                                <uix:messageStyledText styleClass="OraInstructionText" />
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout width="50%" cellSpacing="5">
                                  <uix:contents>
                                    <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="NAME@dbMsgs" labeledNodeId="subscriberSearchName"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                        
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageTextInput name="subscriberSearchName" id="subscriberSearchName" 
                                                                  shortDescBinding="NAME@dbMsgs" 
                                                                  textBinding="subscriberSearchName@subscribersListBean@servletRequest"/>
                                          </uix:contents>
                                        </uix:cellFormat>                                        
                                        
                                      </uix:contents>
                                    </uix:rowLayout>
                                        
                                    <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="ADDRESS@subsMsgs" labeledNodeId="addressSearchName" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                      
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageTextInput name="addressSearchName" 
                                                                  id="addressSearchName"
                                                                  shortDescBinding="ADDRESS@subsMsgs" 
                                                                  textBinding="addressSearchName@subscribersListBean@servletRequest"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                      </uix:contents>
                                    </uix:rowLayout>

                                    <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="DBLINK@subsMsgs" labeledNodeId="dbLinkSearchName"  />
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                      
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageLovField name="dbLinkSearchName" 
                                                                 id="dbLinkSearchName" 
                                                                 shortDescBinding="DBLINK@subsMsgs"
                                                                 searchDescBinding="DBLINK@subsMsgs"
                                                                 textBinding="dbLinkSearchName@subscribersListBean@servletRequest" 
                                                                 onClick="startLov('dbLinkSearchName', 'ListSchemaDBLink')"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                      </uix:contents>
                                    </uix:rowLayout>                                    
                                    
                                    <uix:rowLayout width="100%">
                                        <uix:contents>
                                            <uix:cellFormat/>
                                            <uix:cellFormat/>
                                            <uix:cellFormat hAlign="left" width="75%">
                                                <uix:contents>
                                                    <uix:submitButton textBinding="GO@dbMsgs" shortDescBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                </uix:contents>
                                            </uix:cellFormat>
                                        </uix:contents>
                                    </uix:rowLayout>

                                  </uix:contents>
                                </uix:tableLayout>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                                <uix:separator/>                        
                        
                            <!--   Search contents end  -->                        
                        
                        <uix:tableLayout width="100%">
                            <uix:contents>
                                <uix:rowLayout width="100%">
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                            <uix:contents>
                                                <uix:submitButton disabledBinding="createButtonDisabled@servletRequest" textBinding="CREATE@dbMsgs" shortDescBinding="CREATE_SUBSCRIBER@subsMsgs"  name="event" value="create"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:dataScope currentDataBinding="subscribersListBean@servletRequest">
                                            <uix:table name="subscribersListBean" 
                                            alternateTextBinding="tableAlternateText"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="rowData"
                                            minValue="1"
                                            valueBinding="startIndex"
                                            blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                            maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
                                            shortDescBinding="SUBSCRIBERS_LIST@subsMsgs"
                                            summaryBinding="SUBSCRIBERS_LIST@subsMsgs">
               
                                            <uix:tableFormat tableBanding="rowBanding"/>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="NAME@subsMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" />
                                            <uix:link textBinding="<%= SubscriberMsgID.NAME %>"/>
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="ADDRESS@subsMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat" />
                                            <uix:styledText textBinding="<%= SubscriberMsgID.ADDRESS %>"/>
                                            </uix:column>
                                            <uix:column>
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="DBLINK@subsMsgs" sortable="true"/>
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= SubscriberMsgID.DBLINK %>"/>
                                            </uix:column>
                                            <uix:column renderedBinding="Is80Compatible@subscribersListBean@servletRequest">
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="RULE@subsMsgs" />
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= SubscriberMsgID.RULE %>"/>
                                            </uix:column>
                                            <uix:column renderedBinding="IsTransRendered@subscribersListBean@servletRequest">
                                            <uix:columnHeader>
                                                <uix:sortableHeader textBinding="TRANSFORMATION@subsMsgs" />
                                            </uix:columnHeader> 
                                            <uix:columnFormat columnDataFormat="textFormat"/>
                                            <uix:styledText textBinding="<%= SubscriberMsgID.TRANSFORMATION %>"/>
                                            </uix:column>
                                            <uix:tableSelection>
                                                <uix:singleSelection selectedIndex="0" shortDescBinding="TABLE_SELECTION@aqMsgs">
                                                    <uix:contents>
                  
                                                        <uix:submitButton renderedBinding="IS_RENDEREDFOR_80_COMPATIBLE@servletRequest" 
                                                                          shortDescBinding="EDIT@dbMsgs"
                                                                          textBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                                        <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                                    </uix:contents>
                                                </uix:singleSelection>
                                            </uix:tableSelection>		
                                            </uix:table> 
                                        </uix:dataScope>

                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                        </uix:header>
                    </uix:contents>

                    <uix:header textBinding="RELATED_LINKS@streamsMsgs" renderedBinding="IsVersion90OrAbove@subscribersListBean@servletRequest">
                        <uix:bulletedList>
                            <uix:link textBinding="MANAGE_TRANSFORMATIONS@streamsMsgs" destinationBinding="TransformationsURL@servletRequest"/>
                        </uix:bulletedList>
                        <uix:spacer height="10" width="10"/>
                    </uix:header>
                      
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>


</uix:renderingContext>
