<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.TransformationMsgID" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="transformMsgs" class="oracle.sysman.db.rsc.streams.TransformationMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

            <uix:body>
            
            <db:form name="createAttributeExpressionForm" method="post" destination="/console/database/dist/streams/transformation" copyParams="target,type,otype,objectType, sname, oname">
            <uix:formValue name="pageName" value="/database/dist/streams/queue/transform/createAttributeExpression"/>
            <uix:formValue name="fromType" valueBinding="transformFrom@transformAttributes@servletRequest"/>
            <uix:formValue name="toType" valueBinding="transformTo@transformAttributes@servletRequest"/>            
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>
                    
                    <!-- main contents -->
                      <uix:contents>

                        <uix:header textBinding="headerText@servletRequest">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANSFORMATION_ENTIRE_OBJECT_MSG@transformMsgs"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:tableLayout width="100%">
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat>

				<%--This tableLayout is to make this page ADA compliant. The LOV field needs lableNodeId and this attribute is not available for uix:radioButton. Hence this kind of workaround --%>
					<uix:tableLayout>
						<uix:rowLayout>
						<uix:cellFormat>
                                        <uix:radioButton name="attrTransformationExpression"
                                                                     selectedValueBinding="selectedExpressionType@objectExpressionBean@servletRequest"
								     shortDescBinding="USER_DEFINED_FUNCTION@transformMsgs"
                                                                     value="userDefinedFunction" />
						</uix:cellFormat>
						<uix:cellFormat>
									<uix:messageStyledText styleClass="OraInstructionText"
									textBinding="USER_DEFINED_FUNCTION@transformMsgs" labeledNodeId="attrTransFunction"/>
						</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>

                                                <uix:tableLayout width="50%">
                                                  <uix:contents>
                                                    <uix:rowLayout width="50%">
                                                      <uix:contents>
                                                        <uix:cellFormat>
                                                          <uix:contents>
                                                            <uix:spacer height="10" width="30"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="left">
                                                          <uix:contents>
                                                            <uix:messageLovField name="attrTransformationFunction"
                                                                                 columns="50"  id="attrTransFunction"
                                                                                 textBinding="functionName@objectExpressionBean@servletRequest"
                                                                                 shortDescBinding="USER_DEFINED_FUNCTION@transformMsgs"
																				 searchDescBinding="USER_DEFINED_FUNCTION@transformMsgs"
                                                                                 onClick="startLov('attrTransformationFunction','ListFunction')"/>
                                                                                 <%--onClick="setBindSqlParm('fromType');setBindSqlParm('toType');
                                                                                          startLov('attrTransformationFunction','ListValidTransformationFunction')"/> --%>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                      </uix:contents>
                                                    </uix:rowLayout>
                                                  </uix:contents>
                                                </uix:tableLayout>

                                        <uix:radioButton name="attrTransformationExpression"
                                                                     textBinding="SQL_EXPRESSION@transformMsgs"
																	 shortDescBinding="SQL_EXPRESSION@transformMsgs"
                                                                     selectedValueBinding="selectedExpressionType@objectExpressionBean@servletRequest"
                                                                     value="sqlExpression" />

                                                <uix:tableLayout width="55%">
                                                  <uix:contents>
                                                    <uix:rowLayout width="60%">
                                                      <uix:contents>
                                                        <uix:cellFormat hAlign="right">
                                                          <uix:contents>
                                                            <uix:spacer height="10" width="38"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat hAlign="left">
                                                          <uix:contents>
                                                            <uix:messageTextInput name="attrSqlExpression" 
                                                                                  textBinding="sqlExpression@objectExpressionBean@servletRequest"
                                                                                  shortDescBinding="SQL_EXPRESSION@transformMsgs"
                                                                                  messageBinding="SQL_EXPRESSION_MSG@transformMsgs" 
                                                                                  columns="52" rows="3"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                      </uix:contents>
                                                    </uix:rowLayout>
                                                  </uix:contents>
                                                </uix:tableLayout>

                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                      </uix:contents>

                      <!-- navigation -->
                      <uix:tabs/>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" name="event" value="cancelAttributeExpression"/>
                            <uix:submitButton textBinding="OK@dbMsgs" shortDescBinding="OK@dbMsgs" name="event" value="setAttributeExpression"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                </uix:pageLayout>
                </db:form>
	            </uix:body>
        </uix:document>
</uix:renderingContext>
