<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.TransformationMsgID" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="transformMsgs" class="oracle.sysman.db.rsc.streams.TransformationMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

            <uix:body>

            <db:form name="createTransformationForm" method="post" destination="/console/database/dist/streams/transformation" copyParams="target,type,otype,objectType">
            <uix:formValue name="pageName" value="/database/dist/streams/queue/transform/createTransformation"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>
                      <!-- main contents -->

                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="100%">
                          
                            <!-- ROW: Transfromation Name -->
                            <uix:rowLayout width="100%" hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="NAME@dbMsgs" labeledNodeId="transformationName"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="transformationName" id="transformationName"
                                                          textBinding="transformationName@transformAttributes@servletRequest" 
                                                          columns="50" 
                                                          shortDescBinding="NAME@dbMsgs"/>
                                    <uix:messageText messageBinding="transformationName@errors@servletRequest" messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                            <!-- ROW: Schema Name -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="SCHEMA@dbMsgs" labeledNodeId="schemaName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageLovField name="schemaName" textBinding="schemaName@transformAdminBean@servletRequest"
                                                         columns="50" id="schemaName"
                                                         shortDescBinding="SCHEMA@dbMsgs"
														 searchDescBinding="SCHEMA@dbMsgs"
                                                         onClick="startLov('schemaName','ListSchema')"/>
                                    <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                            <!-- ROW: Transfrom From -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANSFORM_FROM@transformMsgs" labeledNodeId="transformFrom"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageLovField name="transformFrom" id="transformFrom"
                                                         columns="50" shortDescBinding="TRANSFORM_FROM@transformMsgs"
														 searchDescBinding="TRANSFORM_FROM@transformMsgs"
                                                         textBinding="transformFrom@transformAttributes@servletRequest"
                                                         onClick="startLov('transformFrom','ListObjecttype')"/>
                                    <uix:messageText messageBinding="transformFrom@errors@servletRequest" messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                            <!-- ROW: Transfrom To -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANSFORM_TO@transformMsgs" labeledNodeId="transformTo"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageLovField name="transformTo" id="transformTo"
                                                         shortDescBinding="TRANSFORM_TO@transformMsgs"
														 searchDescBinding="TRANSFORM_TO@transformMsgs"
                                                         textBinding="transformTo@transformAttributes@servletRequest" 
                                                         columns="50" onClick="startLov('transformTo','ListObjecttype')"/>
                                    <uix:messageText messageBinding="transformTo@errors@servletRequest" messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                        </uix:tableLayout>
                        <uix:spacer height="15" width="10"/>

                      <!-- navigation -->
                      <uix:tabs/>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="SHOWSQL@dbMsgs" shortDescBinding="SHOWSQL@dbMsgs" rendered="false"  />
                            <uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                            <uix:submitButton textBinding="CONTINUE@dbMsgs" shortDescBinding="CONTINUE@dbMsgs" name ="event" value ="createTransformationExpression" />
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                </uix:pageLayout>
                </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>
