<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.TransformationMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="transformMsgs" class="oracle.sysman.db.rsc.streams.TransformationMsg"/>
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

            <uix:body>
            
            <db:form name="createTransformationExpressionForm" method="post" destination="/console/database/dist/streams/transformation" copyParams="target,type,otype,objectType, sname, oname">
            <uix:formValue name="pageName" value="/database/dist/streams/queue/transform/createTransformationExpression"/>
            <uix:formValue name="fromType" valueBinding="transformFrom@transformAttributes@servletRequest"/>
            <uix:formValue name="toType" valueBinding="transformTo@transformAttributes@servletRequest"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>
                    
                    <!-- main contents -->
                      <uix:contents>
                        <uix:header textBinding="SPECIFY_TRANSFORMATION@transformMsgs" >
                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANSFORMATION_ENTIRE_OBJECT_MSG@transformMsgs"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="14"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:radioButton name="selectTransformationAttribute" 
                                    				 textBinding="TRANSFORMATION_ENTIRE_OBJECT@transformMsgs" 
													 shortDescBinding="TRANSFORMATION_ENTIRE_OBJECT@transformMsgs"
                                    				 selectedValueBinding="selectedTransformAttribute@servletRequest" 
                                    				 value="entireObject" 
                                    				 onClick="submitForm( 'createTransformationExpressionForm', true, {'event':'onEntireObject'}  )"
                                                                  />

                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:spacer height="5" width="15"/>
                                      </uix:contents>
                                    </uix:rowLayout>


                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:spacer height="5" width="15"/>

                                        <uix:tableLayout width="100%">
                                          <uix:contents>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:spacer height="10" width="25"/>
                                                  </uix:contents>
                                                </uix:cellFormat>

                                                <uix:cellFormat>
						<%--This tableLayout is to make this page ADA compliant. The LOV field needs lableNodeId and this attribute is not available for uix:radioButton. Hence this kind of workaround --%>
						<uix:tableLayout>
						<uix:rowLayout>
						<uix:cellFormat>
                                                    <uix:radioButton name="transformationExpression"

                                                                                 disabledBinding="disableEntireObject@servletRequest"
                                                                                 selectedValueBinding="selectedTransformExpression@servletRequest"
										 shortDescBinding="USER_DEFINED_FUNCTION@transformMsgs"
                                                                                 value="userDefinedFunction" />
						</uix:cellFormat>
						<uix:cellFormat>
									<uix:messageStyledText styleClass="OraInstructionText"
									textBinding="USER_DEFINED_FUNCTION@transformMsgs" labeledNodeId="transformationFunction"/>
						</uix:cellFormat>
						</uix:rowLayout>
						</uix:tableLayout>
                                                            <uix:tableLayout width="50%">
                                                              <uix:contents>

                                                                <uix:rowLayout>
                                                                  <uix:contents>
                                                                    <uix:spacer height="5" width="15"/>
                                                                  </uix:contents>
                                                                </uix:rowLayout>

                                                                <uix:rowLayout width="50%">
                                                                  <uix:contents>
                                                                    <uix:cellFormat>
                                                                      <uix:contents>
                                                                        <uix:spacer height="10" width="30"/>
                                                                      </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="left">
                                                                      <uix:contents>
                                                                        <uix:messageLovField name="transformationFunction" columns="50" 
                                                                                             id="transformationFunction" 
                                                                                             shortDescBinding="FUNCTION@transformMsgs"
																							 searchDescBinding="FUNCTION@transformMsgs"
                                                                                             textBinding="transformationFunction@transformAttributes@servletRequest" 
                                                                                             disabledBinding="disableEntireObject@servletRequest" 
                                                                                             onClick="setBindSqlParm('fromType');setBindSqlParm('toType');
                                                                                                      startLov('transformationFunction','ListValidTransformationFunction')"/>
                                                                        <uix:messageText messageBinding="transformationFunction@errors@servletRequest" messageType="error"/>
                                                                      </uix:contents>
                                                                    </uix:cellFormat>
                                                                  </uix:contents>
                                                                </uix:rowLayout>
                                                              </uix:contents>
                                                            </uix:tableLayout>

                                                    <uix:radioButton name="transformationExpression" 
                                                                                 textBinding="SQL_EXPRESSION@transformMsgs" 
																				 shortDescBinding="SQL_EXPRESSION@transformMsgs"
                                                                                 disabledBinding="disableEntireObject@servletRequest" 
                                                                                 selectedValueBinding="transformationExpression@transformAttributes@servletRequest" 
                                                                                 value="sqlExpression" />

                                                            <uix:tableLayout width="55%">
                                                              <uix:contents>
                                                                <uix:rowLayout width="60%">
                                                                  <uix:contents>
                                                                    <uix:cellFormat hAlign="right">
                                                                      <uix:contents>
                                                                        <uix:spacer height="10" width="30"/>
                                                                      </uix:contents>
                                                                    </uix:cellFormat>
                                                                    <uix:cellFormat hAlign="left">
                                                                      <uix:contents>
                                                                        <uix:messageTextInput name="sqlExpression" id="sqlExpression" 
                                                                                              shortDescBinding="SQL_EXPRESSION@transformMsgs"
                                                                                              messageBinding="SQL_EXPRESSION_MSG@transformMsgs" 
                                                                                              textBinding="sqlExpression@transformAttributes@servletRequest" 
                                                                                              disabledBinding="disableEntireObject@servletRequest" 
                                                                                              columns="52"   rows="3"/>
                                                                      </uix:contents>
                                                                    </uix:cellFormat>
                                                                  </uix:contents>
                                                                </uix:rowLayout>
                                                              </uix:contents>
                                                            </uix:tableLayout>

                                                </uix:cellFormat>
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:tableLayout>                                        
                                        <uix:spacer height="10" width="10"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:spacer height="10" width="10"/>
                                      </uix:contents>
                                    </uix:rowLayout>

                                    <uix:radioButton name="selectTransformationAttribute" 
                                    				 textBinding="TRANSFORMATION_INDIVIDUAL_ATTRIBUTE@transformMsgs" 
													 shortDescBinding="TRANSFORMATION_INDIVIDUAL_ATTRIBUTE@transformMsgs"
                                    				 selectedValueBinding="selectedTransformAttribute@servletRequest"
                                    				 value="individualAttributes"
                                    				 onClick="submitForm( 'createTransformationExpressionForm', true, {'event':'onIndividualAttributes'}  )"
                                                                  />

                                        <uix:spacer height="10" width="10"/>
                                        <uix:tableLayout width="100%">
                                          <uix:contents>
                                            <uix:rowLayout width="100%">
                                              <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:spacer height="10" width="15"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>

                                                    <!-- Table data begin -->
                                                    <uix:dataScope currentDataBinding="sourceObjectAttrListBean@servletRequest">
                                                    <uix:table name="attributeListTable" 
                                                            alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                                            formSubmitted="true"
                                                            width="50%"
                                                            tableDataBinding="rowData"
                                                            minValue="1"
                                                            valueBinding="startIndex"
                                                            blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                                            maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
                                                            shortDescBinding="ATTRIBUTE_TABLE@transformMsgs"
                                                            summaryBinding="ATTRIBUTE_TABLE@transformMsgs">

                                                            <uix:tableFormat tableBanding="rowBanding"/>
                                                            <uix:column>
                                                              <uix:columnHeader>
                                                                <uix:sortableHeader textBinding="ATTRIBUTE_NAME@transformMsgs" />
                                                              </uix:columnHeader> 
                                                              <uix:columnFormat columnDataFormat="textFormat" />
                                                              <uix:styledText textBinding="<%= TransformationMsgID.ATTRIBUTE_NAME %>"/>
                                                            </uix:column>

                                                         <uix:tableSelection>
                                                              <uix:singleSelection  shortDescBinding="TABLE_SELECTION@aqMsgs" disabledBinding="disableIndividualAttributes@servletRequest" 
                                                                                    selectedIndexBinding="SelectedRow@sourceObjectAttrListBean@servletRequest" >
                                                                   <uix:contents>
                                                                        <uix:submitButton textBinding="SET_EXPRESSION@transformMsgs" 
                                                                                          shortDescBinding="SET_EXPRESSION@transformMsgs" 
                                                                                          disabledBinding="disableIndividualAttributes@servletRequest" 
                                                                                          name="event" value="setExpression"/>
                                                                    </uix:contents>
                                                               </uix:singleSelection>
                                                         </uix:tableSelection>

                                                    </uix:table>
                                                    </uix:dataScope>
                                                    <!-- Table data end -->
                                                  
                                                </uix:cellFormat>
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:tableLayout>

                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:spacer height="10" width="10"/>
                        </uix:header>
                      </uix:contents>

                      <!-- navigation -->
                      <uix:tabs/>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="SHOWSQL@dbMsgs" shortDescBinding="SHOWSQL@dbMsgs" name="event" value="showSql"  />
                            <uix:submitButton renderedBinding="isCreateMode@servletRequest"  textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" name="event" value="cancel"/>
                            <uix:submitButton renderedBinding="isCreateMode@servletRequest" textBinding="BACK@dbMsgs" shortDescBinding="BACK@dbMsgs" name="event" value="goBack"/>
                            <uix:submitButton renderedBinding="isCreateMode@servletRequest" textBinding="FINISH@transformMsgs" shortDescBinding="FINISH@transformMsgs" name ="event" value ="apply" />
                            
                            <uix:submitButton renderedBinding="isEditMode@servletRequest" textBinding="REVERT@dbMsgs" shortDescBinding="REVERT@dbMsgs" name ="event" value ="revert" unvalidated="true"/>
                            <uix:submitButton renderedBinding="isEditMode@servletRequest" textBinding="APPLY@dbMsgs" shortDescBinding="APPLY@dbMsgs" name ="event" value ="apply" />
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="TRANSFORMATION_EXPRESSION_MSG@transformMsgs"/>
                      </uix:pageStatus>
                      
                </uix:pageLayout>
                </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>
