<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.TransformationMsgID" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="transformMsgs" class="oracle.sysman.db.rsc.streams.TransformationMsg"/>
<uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
<uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

            <uix:body>

            <db:form name="transformationListForm" method="post" destination="/console/database/dist/streams/transformation" copyParams="target,type,otype,objectType">
            <uix:formValue name="pageName" value="/database/dist/streams/queue/transform/transformationsList"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>
                      <!-- Main contents begin -->

                  <uix:contents>
                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANSFORMATION_MESSAGE@transformMsgs"/>                      
                        <uix:spacer height="10" width="10"/>
                        
                            <!--  Search contents begin   -->
                        <uix:header textBinding="SEARCH@dbMsgs">

                                <%-- UI exit review changes
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANSFORMATION_SEARCH_INSTR@transformMsgs"/> --%>
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout width="50%" cellSpacing="5">
                                  <uix:contents>
                                    <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="SCHEMA@dbMsgs" labeledNodeId="schemaSearchName" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                        
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageLovField name="schemaSearchName" id="schemaSearchName" 
                                                                searchDescBinding="SCHEMA@dbMsgs" textBinding="schemaSearchName@transformationsListBean@servletRequest" 
                                                                 shortDescBinding="SCHEMA@dbMsgs"
                                                                 columns="30" onClick="startLov('schemaSearchName','ListSchema')"/>
                                          </uix:contents>
                                        </uix:cellFormat>                                        
                                        
                                      </uix:contents>
                                    </uix:rowLayout>
                                        
                                    <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="right">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANSFORMATION_NAME@transformMsgs" labeledNodeId="transformationSearchName" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                      
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageTextInput name="transformationSearchName" id="transformationSearchName"
                                                                  shortDescBinding="TRANSFORMATION_NAME@transformMsgs" 
                                                                  textBinding="transformationSearchName@transformationsListBean@servletRequest"/>
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                      </uix:contents>
                                    </uix:rowLayout>

                                    <uix:rowLayout width="100%">
                                        <uix:contents>
                                            <uix:cellFormat/>
                                            <uix:cellFormat/>
                                            <uix:cellFormat hAlign="left" width="75%">
                                                <uix:contents>
                                                    <uix:submitButton textBinding="GO@dbMsgs" shortDescBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                </uix:contents>
                                            </uix:cellFormat>
                                        </uix:contents>
                                    </uix:rowLayout>

                                  </uix:contents>
                                </uix:tableLayout>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                                <uix:separator/>                        
                        
                            <!--   Search contents end  -->
                        
                        <uix:tableLayout width="100%">
                          <uix:contents>
                            <uix:rowLayout hAlign="right">
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:submitButton  textBinding="CREATE@dbMsgs" shortDescBinding="CREATE_TRANSFORMATION@transformMsgs" name="event" value="create"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout width="100%">


                            <!-- Table data begin -->
                            <uix:dataScope currentDataBinding="transformationsListBean@servletRequest">
                            <uix:table name="transformationsListTable" 
                                    alternateTextBinding="tableAlternateText"
                                    formSubmitted="true"
                                    width="100%"
                                    tableDataBinding="rowData"
                                    minValue="1"
                                    valueBinding="startIndex"
                                    blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
                                    maxValueBinding="<%= StreamsConstants.NUM_ROWS %>" 
                                    shortDescBinding="TRANSFORMATION_LIST_TABLE@transformMsgs" 
                                    summaryBinding="TRANSFORMATION_LIST_TABLE@transformMsgs">
                                	
                                    <uix:tableFormat tableBanding="rowBanding"/>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="TRANSFORMATION@transformMsgs" sortable="true"/>
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="textFormat" />
                                      <uix:styledText textBinding="<%= TransformationMsgID.TRANSFORMATION %>"
                                                      destinationBinding="Transformation_URL@transformationsListBean@servletRequest" />
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="SCHEMA@transformMsgs" sortable="true"/>
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                      <uix:styledText textBinding="<%= TransformationMsgID.SCHEMA %>"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="FROM_TYPE@transformMsgs" sortable="true"/>
                                      </uix:columnHeader>
                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                      <uix:styledText textBinding="<%= TransformationMsgID.FROM_TYPE %>"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="TO_TYPE@transformMsgs" sortable="true"/>
                                      </uix:columnHeader>
                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                      <uix:styledText textBinding="<%= TransformationMsgID.TO_TYPE %>"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="ATTRIBUTE_NAME@transformMsgs" sortable="no"/>
                                      </uix:columnHeader>
                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                      <uix:styledText textBinding="<%= TransformationMsgID.ATTRIBUTE_NAME %>"/>
                                    </uix:column>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="TRANSFORMATION_EXPRESSION@transformMsgs" sortable="no"/>
                                      </uix:columnHeader>
                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                      <uix:styledText textBinding="<%= TransformationMsgID.TRANSFORMATION_EXPRESSION %>"/>
                                    </uix:column>
                                  
                                 <uix:tableSelection>
                                          <uix:singleSelection selectedIndex = "0" shortDescBinding="TABLE_SELECTION@aqMsgs">
                                               <uix:contents>
                                                    <uix:submitButton textBinding ="EDIT@dbMsgs" shortDescBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                                    <uix:submitButton textBinding ="DELETE@dbMsgs"  shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                                </uix:contents>
                                           </uix:singleSelection>
                                 </uix:tableSelection>

                            </uix:table>
                            </uix:dataScope>
                            <!-- Table data end -->

                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        </uix:header>

                        <uix:header textBinding="RELATED_LINKS@streamsMsgs">
                            <uix:bulletedList>
                            <uix:link textBinding="STREAMS_ADMINISTRATION@streamsMsgs" destinationBinding="AdministrationURL@servletRequest"/>
                            <uix:link textBinding="MANAGE_QUEUE_TABLES@streamsMsgs" destinationBinding="QueueTablesURL@servletRequest"/>
                            </uix:bulletedList>
                            <uix:spacer height="10" width="10"/>
                        </uix:header>
                      
                  </uix:contents>

                                <!--  MAIN CONTENTS END   -->
                  
                </uix:pageLayout>
                </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>
