<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="streamBundle" class="oracle.sysman.db.rsc.streams.StreamsMsg" />
<uix:bundle name="sb" class="oracle.sysman.db.rsc.streams.StrmSetupMsg" />
<uix:dataScope>
<uix:document>
          <uix:metaContainer>

            <!-- Set the page title -->
            <uix:head titleBinding="REMOVE_TITLE@streamBundle"/>
            <db:script src="/database/utils.js"/>   <%-- lovField support --%>
          </uix:metaContainer>
		  <%-- <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');"> --%>
          
		  <db:form name="removeSchedule" method="post" destination="/console/database/dist/streams" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/removeSchedule" />
          <uix:pageLayout titleBinding="REMOVE_TITLE@streamBundle">
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>
             <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <!-- Define the content of the page here -->
<uix:tableLayout>
<uix:contents>
<uix:rowLayout>
  <uix:contents>
    <uix:cellFormat>
      <uix:contents>
        <uix:spacer height="10" width="20"/>
      </uix:contents>
    </uix:cellFormat>

    <uix:cellFormat>
      <uix:contents>
          <uix:styledText textBinding="TIMEZONE@streamBundle" styleClass="OraInstructionText"/>
      </uix:contents>
    </uix:cellFormat>
    <uix:cellFormat>
      <uix:contents>
        <uix:spacer height="10" width="10"/>
      </uix:contents>
    </uix:cellFormat>
    <uix:cellFormat>
      <uix:contents>
          <uix:styledText textBinding="REPOSITORY@streamBundle" styleClass="OraDataText"/>
      </uix:contents>
    </uix:cellFormat>
   </uix:contents>
</uix:rowLayout>
</uix:contents>
</uix:tableLayout>

           <%@ include file="/sdk/schedule/start.jspf" %> 
           <uix:header textBinding="HOST_CREDS@streamBundle">
            <uix:contents>
              <uix:spacer height="10" width="10"/>
              <uix:tableLayout >
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:labeledFieldLayout width="70%">
                            <uix:contents>
                              <uix:messageTextInput name="host_user" promptBinding="HOST_USER@streamBundle"  shortDescBinding="HOST_USER@streamBundle" 
							  noAutoComplete="true" />
                              <uix:messageTextInput name="host_pwd" promptBinding="HOST_PASSWORD@streamBundle" tipBinding="HOST_TIP@streamBundle" secret="true"  shortDescBinding="HOST_PASSWORD@streamBundle" 
							  noAutoComplete="true" />
                            </uix:contents>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:contents>
          </uix:header>



            <!-- Contents of the page ends here -->
              </uix:contents>


         <!-- navigation -->

        <uix:pageButtons>
             <uix:pageButtonBar>
                <uix:contents>
					<uix:submitButton textBinding="CANCEL@streamBundle" name="event"  value="cancelRemoveStreamsSchedule" shortDescBinding="CANCEL@streamBundle" />
					<uix:submitButton textBinding="SUBMIT@streamBundle" name="event" value="okRemoveStreams" shortDescBinding="SUBMIT@streamBundle" />

                </uix:contents>
             </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:pageStatus>
             <uix:styledText styleClass="OraInstructionText" textBinding="REMOVE_KEYINFO@streamBundle"/>
        </uix:pageStatus>

      
  </uix:pageLayout>
  </db:form>
  <%-- </uix:body> --%>
 </uix:document>
</uix:dataScope>
</uix:renderingContext>


