<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<% 
  request.setAttribute("rulesBundle", new BundleDataObject(NLSUtil.getBundle(RulesMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <!-- Set the page title -->
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <db:form name="viewRuleSet" method="post" destination="/console/database/dist/streams/rules" copyParams="target,type, otype,objectType,sname, oname">
      <uix:formValue name="pageName" value="/database/dist/streams/rules/createRule"/>
      <uix:pageLayout titleBinding="TITLE@servletRequest">
        <uix:messages>
          <uix:switcher childNameBinding="display@servletRequest">
            <uix:case name="true">
              <uix:messageBox messageBinding="SUCC@servletRequest" messageType="confirmation" textBinding="CONFIRMATION@rulesBundle@servletRequest"/>
            </uix:case>
          </uix:switcher>
        </uix:messages>
        <%@ include file="/database/global.jspf"%>
        <!-- main contents -->
        <uix:contents>
          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          <!-- Define the content of the page here -->
          <uix:header textBinding="RULE_SET_TYPE@rulesBundle@servletRequest">
            <uix:contents>
             <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:messageRadioButton textBinding="POSITIVE_RS@rulesBundle@servletRequest" name="ruleSetType" tipBinding="POSITIVE_RS_TIP@rulesBundle@servletRequest" value="positive" selectedValueBinding="selectedRuleSetType@servletRequest" shortDescBinding="POSITIVE_RS@rulesBundle@servletRequest"  selectedBinding="selectedRuleSetType@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:messageRadioButton textBinding="NEGATIVE_RS@rulesBundle@servletRequest" name="ruleSetType" tipBinding="NEGATIVE_RS_TIP@rulesBundle@servletRequest" value="negative" selectedValueBinding="selectedRuleSetType@servletRequest" shortDescBinding="NEGATIVE_RS@rulesBundle@servletRequest"  selectedBinding="selectedRuleSetType@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                   </uix:contents>
              </uix:tableLayout>
             </uix:contents>
          </uix:header>
          <uix:header textBinding="RULE_TYPE@rulesBundle@servletRequest">
            <uix:contents>
              <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:messageRadioButton textBinding="GLOBAL_RULE@rulesBundle@servletRequest" name="rule_type" tipBinding="GLOBAL_RULE_DEF@rulesBundle@servletRequest" valueBinding="GLOBAL_RULE@rulesBundle@servletRequest" selectedValueBinding="selectedRule@servletRequest" shortDescBinding="GLOBAL_RULE@rulesBundle@servletRequest" onClick="submitForm('viewRuleSet',true,{'event':'globalClicked'})" selectedBinding="global@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:messageRadioButton textBinding="SCHEMA_RULE@rulesBundle@servletRequest" name="rule_type" tipBinding="SCHEMA_RULE_DEF@rulesBundle@servletRequest" valueBinding="SCHEMA_RULE@rulesBundle@servletRequest" selectedValueBinding="selectedRule@servletRequest" shortDescBinding="SCHEMA_RULE@rulesBundle@servletRequest" onClick="submitForm('viewRuleSet',true,{'event':'schemaClicked'})" selectedBinding="schema@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:messageRadioButton textBinding="TABLE_RULE@rulesBundle@servletRequest" name="rule_type" tipBinding="TABLE_RULE_DEF@rulesBundle@servletRequest" valueBinding="TABLE_RULE@rulesBundle@servletRequest" selectedValueBinding="selectedRule@servletRequest" shortDescBinding="TABLE_RULE@rulesBundle@servletRequest" onClick="submitForm('viewRuleSet',true,{'event':'tableClicked'})" selectedBinding="table@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:switcher childNameBinding="showSubsetRule@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton textBinding="SUBSET_RULE@rulesBundle@servletRequest" name="rule_type" tipBinding="SUBSET_RULE_DEF@rulesBundle@servletRequest" valueBinding="SUBSET_RULE@rulesBundle@servletRequest" selectedValueBinding="subsetSelected@servletRequest" shortDescBinding="SUBSET_RULE@rulesBundle@servletRequest" onClick="submitForm('viewRuleSet',true,{'event':'subsetClicked'})" selectedBinding="subset@servletRequest"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  <uix:switcher childNameBinding="isApply@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton textBinding="MESG_RULE@rulesBundle@servletRequest" name="rule_type" tipBinding="MESG_RULE_DEF@rulesBundle@servletRequest" valueBinding="MESG_RULE@rulesBundle@servletRequest" selectedValueBinding="messageSelected@servletRequest" shortDescBinding="MESG_RULE@rulesBundle@servletRequest" onClick="submitForm('viewRuleSet',true,{'event':'messageClicked'})" selectedBinding="message@servletRequest"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  <uix:switcher childNameBinding="isPropagation@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:contents>
                          <uix:cellFormat>
                            <uix:contents>
                              <uix:messageRadioButton textBinding="MESG_PROP_RULE@rulesBundle@servletRequest" name="rule_type" tipBinding="MESG_PROP_RULE_DEF@rulesBundle@servletRequest" valueBinding="MESG_PROP_RULE@rulesBundle@servletRequest" selectedValueBinding="messagePropSelected@servletRequest" shortDescBinding="MESG_PROP_RULE@rulesBundle@servletRequest" onClick="submitForm('viewRuleSet',true,{'event':'messagePropClicked'})" selectedBinding="messageProp@servletRequest"/>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:tableLayout>
            </uix:contents>
          </uix:header>
          <spacer height="40"/>
          <uix:header textBinding="OP_TYPE@rulesBundle@servletRequest">
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:checkBox textBinding="DML_CHNG@rulesBundle@servletRequest" name="dml_changes" checkedBinding="dml_changes@servletRequest" shortDescBinding="DML_CHNG@rulesBundle@servletRequest" disabledBinding="disableDML@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat>
                    <uix:contents>
                      <uix:checkBox textBinding="DDL_CHNG@rulesBundle@servletRequest" name="ddl_changes" checkedBinding="ddl_changes@servletRequest" shortDescBinding="DDL_CHNG@rulesBundle@servletRequest" disabledBinding="disableDDL@servletRequest"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>
            </uix:contents>
          </uix:header>
          <spacer height="20" width="10"/>
          <uix:hideShowHeader textBinding="UDC@rulesBundle@servletRequest" disclosedBinding="ToShow@servletRequest" formSubmitted="true">
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:contents>
                    <uix:spacer height="10" width="25"/>
                  </uix:contents>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:contents>
                    <uix:textInput name="udc" rows="3" columns="70" shortDescBinding="UDC@rulesBundle@servletRequest" disabledBinding="disableUDC@servletRequest"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:hideShowHeader>
          <uix:header textBinding="RELATED_LINKS@rulesBundle@servletRequest" styleClass="OraHeaderSubSub">
            <uix:contents>
              <uix:spacer width="20"/>
              <uix:link textBinding="CREATE_USER_DEF_RULES@rulesBundle@servletRequest" destinationBinding="MANUAL_RULE_URL@servletRequest" styleClass="OraLinkText"/>
            </uix:contents>
          </uix:header>
          <!-- page contents end here -->
        </uix:contents>
        <!-- navigation -->
        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:contents>
              <uix:submitButton name="event" value="cancelCreateRule" textBinding="CANCEL@rulesBundle@servletRequest" shortDescBinding="CANCEL@rulesBundle@servletRequest"/>
              <uix:submitButton name="event" value="okCreateRule" textBinding="OK@rulesBundle@servletRequest" shortDescBinding="OK@rulesBundle@servletRequest"/>
            </uix:contents>
          </uix:pageButtonBar>
        </uix:pageButtons>
        <uix:pageStatus/>
      </uix:pageLayout>
    </db:form>
  </uix:document>
</uix:renderingContext>
