<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js" />
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("rulesBundle", new BundleDataObject(NLSUtil.getBundle(RulesMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>
          <db:form name="createUserRule" method="post" destination="/console/database/dist/streams/rules" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/rules/createUserRule" />
          <uix:pageLayout titleBinding="TITLE@servletRequest">
          <uix:messages>
              <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
              <uix:switcher childNameBinding="display@servletRequest">
             <uix:case name="true">
               <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                                  textBinding="CONFIRMATION@rulesBundle@servletRequest"/>
             </uix:case>
             </uix:switcher>
            <uix:switcher childNameBinding="displayError@servletRequest">
             <uix:case name="true">
              <uix:messageBox messageBinding="ERR@servletRequest" messageType="error"
                                  textBinding="ERROR@rulesBundle@servletRequest"/>
             </uix:case>
            </uix:switcher>
          </uix:messages>
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>
 <!-- Define the content of the page here -->
  <uix:header textBinding="RULE_SET_TYPE@rulesBundle@servletRequest">
            <uix:contents>
             <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:messageRadioButton textBinding="POSITIVE_RS@rulesBundle@servletRequest" name="ruleSetType" tipBinding="POSITIVE_RS_TIP@rulesBundle@servletRequest" value="positive" selectedValueBinding="selectedRuleSetType@servletRequest" shortDescBinding="POSITIVE_RS@rulesBundle@servletRequest"  selectedBinding="selectedRuleSetType@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:messageRadioButton textBinding="NEGATIVE_RS@rulesBundle@servletRequest" name="ruleSetType" tipBinding="NEGATIVE_RS_TIP@rulesBundle@servletRequest" value="negative" selectedValueBinding="selectedRuleSetType@servletRequest" shortDescBinding="NEGATIVE_RS@rulesBundle@servletRequest"  selectedBinding="selectedRuleSetType@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                   </uix:contents>
              </uix:tableLayout>
             </uix:contents>
          </uix:header>
 <uix:header textBinding="RULE_DEFINITION@rulesBundle@servletRequest">
  <uix:contents>
  <uix:tableLayout width="62%"  >
    <uix:contents>
       <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat>
              <uix:contents>
                <uix:labeledFieldLayout>
                  <uix:contents>
              <uix:styledText styleClass="OraInstructionText" textBinding="RULE_NAME@rulesBundle@servletRequest" labeledNodeId="rule_name" />
              <uix:textInput columns="50"  name="rule_name"  id="rule_name" shortDescBinding="RULE_NAME@rulesBundle@servletRequest" />
              <uix:styledText styleClass="OraInstructionText" textBinding="RULE_CONDITION@rulesBundle@servletRequest" labeledNodeId="condition" />
              <uix:textInput rows="8" columns="90"  name="condition" id="condition" shortDescBinding="RULE_CONDITION@rulesBundle@servletRequest" />
              <uix:styledText styleClass="OraInstructionText" textBinding="ASSC_TRANS@rulesBundle@servletRequest" labeledNodeId="trans" />
              <uix:lovField name="trans" id="trans" columns="50"  onClick="startLov('trans','ListFunction')" shortDescBinding="ASSC_TRANS@rulesBundle@servletRequest" />
              <uix:spacer height="4" width="40" />
              <uix:styledText styleClass="OraInlineInfoText" textBinding="TRANS_TIP@rulesBundle@servletRequest" />

              </uix:contents>
                </uix:labeledFieldLayout>
              </uix:contents>
            </uix:cellFormat>
           </uix:contents>
        </uix:rowLayout>
     </uix:contents>
 </uix:tableLayout>
 </uix:contents>
 </uix:header>
 <uix:header textBinding="RELATED_LINKS@rulesBundle@servletRequest" styleClass="OraHeaderSubSub" >
       <uix:contents>
        <uix:spacer width="20" />
        <uix:link textBinding="PLSQL_FUNC@rulesBundle@servletRequest" destinationBinding="PLSQL_FUNC_URL@servletRequest" styleClass="OraLinkText" />
       </uix:contents>
    </uix:header>

             
 <!-- page contents end here -->

          </uix:contents>

         <!-- navigation -->
         <uix:pageButtons>
          <uix:pageButtonBar>
               <uix:contents>
                 <uix:submitButton name="event" value="cancelUserRule" textBinding="CANCEL@rulesBundle@servletRequest" shortDescBinding="CANCEL@rulesBundle@servletRequest" />
                 <uix:submitButton name="event" value="okUserRule" textBinding="OK@rulesBundle@servletRequest" shortDescBinding="OK@rulesBundle@servletRequest" />
               </uix:contents>
          </uix:pageButtonBar>
         </uix:pageButtons>
        
        <uix:pageStatus>
        </uix:pageStatus>
        
      
  </uix:pageLayout>
  </db:form>
 </uix:document>
</uix:renderingContext>



