<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<db:script src="/database/LOV.js" />
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsgID" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("rulesBundle", new BundleDataObject(NLSUtil.getBundle(RulesMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="rulesMsgs" class="oracle.sysman.db.rsc.streams.RulesMsg"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>
          <db:form name="editRule" method="post" destination="/console/database/dist/streams/rules" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/rules/editRule" />
          <uix:formValue name="rule_name" valueBinding="RULE_NAME@servletRequest" />
          <uix:formValue name="condition_old" valueBinding="RULE_CONDITION@servletRequest" />
          <uix:formValue name="trans_old" valueBinding="TRANS_FUNC@servletRequest" />

          <uix:pageLayout titleBinding="TITLE@servletRequest">
          <uix:messages>
          <uix:switcher childNameBinding="display@servletRequest">
             <uix:case name="true">
               <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                                  textBinding="CONFIRMATION@rulesBundle@servletRequest"/>
             </uix:case>
             </uix:switcher>
            <uix:switcher childNameBinding="displayError@servletRequest">
             <uix:case name="true">
              <uix:messageBox messageBinding="ERR@servletRequest" messageType="error"
                                  textBinding="ERROR@rulesBundle@servletRequest"/>
             </uix:case>
            </uix:switcher>
            <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

          </uix:messages>
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>

              <!-- Define the content of the page here -->

<uix:tableLayout width="100%"  >
    <uix:contents>
       <uix:rowLayout>
          <uix:contents>
  				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="30" width="30"/>
				  </uix:contents>
				</uix:cellFormat>

            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:contents>
                <uix:tableLayout>
                  <uix:rowLayout>
                      <uix:cellFormat width="50%" hAlign="right" vAlign="top">
                            <uix:styledText styleClass="OraInstructionText" textBinding="RULE_SET_NAME@rulesBundle@servletRequest" />
                      </uix:cellFormat>
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>
                    <uix:cellFormat width="50%" hAlign="left" vAlign="top">
                        <uix:styledText styleClass="OraDataText"  textBinding="RULE_SET@servletRequest" />
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="center" width="100%">
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat width="50%" hAlign="right" vAlign="top">
                        <uix:styledText styleClass="OraInstructionText" textBinding="RULE_NAME@rulesBundle@servletRequest" />
                    </uix:cellFormat>
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>
                    <uix:cellFormat width="50%" hAlign="left" vAlign="top">
                        <uix:styledText styleClass="OraDataText"  textBinding="RULE_NAME@servletRequest" />
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="center" width="100%">
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat width="20%" hAlign="right" vAlign="top">
                        <uix:styledText styleClass="OraInstructionText" textBinding="RULE_CONDITION@rulesBundle@servletRequest" labeledNodeId="condition" />
                    </uix:cellFormat>
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>

                    <uix:cellFormat width="50%" hAlign="left" vAlign="top">
                        <uix:textInput rows="8" columns="80"  id="condition" name="condition" textBinding="RULE_CONDITION@servletRequest" />
                    </uix:cellFormat>

			  <%-- 
			  <uix:styledText styleClass="OraInstructionText" textBinding="ASSC_TRANS@rulesBundle@servletRequest" labeledNodeId="trans" />
              <uix:lovField name="trans" id="trans" columns="30"  onClick="startLov('trans','ListFunction')" textBinding="TRANS_FUNC@servletRequest" shortDescBinding="ASSC_TRANS@rulesBundle@servletRequest" />
              <uix:spacer height="4" width="40" />
              <uix:styledText styleClass="OraInlineInfoText" textBinding="TRANS_TIP@rulesBundle@servletRequest" />
			  --%>
              </uix:rowLayout>
              <uix:rowLayout hAlign="center" width="100%">
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
              </uix:contents>
            </uix:cellFormat>

            <uix:cellFormat hAlign="right" width="40%"  vAlign="top">
          
             <uix:contentContainer width="80%" background="light">

                    <uix:styledText styleClass="OraInstructionText"     textBinding="EDIT_RULE_TIP@rulesBundle@servletRequest"/>
                      <uix:bulletedList>
                      <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText"     textBinding="EDIT_RULE_TIP1@rulesBundle@servletRequest"/>
                                    <uix:styledText styleClass="OraInstructionText"     textBinding="EDIT_RULE_TIP2@rulesBundle@servletRequest"/>
                                    <uix:styledText styleClass="OraInstructionText"     textBinding="EDIT_RULE_TIP3@rulesBundle@servletRequest"/>
                                    <uix:styledText styleClass="OraInstructionText"     textBinding="EDIT_RULE_TIP4@rulesBundle@servletRequest"/>
									<uix:styledText styleClass="OraInstructionText"     textBinding="EDIT_RULE_TIP5@rulesBundle@servletRequest"/>
                      </uix:contents>
                      </uix:bulletedList>
					<uix:spacer height="10" width="30"/>
                    </uix:contentContainer>
              </uix:cellFormat>
		
           </uix:contents>
        </uix:rowLayout>
     </uix:contents>
 </uix:tableLayout>


		<%---- Changes for declarative rule based transformation BEGIN  ---%>

		<uix:header textBinding="ASSC_TRANS@rulesMsgs">
                <uix:tableLayout>
                <uix:rowLayout>
                <uix:cellFormat hAlign="left" width="60%" vAlign="top">
		<uix:tableLayout>
			<uix:rowLayout>
				<uix:cellFormat>
					<%-- We can have both custom rule based transformation and Dec transformation
					<uix:messageCheckBox name="crbTransformation" value="crbTransformation"
					textBinding="CUSTOM_RULE_BASED_TRANSFORMATION@rulesMsgs" 
					labeledNodeId="crbTransformation" 
					checked="true"/> --%>
					<uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="crbTransformation"
						textBinding="CUSTOM_RULE_BASED_TRANSFORMATION@rulesMsgs" />
				</uix:cellFormat>
			</uix:rowLayout>
			<uix:rowLayout>
				<uix:cellFormat>
					<uix:tableLayout>
						<uix:rowLayout>
							<uix:cellFormat>
								<uix:spacer width="30" height="10"/>
							</uix:cellFormat>
							<uix:cellFormat>
								<uix:messageLovField name="trans"  columns="60" 
								id="crbTransformation" 
								onClick="startLov('trans','ListFunction')" 
								textBinding="TRANS_FUNC@servletRequest" 
								tipBinding="TRANS_TIP@rulesMsgs"/>
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>
				</uix:cellFormat>
			</uix:rowLayout>

			<%-- Space between two fields--%>
			<uix:rowLayout hAlign="center" width="100%">
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>
			</uix:rowLayout>
<uix:rowLayout renderedBinding="isDMLRule@servletRequest">
<uix:tableLayout>

			<uix:rowLayout>
                        
                                            <uix:cellFormat>	
                                                    <%-- We can have both custom rule based transformation and Dec transformation
                                                    <uix:messageCheckBox name="drbTransformation" value="drbTransformation"
                                                    textBinding="DECLARATIVE_RULE_BASED_TRANSFORMATION@rulesMsgs" 
                                                    labeledNodeId="drbTransformation" 
                                                    checked="false"/> --%>
                                                    <uix:messageStyledText styleClass="OraInstructionText" labeledNodeId="drbTransformation"
                                                            textBinding="DECLARATIVE_RULE_BASED_TRANSFORMATION@rulesMsgs" />
                                            </uix:cellFormat>
                           
			</uix:rowLayout>

			<%--<uix:rowLayout>
				<uix:cellFormat hAlign="right" width="10">
				<uix:submitButton textBinding="ADD@dbMsgs" 
								  shortDescBinding="ADD@dbMsgs" 
								  name="event" value="addDeclTrans"/>

				</uix:cellFormat>
			</uix:rowLayout>
			--%>

			<%-- Space between two fields--%>
			<uix:rowLayout hAlign="center" width="100%">
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="5" width="5"/>
				  </uix:contents>
				</uix:cellFormat>
			</uix:rowLayout>


			<uix:rowLayout width="100%">
                         
			<uix:cellFormat width="100%">
			<uix:tableLayout width="100%">
			  <uix:contents>
				<uix:rowLayout width="100%">
				  <uix:contents>
					<uix:cellFormat>
					  <uix:contents>
						<uix:spacer height="10" width="25"/>
					  </uix:contents>
					</uix:cellFormat>
					<uix:cellFormat width="100%">


					<!-- Table data begin -->
					
					<uix:dataScope currentDataBinding="declarativeTransListBean@servletRequest">
					<uix:table name="declTransListTable" 
							alternateTextBinding="NO_ITEMS_FOUND@dbMsgs" 
							width="100%"
							formSubmitted="true"
							tableDataBinding="rowData"
							minValue="1"
							valueBinding="startIndex"
							blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
							maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
							shortDescBinding="DECLARATIVE_RULE_BASED_TRANSFORMATION@rulesMsgs"
							summaryBinding="DECLARATIVE_RULE_BASED_TRANSFORMATION@rulesMsgs">

							<uix:tableFormat tableBanding="rowBanding"/>
							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader textBinding="DECLARATIVE_TYPE@rulesMsgs" />
							  </uix:columnHeader> 
							  <uix:columnFormat columnDataFormat="textFormat" />
							  <uix:styledText textBinding="<%= RulesMsgID.DECLARATIVE_TYPE %>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader textBinding="STEP_NUMBER@rulesMsgs" />
							  </uix:columnHeader> 
							  <uix:columnFormat columnDataFormat="numberFormat" />
							  <uix:styledText textBinding="<%= RulesMsgID.STEP_NUMBER %>"/>
							</uix:column>

							<uix:column>
							  <uix:columnHeader>
								<uix:sortableHeader textBinding="DESCRIPTION@rulesMsgs" />
							  </uix:columnHeader> 
							  <uix:columnFormat columnDataFormat="textFormat" />
							  <uix:styledText textBinding="<%= RulesMsgID.DESCRIPTION %>"/>
							</uix:column>


						<uix:tableActions>
							<uix:cellFormat rendered="true" >								

							<uix:tableLayout>
								<uix:rowLayout width="100%">
									<uix:cellFormat vAlign="center">
										<uix:messageStyledText styleClass="OraInstructionText" textBinding="ADD@dbMsgs" />
									</uix:cellFormat>

									<uix:cellFormat>
									  <uix:contents>
										<uix:spacer height="10" width="10"/>
									  </uix:contents>
									</uix:cellFormat>

									<uix:cellFormat>
										<uix:messageChoice name="actionType">
											<uix:option textBinding="ADD_COLUMN@rulesMsgs" value="ADD_COLUMN"/>
											<uix:option textBinding="DELETE_COLUMN@rulesMsgs" value="DELETE_COLUMN"/>
											<uix:option textBinding="RENAME_COLUMN@rulesMsgs" value="RENAME_COLUMN"/>
											<uix:switcher childNameBinding="is11g2@servletRequest">
												<uix:case name="true">

												<uix:option textBinding="KEEP_COLUMN@rulesMsgs" value="KEEP_COLUMN"/>
                                                </uix:case>
                                            </uix:switcher>
											<uix:option textBinding="RENAME_SCHEMA@rulesMsgs" value="RENAME_SCHEMA"/>
											<uix:option textBinding="RENAME_TABLE@rulesMsgs" value="RENAME_TABLE"/>
										</uix:messageChoice>

									</uix:cellFormat>

									<uix:cellFormat>
										<uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" name="event" value="action"/>
									</uix:cellFormat>


								</uix:rowLayout>
							 </uix:tableLayout>

							</uix:cellFormat> 
						</uix:tableActions>

						 <uix:tableSelection>
							  <uix:singleSelection  shortDescBinding="TABLE_SELECTION@rulesMsgs" selectedIndex="0">
										<uix:submitButton textBinding="EDIT@dbMsgs" 
														  shortDescBinding="EDIT@dbMsgs" 
														  name="event" value="editDeclTrans"/>

										<uix:submitButton textBinding="REMOVE@dbMsgs" 
														  shortDescBinding="REMOVE@dbMsgs" 
														  name="event" value="deleteDeclTrans"/>

										<%-- 
										<uix:messageChoice name="actionType">
											<uix:option textBinding="ADD_COLUMN@rulesMsgs" valueBinding="<%= RulesMsgID.ADD_COLUMN %>"/>
											<uix:option textBinding="DELETE_COLUMN@rulesMsgs" valueBinding="<%= RulesMsgID.DELETE_COLUMN %>"/>
											<uix:option textBinding="RENAME_COLUMN@rulesMsgs" valueBinding="<%= RulesMsgID.RENAME_COLUMN %>"/>
											<uix:option textBinding="RENAME_SCHEMA@rulesMsgs" valueBinding="<%= RulesMsgID.RENAME_SCHEMA %>"/>
											<uix:option textBinding="RENAME_TABLE@rulesMsgs" valueBinding="<%= RulesMsgID.RENAME_TABLE %>"/>
										</uix:messageChoice>

										<uix:submitButton shortDescBinding="GO@dbMsgs" 
														  textBinding="GO@dbMsgs" 
														  name="event" 
														  value="action"/>
										--%>

							   </uix:singleSelection>
						 </uix:tableSelection>

					</uix:table>
					</uix:dataScope>

					<!-- Table data end -->
										  
					</uix:cellFormat>
				  </uix:contents>
				</uix:rowLayout>
			  </uix:contents>
			</uix:tableLayout>
            </uix:cellFormat>
                      
			</uix:rowLayout>
                        <uix:rowLayout hAlign="center" width="100%">
				<uix:cellFormat>
				  <uix:contents>
					<uix:spacer height="10" width="10"/>
				  </uix:contents>
				</uix:cellFormat>
			</uix:rowLayout>
                        </uix:tableLayout>
</uix:rowLayout>
			<uix:rowLayout>
				<uix:cellFormat>
					<uix:tableLayout>
						<uix:rowLayout>
							<uix:cellFormat>
								<uix:spacer width="30" height="10"/>
							</uix:cellFormat>
							<uix:cellFormat>
							  <uix:tip />
							</uix:cellFormat>
							<uix:cellFormat>
								<uix:styledText styleClass="OraTipText" 
									textBinding="DT_TABLE_TIP@rulesMsgs"/>
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>
				</uix:cellFormat>
			</uix:rowLayout>
		</uix:tableLayout>
		</uix:cellFormat>
               
                <uix:cellFormat hAlign="right" width="40%" rowSpan="1" vAlign="top" renderedBinding="isDMLRule@servletRequest">
                            
                             <uix:contentContainer width="80%" background="light">
                
                                    <uix:styledText styleClass="OraInstructionText"     textBinding="ADD_TRANS_TIP@rulesBundle@servletRequest"/>
                                      <uix:bulletedList>
                                      <uix:contents>
                                                    <uix:styledText styleClass="OraInstructionText"     textBinding="ADD_TRANS_TIP1@rulesBundle@servletRequest"/>
                                                    <uix:styledText styleClass="OraInstructionText"     textBinding="ADD_TRANS_TIP2@rulesBundle@servletRequest"/>
                                                    <uix:styledText styleClass="OraInstructionText"     textBinding="ADD_TRANS_TIP3@rulesBundle@servletRequest"/>
                                                    <uix:styledText styleClass="OraInstructionText"     textBinding="ADD_TRANS_TIP4@rulesBundle@servletRequest"/>
                                      </uix:contents>
                                      </uix:bulletedList>
                                            
                                    </uix:contentContainer>
                              </uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
                </uix:header>

		<%---- Changes for declarative rule based transformation END  ---%>



 <uix:header textBinding="RELATED_LINKS@rulesBundle@servletRequest" styleClass="OraHeaderSubSub" >
       <uix:contents>
        <uix:spacer width="20" />
        <uix:link textBinding="PLSQL_FUNC@rulesBundle@servletRequest" destinationBinding="PLSQL_FUNC_URL@servletRequest" styleClass="OraLinkText" />
       </uix:contents>
    </uix:header>

             
 <!-- page contents end here -->

          </uix:contents>

         <!-- navigation -->
         <uix:pageButtons>
          <uix:pageButtonBar>
               <uix:contents>
                 <uix:submitButton name="event" value="cancelEditRule" textBinding="CANCEL@rulesBundle@servletRequest" shortDescBinding="CANCEL@rulesBundle@servletRequest" />
                 <uix:submitButton name="event" value="okEditRule" textBinding="OK@rulesBundle@servletRequest" shortDescBinding="OK@rulesBundle@servletRequest" />
               </uix:contents>
          </uix:pageButtonBar>
         </uix:pageButtons>
        
        <uix:pageStatus>
        </uix:pageStatus>
        
      
  </uix:pageLayout>
  </db:form>
 </uix:document>
</uix:renderingContext>




