<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js" />
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("rulesBundle", new BundleDataObject(NLSUtil.getBundle(RulesMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>
          <db:form name="messageRule" method="post" destination="/console/database/dist/streams/rules" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/rules/messageRule" />
          <uix:formValue name="owner"  valueBinding="loginUser@servletRequest" />

          <uix:pageLayout titleBinding="TITLE@servletRequest">
          <uix:messages>
          <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>

<uix:spacer height="10" width="10" />

<uix:tableLayout>
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:labeledFieldLayout width="60%">
                            <uix:contents>
<uix:messageLovField name="message_type" id="message_type" textBinding="msgType@servletRequest" promptBinding="MT@rulesBundle@servletRequest" onClick="setSearchFilter('owner'); startLov('message_type', 'ListTypes')" shortDescBinding="MT@rulesBundle@servletRequest" />
<uix:messageTextInput name="rule_cond" promptBinding="RC@rulesBundle@servletRequest" rows="5" columns="72" shortDescBinding="RC@rulesBundle@servletRequest" />
                            </uix:contents>
                          </uix:labeledFieldLayout>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
 



</uix:contents>
 <uix:pageButtons>
             <uix:pageButtonBar>
                <uix:contents>
                    <uix:submitButton textBinding="CANCEL@rulesBundle@servletRequest" name="event" value="cancelMesgRule" shortDescBinding="CANCEL@rulesBundle@servletRequest" />
                    <uix:submitButton textBinding="OK@rulesBundle@servletRequest" name="event" value="okMesgRule" shortDescBinding="OK@rulesBundle@servletRequest" />
                </uix:contents>
             </uix:pageButtonBar>
        </uix:pageButtons>
        
        <uix:pageStatus>
             <uix:styledText styleClass="OraInstructionText" textBinding="MESG_RULE_DEFINITION@rulesBundle@servletRequest"/>
        </uix:pageStatus>



  </uix:pageLayout>
  </db:form>
 </uix:document>
</uix:renderingContext>


