<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="rulesMsgs" class="oracle.sysman.db.rsc.streams.RulesMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

            <uix:body>
			<db:form name="renameColumnForm" method="post" destination="/console/database/dist/streams/rules" 
			copyParams="target,type, otype,objectType,sname, oname">
            <uix:formValue name="pageName" value="/database/dist/streams/rules/renameColumn"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>

					  <!-- main contents -->
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="100%">

                            <!-- ROW: Rule Name -->						  
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="RULE_NAME@rulesMsgs" labeledNodeId="ruleName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="ruleName@declarativeTransBean@servletRequest" id="ruleName" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <!-- ROW: Table Name -->
                            <uix:rowLayout width="100%" hAlign="center">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="TABLE_NAME@rulesMsgs" labeledNodeId="tableName"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isNew@servletRequest">
                                  <uix:contents>
                                    <uix:messageLovField name="tableName" 
														 textBinding="tableName@declarativeTransBean@servletRequest"
                                                         columns="50" id="tableName"
                                                         shortDescBinding="TABLE_NAME@rulesMsgs" 
                                                         onClick="startLov('tableName','ListTable')" />
                                    <uix:messageText messageBinding="tableName@errors@servletRequest" 
									messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isExisting@servletRequest">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="tableName@declarativeTransBean@servletRequest" id="tableName" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                            <!-- ROW: Table Name Hint-->
                            <uix:rowLayout renderedBinding="isNew@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" 
										textBinding="TABLE_INPUT_HINT@rulesMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>	

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>
							
							<!-- ROW: From Column Name -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="FROM_COLUMN_NAME@rulesMsgs" labeledNodeId="fromColumnName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isNew@servletRequest">
                                  <uix:contents>
                                    <uix:messageTextInput name="fromColumnName" id="fromColumnName" 
										textBinding="fromColumnName@declarativeTransBean@servletRequest" 
                                        columns="50" 
									    shortDescBinding="FROM_COLUMN_NAME@rulesMsgs"/>
                                    <uix:messageText messageBinding="fromColumnName@errors@servletRequest" 
													 messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isExisting@servletRequest">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="fromColumnName@declarativeTransBean@servletRequest" id="fromColumnName" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>
							
							<!-- ROW: To Column Name -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="TO_COLUMN_NAME@rulesMsgs" labeledNodeId="toColumnName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="toColumnName" id="toColumnName" 
										textBinding="toColumnName@declarativeTransBean@servletRequest" 
                                        columns="50" 
									    shortDescBinding="TO_COLUMN_NAME@rulesMsgs"/>
                                    <uix:messageText messageBinding="toColumnName@errors@servletRequest" 
													 messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
							
							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <!-- ROW: Value Type -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="VALUE_TYPE@rulesMsgs" labeledNodeId="valueType"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
										<uix:messageChoice name="valueType">
											<uix:option textBinding="NEW@rulesMsgs" value="NEW"/>
											<uix:option textBinding="OLD@rulesMsgs" value="OLD"/>
											<uix:option text="*" value="*"/>
										</uix:messageChoice>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

							<%-- Hint text--%>
							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" 
										textBinding="RENAMECOL_VALUE_TYPE_HINT@rulesMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>	

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<!-- ROW: Step number -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="STEP_NUMBER@rulesMsgs" labeledNodeId="stepNumber"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isNew@servletRequest">
                                  <uix:contents>
										<uix:messageChoice name="stepNumber" 
											selectedValueBinding="stepNumber@declarativeTransBean@servletRequest">
											<uix:option text="0" value="0"/>
											<uix:option text="1" value="1"/>
											<uix:option text="2" value="2"/>
											<uix:option text="3" value="3"/>
											<uix:option text="4" value="4"/>
											<uix:option text="5" value="5"/>
										</uix:messageChoice>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isExisting@servletRequest">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="stepNumber@declarativeTransBean@servletRequest" id="stepNumber" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

							<%-- Hint text--%>
							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<uix:rowLayout renderedBinding="isNew@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" 
										textBinding="STEP_NUMBER_HINT@rulesMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>									

                        </uix:tableLayout>
                        <uix:spacer height="15" width="10"/>

                      <!-- navigation -->
                      <uix:tabs/>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<%-- <uix:submitButton textBinding="SHOWSQL@dbMsgs" shortDescBinding="SHOWSQL@dbMsgs" 
							name="event" value="showSql"  /> --%>
							<uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" 
							name="event" value="cancelAddDecTransformation"/>
                            <uix:submitButton textBinding="OK@dbMsgs" shortDescBinding="OK@dbMsgs" 
							name ="event" value="addDecTransformation" />
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                </uix:pageLayout>
                </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>
