<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="rulesMsgs" class="oracle.sysman.db.rsc.streams.RulesMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

            <uix:body>
			<db:form name="renameSchemaForm" method="post" destination="/console/database/dist/streams/rules" 
			copyParams="target,type, otype,objectType,sname, oname">
            <uix:formValue name="pageName" value="/database/dist/streams/rules/renameSchema"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>

					  <!-- main contents -->
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="100%">

                            <!-- ROW: Transfromation Name -->						  
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="RULE_NAME@rulesMsgs" labeledNodeId="ruleName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="ruleName@declarativeTransBean@servletRequest" id="ruleName" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<!-- ROW: From Schema Name -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="FROM_SCHEMA_NAME@rulesMsgs" labeledNodeId="fromSchemaName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isNew@servletRequest">
                                  <uix:contents>
                                    <uix:messageTextInput name="fromSchemaName" id="fromSchemaName" 
										textBinding="fromSchemaName@declarativeTransBean@servletRequest" 
                                        columns="50" shortDescBinding="FROM_SCHEMA_NAME@rulesMsgs"/>
                                    <uix:messageText messageBinding="fromSchemaName@errors@servletRequest" 
													 messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isExisting@servletRequest">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="fromSchemaName@declarativeTransBean@servletRequest" id="fromSchemaName" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>
							
							<!-- ROW: To Schema Name -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="TO_SCHEMA_NAME@rulesMsgs" labeledNodeId="toSchemaName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageTextInput name="toSchemaName" id="toSchemaName" 
										textBinding="toSchemaName@declarativeTransBean@servletRequest" 
                                        columns="50" 
									    shortDescBinding="TO_SCHEMA_NAME@rulesMsgs"/>
                                    <uix:messageText messageBinding="toSchemaName@errors@servletRequest" 
													 messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
							
							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<!-- ROW: Step number -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="STEP_NUMBER@rulesMsgs" labeledNodeId="stepNumber"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isNew@servletRequest">
                                  <uix:contents>
										<uix:messageChoice name="stepNumber" 
											selectedValueBinding="stepNumber@declarativeTransBean@servletRequest">
											<uix:option text="0" value="0"/>
											<uix:option text="1" value="1"/>
											<uix:option text="2" value="2"/>
											<uix:option text="3" value="3"/>
											<uix:option text="4" value="4"/>
											<uix:option text="5" value="5"/>
										</uix:messageChoice>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isExisting@servletRequest">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="stepNumber@declarativeTransBean@servletRequest" id="stepNumber" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

							<%-- Hint text--%>
							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<uix:rowLayout renderedBinding="isNew@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" 
										textBinding="STEP_NUMBER_HINT@rulesMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>									

                        </uix:tableLayout>
                        <uix:spacer height="15" width="10"/>

                      <!-- navigation -->
                      <uix:tabs/>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<%-- <uix:submitButton textBinding="SHOWSQL@dbMsgs" shortDescBinding="SHOWSQL@dbMsgs" 
							name="event" value="showSql"  /> --%>
							<uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" 
							name="event" value="cancelAddDecTransformation"/>
                            <uix:submitButton textBinding="OK@dbMsgs" shortDescBinding="OK@dbMsgs" 
							name ="event" value="addDecTransformation" />
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                </uix:pageLayout>
                </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>
