<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
<uix:bundle name="rulesMsgs" class="oracle.sysman.db.rsc.streams.RulesMsg"/>

        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>

            <uix:body>
			<db:form name="renameTableForm" method="post" destination="/console/database/dist/streams/rules" 
			copyParams="target,type, otype,objectType,sname, oname">
            <uix:formValue name="pageName" value="/database/dist/streams/rules/renameTable"/>
            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
            
            <uix:pageLayout titleBinding="header@servletRequest">
            
            <%@ include file="/database/global.jspf" %>
            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>

					  <!-- main contents -->
                        <uix:spacer height="10" width="10"/>
                        <uix:tableLayout width="100%">

                            <!-- ROW: Rule Name -->						  
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="RULE_NAME@rulesMsgs" labeledNodeId="ruleName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="ruleName@declarativeTransBean@servletRequest" id="ruleName" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<!-- ROW: From Table Name -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="FROM_TABLE_NAME@rulesMsgs" labeledNodeId="fromTableName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isNew@servletRequest">
                                  <uix:contents>
                                    <uix:messageLovField name="fromTableName" 
											textBinding="fromTableName@declarativeTransBean@servletRequest"
                                            columns="50" id="fromTableName"
                                            shortDescBinding="FROM_TABLE_NAME@rulesMsgs" 
                                            onClick="startLov('fromTableName','ListTable')" />
                                    <uix:messageText messageBinding="fromTableName@errors@servletRequest" 
									messageType="error"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isExisting@servletRequest">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="fromTableName@declarativeTransBean@servletRequest" id="fromTableName" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            

                            <!-- ROW: Table Name Hint-->
                            <uix:rowLayout renderedBinding="isNew@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" 
										textBinding="TABLE_INPUT_HINT@rulesMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>	

							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>
							
							<!-- ROW: To Table Name -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="TO_TABLE_NAME@rulesMsgs" labeledNodeId="toTableName" />
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:messageLovField name="toTableName" 
											textBinding="toTableName@declarativeTransBean@servletRequest"
                                            columns="50" id="toTableName"
                                            shortDescBinding="TO_TABLE_NAME@rulesMsgs" 
                                            onClick="startLov('toTableName','ListTable')" />
                                    <uix:messageText messageBinding="toTableName@errors@servletRequest" 
									messageType="error"/>

                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                            <!-- ROW: Table Name Hint-->
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" 
										textBinding="TABLE_INPUT_HINT@rulesMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>	
							
							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<!-- ROW: Step number -->
                            <uix:rowLayout hAlign="center" width="100%">
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" 
									textBinding="STEP_NUMBER@rulesMsgs" labeledNodeId="stepNumber"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="3"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isNew@servletRequest">
                                  <uix:contents>
										<uix:messageChoice name="stepNumber" 
											selectedValueBinding="stepNumber@declarativeTransBean@servletRequest" >
											<uix:option text="0" value="0"/>
											<uix:option text="1" value="1"/>
											<uix:option text="2" value="2"/>
											<uix:option text="3" value="3"/>
											<uix:option text="4" value="4"/>
											<uix:option text="5" value="5"/>
										</uix:messageChoice>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left" renderedBinding="isExisting@servletRequest">
                                  <uix:contents>
                                    <uix:messageStyledText styleClass="OraDataText" 
									textBinding="stepNumber@declarativeTransBean@servletRequest" id="stepNumber" />
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

							<%-- Hint text--%>
							<%-- Space between two fields--%>
                            <uix:rowLayout hAlign="center" width="100%">
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="5" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

							<uix:rowLayout renderedBinding="isNew@servletRequest">
                              <uix:contents>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                  <uix:contents>
                                    <uix:rowLayout>
                                      <uix:contents>
                                        <uix:messageStyledText  styleClass="OraInlineInfoText" 
										textBinding="STEP_NUMBER_HINT@rulesMsgs"/>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>									

                        </uix:tableLayout>
                        <uix:spacer height="15" width="10"/>

                      <!-- navigation -->
                      <uix:tabs/>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
							<%-- <uix:submitButton textBinding="SHOWSQL@dbMsgs" shortDescBinding="SHOWSQL@dbMsgs" 
							name="event" value="showSql"  /> --%>
							<uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" 
							name="event" value="cancelAddDecTransformation"/>
                            <uix:submitButton textBinding="OK@dbMsgs" shortDescBinding="OK@dbMsgs" 
							name ="event" value="addDecTransformation" />
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                </uix:pageLayout>
                </db:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>
