<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsgID" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsgID" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%
  request.setAttribute("rulesBundle", new BundleDataObject(NLSUtil.getBundle(RulesMsg.class.getName(), request)));
  request.setAttribute("streamsBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg" />
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>
<uix:dataScope currentDataBinding="schemaListBean@servletRequest">


          <db:form name="schemaRule" method="post" destination="/console/database/dist/streams/rules" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/rules/schemaRule" />
          <uix:pageLayout titleBinding="TITLE@servletRequest">
          <%@ include file="/database/global.jspf" %>       

          <!-- main contents -->
          <uix:contents>
             <uix:switcher childNameBinding="display@servletRequest">
                <uix:case name="true">
                  <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                                  textBinding="CONFIRMATION@rulesBundle@servletRequest"/>
                </uix:case>
             </uix:switcher>
             <uix:switcher childNameBinding="displayError@servletRequest">
                <uix:case name="true">
                  <uix:messageBox messageBinding="ERR@servletRequest" messageType="error"
                                  textBinding="ERROR@rulesBundle@servletRequest"/>
                </uix:case>
             </uix:switcher>

             <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

             <!-- Define the content of the page here -->
              <uix:header textBinding="SEARCH@streamsBundle@servletRequest">
                              <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="SCHEMA_SEARCH_MSG@rulesBundle@servletRequest"/>
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout width="100%" cellSpacing="5">
                                  <uix:contents>
                                        
                                <uix:rowLayout width="100%">
                                      <uix:contents>
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
<uix:messageStyledText styleClass="OraInstructionText" textBinding="SCHEMA@dbMsgs" shortDescBinding="schemaName" />

                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer height="10" width="10"/>
                                          </uix:contents>
                                          </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:messageTextInput name="schemaName" id="schemaName" text="" shortDescBinding="SCHEMA@dbMsgs" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat/>
                                        <uix:cellFormat hAlign="left" width="75%">
                                          <uix:contents>
                                            <uix:submitButton textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="searchSchema" shortDescBinding="GO@dbMsgs" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                                <uix:separator/>

             <uix:spacer height="5" />

  <uix:table name="schemasList" 
             alternateTextBinding="NO_ITEMS_FOUND@rulesBundle@servletRequest"
             formSubmitted="true"
             width="50%"
             tableDataBinding="rowData"
             valueBinding="startIndex"
             blockSizeBinding="<%= StreamsConstants.BLOCK_SIZE %>" 
             maxValueBinding="<%= StreamsConstants.NUM_ROWS %>"
             summaryBinding="SCHEMA_SUMMARY@rulesBundle@servletRequest" >
     <uix:column>
         <uix:columnHeader>
            <uix:sortableHeader textBinding="SN@rulesBundle@servletRequest" sortable="true"/>
         </uix:columnHeader>
         <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
         <uix:text textBinding="<%= RulesMsgID.SN %>" />
     </uix:column>

    <uix:tableSelection>
    <uix:multipleSelection selectedBinding="<%= StreamsConstants.SELECTED %>"  shortDescBinding="SELECT@dbMsgs"/>
    </uix:tableSelection>	

  </uix:table> 
  <uix:spacer height="10" />
</uix:contents>
  </uix:header>           
   </uix:contents>

   <uix:pageButtons>
          <uix:pageButtonBar>
               <uix:contents>
                 <uix:submitButton name="event" value="cancelSchemaRule" textBinding="CANCEL@rulesBundle@servletRequest" shortDescBinding="CANCEL@rulesBundle@servletRequest" />
                 <uix:submitButton name="event" value="okSchemaRule" textBinding="OK@rulesBundle@servletRequest" shortDescBinding="OK@rulesBundle@servletRequest" />
               </uix:contents>
          </uix:pageButtonBar>
         </uix:pageButtons>

  </uix:pageLayout>
  </db:form>
</uix:dataScope>
 </uix:document>
</uix:renderingContext>


