<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsgID" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="rulesMsgs" class="oracle.sysman.db.rsc.streams.RulesMsg"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   

 <uix:document>
          <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
  <db:form name="selectDeclTransformation" method="post" destination="/console/database/dist/streams/rules" copyParams="target,type, otype,objectType,sname, oname">
    <uix:formValue name="pageName" value="/database/dist/streams/rules/selectDeclTransType" />
	<uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
	<uix:pageLayout titleBinding="header@servletRequest">
	<%@ include file="/database/global.jspf" %>
                      <!-- main contents -->
                     <uix:contents>

                     
<uix:stackLayout>
<uix:spacer height="10" width="10"/>
		<uix:radioButton name="transformationType"
								textBinding="ADD_COLUMN@rulesMsgs"
								shortDescBinding="ADD_COLUMN@rulesMsgs"
								value="addColumn"
								selectedValueBinding="transformationType@declarativeTransBean@servletRequest"/>
			<uix:rowLayout>
			  <uix:contents>
				<uix:spacer height="5" width="21"/> 
				<uix:formattedText styleClass="OraInlineInfoText" textBinding="ADD_COLUMN_TIP@rulesMsgs"/>
			  </uix:contents>
			</uix:rowLayout>

		<uix:radioButton name="transformationType"
								textBinding="DELETE_COLUMN@rulesMsgs"
								shortDescBinding="DELETE_COLUMN@rulesMsgs"
								value="deleteColumn"
								selectedValueBinding="transformationType@declarativeTransBean@servletRequest"/>
			<uix:rowLayout>
			  <uix:contents>
				<uix:spacer height="5" width="21"/> 
				<uix:formattedText styleClass="OraInlineInfoText" textBinding="DELETE_COLUMN_TIP@rulesMsgs"/>
			  </uix:contents>
			</uix:rowLayout>

		<uix:radioButton name="transformationType"
								textBinding="RENAME_COLUMN@rulesMsgs"
								shortDescBinding="RENAME_COLUMN@rulesMsgs"
								value="renameColumn"
								selectedValueBinding="transformationType@declarativeTransBean@servletRequest"/>
			<uix:rowLayout>
			  <uix:contents>
				<uix:spacer height="5" width="21"/>
				<uix:formattedText styleClass="OraInlineInfoText" textBinding="RENAME_COLUMN_TIP@rulesMsgs"/>
			  </uix:contents>
			</uix:rowLayout>

		<uix:radioButton name="transformationType"
								textBinding="RENAME_SCHEMA@rulesMsgs"
								shortDescBinding="RENAME_SCHEMA@rulesMsgs"
								value="renameSchema"
								selectedValueBinding="transformationType@declarativeTransBean@servletRequest"/>
			<uix:rowLayout>
			  <uix:contents>
				<uix:spacer height="5" width="21"/>
				<uix:formattedText styleClass="OraInlineInfoText" textBinding="RENAME_SCHEMA_TIP@rulesMsgs"/>
			  </uix:contents>
			</uix:rowLayout>		  

		<uix:radioButton name="transformationType"
								textBinding="RENAME_TABLE@rulesMsgs"
								shortDescBinding="RENAME_TABLE@rulesMsgs"
								value="renameTable"
								selectedValueBinding="transformationType@declarativeTransBean@servletRequest"/>
			<uix:rowLayout>
			  <uix:contents>
				<uix:spacer height="5" width="21"/>
				<uix:formattedText styleClass="OraInlineInfoText" textBinding="RENAME_TABLE_TIP@rulesMsgs"/>
			  </uix:contents>
			</uix:rowLayout>		  

</uix:stackLayout>
 </uix:contents>
                      <!-- navigation -->
                     
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton shortDescBinding="CANCEL@dbMsgs" 
											  textBinding="CANCEL@dbMsgs" 
											  name="event" value="cancelAddTrans"/>
                            <uix:submitButton shortDescBinding="CONTINUE@dbMsgs" 
											  textBinding="CONTINUE@dbMsgs" 
											  name="event" value="addTransOfSelectedType"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                     
                     
                      <uix:pageStatus>
                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="TRANS_TYPE_OPTIONS_INSTR@rulesMsgs"/>
                      </uix:pageStatus>
                    </uix:pageLayout>    


</db:form>
</uix:body>
</uix:document>


</uix:renderingContext>
