<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js" />
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.RulesMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsgID" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("rulesBundle", new BundleDataObject(NLSUtil.getBundle(RulesMsg.class.getName(), request)));
  request.setAttribute("sBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBObjectMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg" />
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>
          <db:form name="viewRuleSet" method="post" destination="/console/database/dist/streams/rules" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/rules/viewRuleSet" />
          <uix:pageLayout titleBinding="TITLE@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>
             <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
<uix:switcher childNameBinding="display@servletRequest">
                <uix:case name="true">
                  <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="Information"
                                  textBinding="UPDATE_MSG@rulesBundle@servletRequest"/>
                </uix:case>
             </uix:switcher>
             <uix:switcher childNameBinding="displayError@servletRequest">
                <uix:case name="true">
                  <uix:messageBox messageBinding="ERR@servletRequest" messageType="error"
                                  textBinding="ERROR@rulesBundle@servletRequest"/>
                </uix:case>
             </uix:switcher>

             <!-- Define the content of the page here -->

<uix:header textBinding="SEARCH@streamsBundle@servletRequest">
                              <uix:contents>
                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="SCHEMA_SEARCH_MSG@rulesBundle@servletRequest"/>
                                <uix:spacer height="10" width="10"/>
                                <uix:tableLayout width="100%" >
                                  <uix:contents>

                                   <uix:rowLayout width="100%">
                                      <uix:contents>

                                        <uix:cellFormat hAlign="left">
                                              <uix:messageStyledText textBinding="OWNER@rulesBundle@servletRequest" styleClass="OraInstructionText" labeledNodeId="ownerName" />
                                        </uix:cellFormat>

                                        <uix:cellFormat>
                                            <uix:spacer height="10" width="10"/>
                                          </uix:cellFormat>

                                          <uix:cellFormat hAlign="left">
<uix:messageLovField name="ownerName" shortDescBinding="OWNER@rulesBundle@servletRequest" id="ownerName" textBinding="ownerName@servletRequest" onClick="startLov('ownerName', 'ListSchema')" />
                                        </uix:cellFormat>

                                         <uix:cellFormat>
                                            <uix:spacer height="10" width="20"/>
                                         </uix:cellFormat>
										 <uix:cellFormat hAlign="left" width="12%">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="RULE_SET_TYPE@rulesBundle@servletRequest" labeledNodeId="subsetType" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                         <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer height="10" width="10"/>
                                          </uix:contents>
                                          </uix:cellFormat>

                                        <uix:cellFormat hAlign="left" width="10%">
                                          <uix:contents>
                                            <uix:choice name="subsetType" selectedValueBinding="subsetSelected@servletRequest" id="subsetType" >
                                              <uix:contents>
                                               <uix:option textBinding="SHOW_ALL_SK@rulesBundle@servletRequest" value="all" />
                                               <uix:option textBinding="POSITIVE_RS@rulesBundle@servletRequest" value="positive"/>
                                               <uix:option textBinding="NEGATIVE_RS@rulesBundle@servletRequest" value="negative"/>
                                              </uix:contents>
                                            </uix:choice>
                                          </uix:contents>
                                        </uix:cellFormat>

                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer height="10" width="20"/>
                                          </uix:contents>
                                          </uix:cellFormat>
                                          
                                         <uix:cellFormat hAlign="left" width="12%">
                                          <uix:contents>
                                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="RULE_TYPE@rulesBundle@servletRequest" labeledNodeId="ruleType" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                         <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer height="10" width="10"/>
                                          </uix:contents>
                                          </uix:cellFormat>

                                        <uix:cellFormat hAlign="left">
                                          <uix:contents>
                                            <uix:choice name="ruleType" selectedValueBinding="selected@servletRequest" id="ruleType" >
                                              <uix:contents>
                                               <uix:option textBinding="SHOW_ALL_SK@rulesBundle@servletRequest" valueBinding="SHOW_ALL_SK@rulesBundle@servletRequest" />
                                               <uix:option textBinding="SCHEMA_SK@rulesBundle@servletRequest" valueBinding="SCHEMA_SK@rulesBundle@servletRequest"/>
                                               <uix:option textBinding="GLOBAL_SK@rulesBundle@servletRequest" valueBinding="GLOBAL_SK@rulesBundle@servletRequest"/>
                                               <uix:option textBinding="TABLE_SK@rulesBundle@servletRequest" valueBinding="TABLE_SK@rulesBundle@servletRequest" />
                                              </uix:contents>
                                            </uix:choice>
                                          </uix:contents>
                                        </uix:cellFormat>

                                        <uix:cellFormat>
                                          <uix:contents>
                                            <uix:spacer height="10" width="10"/>
                                          </uix:contents>
                                          </uix:cellFormat>

                                        <uix:cellFormat hAlign="left" width="75%">
                                          <uix:contents>
                                            <uix:submitButton textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="searchViewRules" shortDescBinding="GO@dbMsgs" />
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                                    </uix:rowLayout>
                                  </uix:contents>
                                </uix:tableLayout>
                                <uix:formattedText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@dbMsgs"/>
                                <uix:separator />

  <uix:spacer height="10" width="10"/>
  <uix:tableLayout width="100%">
    <uix:contents>
      <uix:rowLayout hAlign="right">
        <uix:contents>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="5" width="875"/>
              <uix:submitButton name="event" value="createRule" textBinding="CREATE@rulesBundle@servletRequest" shortDescBinding="CREATE@rulesBundle@servletRequest" />
              <uix:spacer height="10" width="4"/>
              <uix:submitButton name="event" value="addRule" textBinding="ADD@rulesBundle@servletRequest" shortDescBinding="ADD@rulesBundle@servletRequest" />
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:tableLayout>
  <uix:spacer height="5" />
  <oem:table name="ruleSetDataSource"
             beanKey="defaultBean"
             formSubmitted="true"
             alternateTextBinding="NO_SEARCH_DONE@sBundle@servletRequest"
             summaryBinding="RULE_SUMMARY@rulesBundle@servletRequest"
             dataSourceProp="ruleSetDataSource"
             blockSize="10" 
             width="100%" >
     <uix:tableSelection>
          <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@dbBundle@servletRequest">
             <uix:contents>
               <uix:spacer height="10" width="600" />
               <uix:submitButton textBinding="EDIT@rulesBundle@servletRequest" name="event" value="editRule" shortDescBinding="EDIT@rulesBundle@servletRequest" />
               <uix:spacer height="10" width="2" />
               <uix:submitButton textBinding="REMOVE@rulesBundle@servletRequest" name="event" value="removeRule" shortDescBinding="REMOVE@rulesBundle@servletRequest" />
               <uix:spacer height="2" width="2" />
               <uix:submitButton textBinding="DELETE@rulesBundle@servletRequest" name="event" value="deleteRule" shortDescBinding="DELETE@rulesBundle@servletRequest" />
            </uix:contents>
           </uix:singleSelection>
    </uix:tableSelection>
  </oem:table>
  <uix:spacer height="10" />
  <uix:tableLayout>
    <uix:contents>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat>
            <uix:contents>
              <uix:spacer height="10" width="20"/>
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:tip />
            </uix:contents>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:contents>
              <uix:styledText styleClass="OraTipText" textBinding="REM_DEL_RULE_TIP@rulesBundle@servletRequest"/>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:tableLayout> 
            </uix:contents>
</uix:header>
 

             <!-- page contents end here -->

          </uix:contents>

         <!-- navigation -->
         
        
        <uix:pageStatus>
             <uix:styledText styleClass="OraInstructionText" textBinding="RS_DEFINITION@rulesBundle@servletRequest" />
        </uix:pageStatus>
        
       
  </uix:pageLayout>
  </db:form>
 </uix:document>
</uix:renderingContext>

