<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
  request.setAttribute("dbInstMsgs",  new BundleDataObject(NLSUtil.getBundle(DBMsg.class.getName(), request)));

%>

<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@defaultBean@servletRequest"/>
          </uix:metaContainer>
          <db:form name="confirmation" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/setup/confirmation" />
          <uix:pageLayout titleBinding="CONFIRMATION@sb@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>
             <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                titleTextKey="titleText" mainTextKey="mainText"/>
<uix:spacer height="10" width="10" />
<uix:tableLayout width="80%"  >
    <uix:contents>
       <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat>
              <uix:contents>
                <uix:labeledFieldLayout>
                  <uix:contents>
               <uix:link textBinding="EXEC_ID@servletRequest" destinationBinding="destJob@servletRequest"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:contents>
            </uix:cellFormat>
           </uix:contents>
        </uix:rowLayout>
        <uix:rowLayout>
        <uix:cellFormat>
                                                
            <uix:spacer height="20" width="20"/>
        
        </uix:cellFormat>
        </uix:rowLayout>
								
                                                    
     </uix:contents>
 </uix:tableLayout>
</uix:contents>
 <uix:pageButtons>
             <uix:pageButtonBar>
                <uix:contents>
                    <uix:button textBinding="OK@sb@servletRequest" destinationBinding="cancelURL@servletRequest" />
                </uix:contents>
             </uix:pageButtonBar>
        </uix:pageButtons>
        
        <uix:pageStatus>
             <uix:styledText styleClass="OraInstructionText" textBinding="CONF_MESG@sb@servletRequest"/>
        </uix:pageStatus>
 
 <uix:header textBinding="RELATED_LINKS@streamBundle@servletRequest">
	<uix:tableLayout width="80%">
		<uix:rowLayout>
			
			<uix:cellFormat width="33%" vAlign="top">
				<db:link destination="/em/console/database/dist/streams/streamsOverview"
				copyParams="type,target"
				textBinding="REP_MANAGEMENT@dbInstMsgs@servletRequest"/>

			</uix:cellFormat>

			<uix:cellFormat width="33%" vAlign="top">

				<db:link destination="/console/database/dist/streams?event=removeStreams&backURL=overviewMain"
						copyParams="type,target"
						textBinding="REMOVE_STREAMS@streamBundle@servletRequest"/>

			</uix:cellFormat>
		</uix:rowLayout>                  
	</uix:tableLayout>
</uix:header>

  </uix:pageLayout>
  </db:form>
 </uix:document>
</uix:renderingContext>


