<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@defaultBean@servletRequest"/>
        </uix:metaContainer>
        <db:form name="dest_db_form" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
            <uix:formValue name="pageName" value="/database/dist/streams/setup/createDirObj" />
            <uix:pageLayout titleBinding="CONF_DIROBJ@sb@servletRequest">
                <uix:messages>
                    <oem:messageBox messageType="info"
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                </uix:messages>
                <%@ include file="/database/global.jspf" %>

                <!-- main contents -->
                <uix:contents>

                    <uix:spacer height="10" width="10" />
                    <uix:tableLayout width="62%"  >
                        <uix:contents>
                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat>
                                        <uix:contents>
                                            <uix:labeledFieldLayout>
                                                <uix:contents>

                                                    <uix:messageTextInput columns="20" name="dirobj" promptBinding="DON@sb@servletRequest" textBinding="destDirObj@defaultBean@servletRequest" shortDescBinding="DON@sb@servletRequest" />
                                                    <uix:messageTextInput columns="20" name="dirobjpath" promptBinding="DOP@sb@servletRequest" textBinding="destDirObjPath@defaultBean@servletRequest" shortDescBinding="DOP@sb@servletRequest" />
                                                </uix:contents>
                                            </uix:labeledFieldLayout>
                                        </uix:contents>
                                    </uix:cellFormat>
                                </uix:contents>
                            </uix:rowLayout>
                        </uix:contents>
                    </uix:tableLayout>
                </uix:contents>
                <uix:pageButtons>
                    <uix:pageButtonBar>
                        <uix:contents>
                            <uix:submitButton textBinding="CANCEL@sb@servletRequest" name="event" value="cancel_dest_dirobj" shortDescBinding="CANCEL@sb@servletRequest" />
                            <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="create_dest_dirobj" shortDescBinding="OK@sb@servletRequest" />
                        </uix:contents>
                    </uix:pageButtonBar>
                </uix:pageButtons>
        
                <uix:location>
                    <uix:train value="3">
                        <uix:contents>
                            <uix:link textBinding="SRC_DB@sb@servletRequest" disabled="true" />
                            <uix:link textBinding="DEST_DB@sb@servletRequest" disabled="true"/>
                            <uix:link textBinding="CONFIG_REPLN@sb@servletRequest" />
                            <uix:link textBinding="OBJ_SEL@sb@servletRequest" disabled="true" />
                            <uix:link textBinding="REVIEW@sb@servletRequest" disabled="true" />
                        </uix:contents>
                    </uix:train>
                </uix:location>
        
                <uix:pageStatus>
                    <uix:styledText styleClass="OraInstructionText" textBinding="DIROBJ_MESG@sb@servletRequest"/>
                </uix:pageStatus>

                  
            </uix:pageLayout>
        </db:form>
    </uix:document>
</uix:renderingContext>



