<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
   request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="CREATE_STRM_ADMIN@sb@servletRequest"/>
        </uix:metaContainer>
		<script language="JavaScript" >
			<%@ include file="/database/LOV.js"%>
			</script>
		  
			<script>
			function startUsersLov(lovUrl)
			{
			   openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
			}
			
			</script>
        <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
            <db:form name="strm_admn_form" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/createStrmAdmin" />
				<uix:formValue name="event"/>
				<uix:formValue name="ToBeAddedSubComponentsIndexes"/>
                <uix:pageLayout titleBinding="CREATE_STRM_ADMIN@sb@servletRequest">
                    <uix:messages>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                    </uix:messages>
                    <%@ include file="/database/global.jspf" %>

                    <!-- main contents -->
                    

                        <uix:spacer height="10" width="10" />
                        <uix:tableLayout>
                            
                                <uix:rowLayout>
											<uix:cellFormat vAlign="top" width="50%">
                                            <uix:header textBinding="CREDENTIALS@sb@servletRequest">
                                                <uix:labeledFieldLayout>
                                                    
                                                        <oem:choice name="tarDB" optionsBinding="targetDBs@defaultBean@servletRequest" selectedValueBinding="tarDB@defaultBean@servletRequest" id="tarDB" rendered="false"/>
														
														
															

														 <uix:spacer height="10" width="10" />

														<%-- FOR SA start --%>
														<uix:messageTextInput columns="40" name="host" noAutoComplete="true" promptBinding="HOST@sb@servletRequest" textBinding="host@defaultBean@servletRequest" shortDescBinding="HOST@sb@servletRequest" renderedBinding="IsDBControl@servletRequest" />

														<uix:spacer height="10" width="10" />

														<uix:messageTextInput columns="40" name="port" noAutoComplete="true" promptBinding="PORT@sb@servletRequest" textBinding="port@defaultBean@servletRequest" shortDescBinding="PORT@sb@servletRequest" renderedBinding="IsDBControl@servletRequest" />

														<uix:spacer height="10" width="10" />

														<uix:messageTextInput columns="40" name="sid" noAutoComplete="true" promptBinding="SIDSER@sb@servletRequest" textBinding="sid@defaultBean@servletRequest" shortDescBinding="SIDSER@sb@servletRequest" renderedBinding="IsDBControl@servletRequest"/>

														<uix:spacer height="10" width="10" />

														<%-- FOR SA END --%>

														<uix:messageTextInput columns="40" name="sys_user" noAutoComplete="true" promptBinding="SYS_USER@sb@servletRequest" textBinding="sysUserName@defaultBean@servletRequest" shortDescBinding="SYS_USER@sb@servletRequest" />

														 <uix:spacer height="10" width="10" />

                                                        <uix:messageTextInput columns="40" name="sys_pwd" noAutoComplete="true" promptBinding="SYS_PWD@sb@servletRequest" textBinding="sysUserPass@defaultBean@servletRequest" secret="true" shortDescBinding="SYS_PWD@sb@servletRequest" />

														 <uix:spacer height="10" width="10" />

                                                        <uix:messageTextInput columns="40" name="strm_user" noAutoComplete="true" promptBinding="SAU@sb@servletRequest" textBinding="strmUserName@defaultBean@servletRequest"  shortDescBinding="SAU@sb@servletRequest" />

														 <uix:spacer height="10" width="10" />

                                                        <uix:messageTextInput columns="40" name="strm_pwd" noAutoComplete="true" promptBinding="SAP@sb@servletRequest" textBinding="strmUserPass@defaultBean@servletRequest" secret="true" shortDescBinding="SAP@sb@servletRequest" />
														 <uix:spacer height="10" width="10" />

														  <uix:messageTextInput columns="40" name="strm_tblspc" promptBinding="TBLSPC@sb@servletRequest" textBinding="strmTblspc@defaultBean@servletRequest" shortDescBinding="TBLSPC@sb@servletRequest" tipBinding="TBLSPC_INFO@sb@servletRequest"/>
														 <uix:spacer height="10" width="10" />
                                                    
                                                </uix:labeledFieldLayout>
                                            </uix:header>
                                        </uix:cellFormat>

										<uix:cellFormat hAlign="right" width="50%" rowSpan="2" vAlign="top">
										<uix:spacer height="30"/>
										 <uix:contentContainer width="80%" background="light">

											<uix:styledText styleClass="OraInstructionText"     textBinding="SDB_CSA_MESG@sb@servletRequest"/>
											  <uix:bulletedList>
											  <uix:contents>
													<uix:styledText styleClass="OraInstructionText"     textBinding="PRIV_RSS@sb@servletRequest"/>
													<uix:styledText styleClass="OraInstructionText"     textBinding="PRIV_ENDE_Q@sb@servletRequest"/>
													<uix:styledText styleClass="OraInstructionText"     textBinding="PRIV_MAN_Q@sb@servletRequest"/>
													<uix:styledText styleClass="OraInstructionText"     textBinding="PRIV_RULES@sb@servletRequest"/>
											  </uix:contents>
											  </uix:bulletedList>
												<uix:styledText styleClass="OraInstructionText"     textBinding="GRANT_PRIVS_ALSO@sb@servletRequest"/>
												<uix:bulletedList>
											  <uix:contents>
													<uix:styledText styleClass="OraInstructionText"     textBinding="PRIV_CATALOG@sb@servletRequest"/>
													<uix:styledText styleClass="OraInstructionText"     textBinding="PRIV_DATA_DICTIONARY@sb@servletRequest"/>
													<uix:styledText styleClass="OraInstructionText"     textBinding="PRIV_REMOTE_CONN@sb@servletRequest"/>
											  </uix:contents>
											  </uix:bulletedList>


											</uix:contentContainer>
										  </uix:cellFormat>
										</uix:rowLayout>
										 
                                    <uix:rowLayout renderedBinding="IsGridControl@servletRequest">
										
											<uix:cellFormat vAlign="top" hAlign="center"  width="50%">
										    <uix:header  textBinding="LIST_OF_DATABASES@sb@servletRequest"/>
											<uix:dataScope currentDataBinding="targetsSelected@defaultBean@servletRequest">
															<uix:table name="targetList" id="targetList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest" 	formSubmitted="true" tableDataBinding="rowData" valueBinding="startIndex" maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize" partialRenderMode="true" summaryBinding="DATABASE@streamBundle@servletRequest" shortDescBinding="DATABASE@streamBundle@servletRequest" width="90%">
																<uix:column>
																	<uix:columnHeader>
																	<uix:sortableHeader textBinding="TARGET_NAME@sb@servletRequest" sortable="true"/>
																	</uix:columnHeader>
																	<uix:columnFormat columnDataFormat="textFormat"/>
																	<uix:text textBinding="targetNameIndex" />
																</uix:column>
																<uix:column>
																	<uix:columnHeader>
																	<uix:sortableHeader textBinding="TARGET_VERSION@sb@servletRequest" sortable="true"/>
																	</uix:columnHeader>
																	<uix:columnFormat columnDataFormat="textFormat"/>
																	<uix:text textBinding="targetVersionIndex" />
																</uix:column>
																 <uix:column>
																	<uix:columnHeader>
																	<uix:sortableHeader textBinding="HOST@sb@servletRequest" />
																	</uix:columnHeader>
																	<uix:columnFormat columnDataFormat="textFormat"/>
																	<uix:text textBinding="hostNameIndex" />
																</uix:column>
                                                                                                                                <uix:column>
                                                                                                                                        <uix:columnHeader>
                                                                                                                                        <uix:sortableHeader textBinding="TARGET_TYPE@dbBundle@servletRequest" sortable="true"/>
                                                                                                                                        </uix:columnHeader>
                                                                                                                                        <uix:columnFormat columnDataFormat="textFormat"/>
                                                                                                                                        <uix:text textBinding="targetTypeIndex" />
                                                                                                                                </uix:column>
																<uix:tableActions>
																  <uix:cellFormat  rendered="true" >
																	<uix:button textBinding="ADD@sb@servletRequest" onClickBinding="showTargetLOV@servletRequest" />
																  </uix:cellFormat>                    
																</uix:tableActions>
																<uix:tableSelection>
																<uix:multipleSelection shortDescBinding="SELECT@dbBundle@servletRequest" selectedBinding="selectedItems" >
																<uix:submitButton textBinding="REMOVE@sb@servletRequest" shortDescBinding="REMOVE@sb@servletRequest" name="event" value="deleteRow"/>
																 </uix:multipleSelection>
																 
																</uix:tableSelection>
																
														 </uix:table>
														</uix:dataScope>
										</uix:cellFormat>

										
                                    </uix:rowLayout>
                            
                        </uix:tableLayout>
                    
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            
				<uix:button textBinding="CANCEL@sb@servletRequest" destinationBinding="cancelURL@servletRequest" shortDescBinding="CANCEL@sb@servletRequest" />
                                <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="confCreateStrmAdmn" shortDescBinding="OK@sb@servletRequest" />
                        </uix:pageButtonBar>
                    </uix:pageButtons>
        
                    
        
                    <uix:pageStatus>
                        <uix:styledText styleClass="OraInstructionText" textBinding="STRM_ADM_PAGE_INFO_DBC@sb@servletRequest"/>
                    </uix:pageStatus>


                     
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>

