<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<db:script src="/database/LOV.js"/>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
            <db:form name="dest_db_form" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type">
				<%@ include file="/database/global.jspf" %>
                <uix:pageLayout titleBinding="CSDD@sb@servletRequest">
                        <oem:messageBox messageType="info"
						destTableBinding="msgUrls@servletRequest"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
						<oem:messageBox messageType="warning"
                            errorTableBinding="warning@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
						destTableBinding="msgUrls@servletRequest"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                    <!-- main contents -->
                    
                <uix:formValue name="pageName" value="/database/dist/streams/setup/destDB" />


                        <!-- Define the content of the page here -->

                        <uix:tableLayout>
                            <uix:rowLayout>
                             <uix:cellFormat>
 <uix:switcher childNameBinding="replicationMode@defaultBean@servletRequest">
               <uix:case name="clone">
               <uix:flowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="SELECT_DB_MSG@sb@servletRequest"/>
            <uix:link textBinding="CLONE_DATABASE@sb@servletRequest"
            destinationBinding="cloneUrl@servletRequest"/> 
            </uix:flowLayout>
            </uix:case>
             <uix:case name="rman">
               <uix:flowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="SELECT_DB_MSG@sb@servletRequest"/>
            <uix:link textBinding="CLONE_DATABASE@sb@servletRequest"
            destinationBinding="cloneUrl@servletRequest"/> 
            </uix:flowLayout>
            </uix:case>
          <uix:case name="global">
               <uix:flowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="DBC_MESG@sb@servletRequest"/>
            </uix:flowLayout>
            </uix:case>
          <uix:case name="tts">
               <uix:flowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="DBC_MESG@sb@servletRequest"/>
            </uix:flowLayout>
            </uix:case>
 <uix:case name="table">
               <uix:flowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="DBC_MESG@sb@servletRequest"/>
            </uix:flowLayout>
            </uix:case>
          <uix:case name="schema">
               <uix:flowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="DBC_MESG@sb@servletRequest"/>
            </uix:flowLayout>
            </uix:case>
           </uix:switcher>
                           </uix:cellFormat> 
                            </uix:rowLayout>
                    </uix:tableLayout>
                    <uix:tableLayout>
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                
                                    
                                        
                                    
       
                                <uix:cellFormat columnSpan="4">
                                    <uix:spacer width="10" />
					<uix:messageLovField name="tarDB" id="tarDB" 
					textBinding="tarDB@defaultBean@servletRequest" shortDescBinding="DEST_DB@sb@servletRequest" searchDescBinding="DEST_DB@sb@servletRequest"
					promptBinding="DEST_DB@sb@servletRequest" onClick="startLov('tarDB','ListTargetDatabases')" tip=""/>

                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="5" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout >
                                <uix:cellFormat hAlign="left">
				
				<uix:labeledFieldLayout>
				<uix:styledText styleClass="OraInstructionText" textBinding="STRM_ADMIN@sb@servletRequest" labeledNodeId="strm_admin" />
				<uix:textInput columns="20" id="strm_admin" noAutoComplete="true" name="strm_admin" textBinding="destStrmUser@defaultBean@servletRequest" />
				<uix:spacer width="10" height="5" />
				<uix:spacer width="10" height="5" />
				<uix:styledText styleClass="OraInstructionText" textBinding="PASSWORD@sb@servletRequest"/>
				<uix:textInput columns="20" name="strm_pwd" noAutoComplete="true" secret="true" textBinding="destStrmSecretPwd@defaultBean@servletRequest" shortDescBinding="PASSWORD@sb@servletRequest" />
				</uix:labeledFieldLayout>
                                    
                                        
                                   </uix:cellFormat> 
                                

                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="5" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat>
                                
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <%--uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat--%>
                            </uix:rowLayout>
                            <%--uix:rowLayout>
                                <uix:cellFormat>
                                    
									 <uix:header textBinding="HOST_CREDS@sb@servletRequest">
                                        <uix:spacer width="10" height="10" />
										<uix:styledText styleClass="OraInstructionText" textBinding="HOST_TIP@sb@servletRequest"/>
                                        <uix:spacer width="10" height="10" />
                                       
									   <%@ include file="/credentials.jspf" %>
									 </uix:header>
                                    
                                </uix:cellFormat>
                            </uix:rowLayout--%>

                        </uix:tableLayout>

                         <!-- page contents end here -->

                    

                    <!-- navigation -->

                   <uix:pageButtons>
                            <uix:pageButtonBar>
                                
                                    <uix:button textBinding="CANCEL@sb@servletRequest" destinationBinding="cancelURL@servletRequest" shortDescBinding="CANCEL@sb@servletRequest" />
                                    <uix:navigationBar formSubmitted="true" maxValueBinding="maxPages@defaultBean@servletRequest"  valueBinding="currentPage@defaultBean@servletRequest" name="wizardNavigation"/>
                                
                            </uix:pageButtonBar>
                        </uix:pageButtons>
						<%@ include file="train.jspf" %> 

                    <uix:pageStatus>

			 </uix:pageStatus>

                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>

