<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
            <db:form name="dest_db_form" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/destDBControl" />
                <uix:pageLayout titleBinding="CSDD@sb@servletRequest">
                    <uix:messages>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                    </uix:messages>
                    <%@ include file="/database/global.jspf" %>

                    <!-- main contents -->
						<uix:spacer height="10" width="10" />
						<uix:tableLayout width="100%">

						<uix:rowLayout>
							<uix:cellFormat vAlign="top" columnSpan="3">
								<uix:flowLayout>
									<uix:styledText styleClass="OraInstructionText" textBinding="strmCreateInfo@servletRequest"/>
									<uix:link textBinding="CLICK@streamBundle@servletRequest" destinationBinding="createStrmAdmin@servletRequest"/>
								</uix:flowLayout>
							</uix:cellFormat>
						</uix:rowLayout>

						<uix:rowLayout>
							<uix:cellFormat>								
								<uix:spacer width="10" height="20" />
							</uix:cellFormat>
						</uix:rowLayout>

						  
						  <uix:rowLayout>
		                    <uix:cellFormat hAlign="left">

						<uix:tableLayout>
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    
                                        <uix:styledText styleClass="OrainstructionText" textBinding="HOST@sb@servletRequest" labeledNodeId="host" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:textInput columns="20"  name="host" textBinding="destHost@defaultBean@servletRequest" id="host" shortDescBinding="HOST@sb@servletRequest" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="5" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    
                                        <uix:styledText styleClass="OrainstructionText" textBinding="PORT@sb@servletRequest" labeledNodeId="port" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:textInput columns="20"  name="port" textBinding="destPort@defaultBean@servletRequest" id="port" shortDescBinding="PORT@sb@servletRequest" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="5" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    
                                        <uix:styledText styleClass="OrainstructionText" textBinding="SIDSER@sb@servletRequest" labeledNodeId="sid" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:textInput columns="20"  name="sid" textBinding="destSid@defaultBean@servletRequest" id="sid" shortDescBinding="SIDSER@sb@servletRequest" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="5" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout >
                                <uix:cellFormat hAlign="right">
                                    
                                        <uix:styledText styleClass="OraInstructionText" textBinding="STRM_ADMIN@sb@servletRequest" labeledNodeId="strm_admin" />

                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:textInput columns="20"  name="strm_admin" textBinding="destStrmUser@defaultBean@servletRequest" id="strm_admin" shortDescBinding="STRM_ADMIN@sb@servletRequest" />
                                    
                                </uix:cellFormat>
                                

                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="5" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>
                
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    
                                        <uix:styledText styleClass="OraInstructionText" textBinding="PASSWORD@sb@servletRequest" labeledNodeId="strm_pwd" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:spacer width="10" height="10" />
                                    
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    
                                        <uix:textInput columns="20"  name="strm_pwd" secret="true" textBinding="destStrmSecretPwd@defaultBean@servletRequest" id="strm_pwd" shortDescBinding="PASSWORD@sb@servletRequest"  noAutoComplete="true" />
                                    
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
					</uix:cellFormat>

					<uix:cellFormat width="50%" vAlign="top" hAlign="right">
							<uix:contentContainer textBinding="DEST_OPT@sb@servletRequest" width="100%" background="light">
								  <uix:bulletedList>
								  <uix:contents>
									<uix:styledText styleClass="OraInstructionText"     textBinding="DBC_MESG@sb@servletRequest"/>
									<uix:styledText styleClass="OraInstructionText"     textBinding="DBC_MESG_2@sb@servletRequest"/>
										  
								  </uix:contents>
								  </uix:bulletedList>
							 </uix:contentContainer>
						</uix:cellFormat>

				</uix:rowLayout>
			</uix:tableLayout>


                        <uix:spacer height="10" width="10" />
                        <%-- <uix:tableLayout>
                            
                                <uix:rowLayout>
                                    
                                        <uix:cellFormat>
                                            
                                                <uix:tip />
                                            
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            
                                     <uix:styledText textBinding="DBC_MESG@sb@servletRequest" styleClass="OraTipText"/> 
                                            
                                        </uix:cellFormat>
                                    
                                </uix:rowLayout>
                            
                        </uix:tableLayout>             
						--%>

                        <!-- page contents end here -->

                    

                    <!-- navigation -->
         
                    
         <uix:pageButtons>
                            <uix:pageButtonBar>
                                
                                    <uix:button textBinding="CANCEL@sb@servletRequest" destinationBinding="cancelURL@servletRequest" shortDescBinding="CANCEL@sb@servletRequest" />
                                    <uix:navigationBar formSubmitted="true" maxValueBinding="maxPages@defaultBean@servletRequest"  valueBinding="currentPage@defaultBean@servletRequest" name="wizardNavigation"/>
                                
                            </uix:pageButtonBar>
                        </uix:pageButtons>
						<%@ include file="train.jspf" %> 

                    <uix:pageStatus>

			 </uix:pageStatus>
                      
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>

