<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="CREATE_STRM_ADMIN@sb@servletRequest"/>
        </uix:metaContainer>
        <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
            <db:form name="strm_admn_form" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/destDBCreateAdmin" />
                <uix:pageLayout titleBinding="CREATE_STRM_ADMIN@sb@servletRequest">
                    <uix:messages>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                    </uix:messages>
                    <%@ include file="/database/global.jspf" %>

                    <!-- main contents -->
                    

                        <uix:spacer height="10" width="10" />
                        <uix:tableLayout>
                            
                                <uix:rowLayout>
                                    
                                        <uix:cellFormat>
                                            
                                                <uix:labeledFieldLayout>
                                                    
                                                        <oem:choice name="tarDB" optionsBinding="targetDBs@defaultBean@servletRequest" selectedValueBinding="tarDB@defaultBean@servletRequest" id="tarDB" rendered="false"/>
														
														
															

														 <uix:spacer height="10" width="10" />

                                                        <uix:messageTextInput columns="20" name="sys_user" noAutoComplete="true" promptBinding="SYS_USER@sb@servletRequest" textBinding="destSYSUser@defaultBean@servletRequest" shortDescBinding="SYS_USER@sb@servletRequest" />

														 <uix:spacer height="10" width="10" />

                                                        <uix:messageTextInput columns="20" name="sys_pwd" noAutoComplete="true" promptBinding="SYS_PWD@sb@servletRequest" textBinding="destSYSSecretPwd@defaultBean@servletRequest" secret="true" shortDescBinding="SYS_PWD@sb@servletRequest" />

														 <uix:spacer height="10" width="10" />

                                                        <uix:messageTextInput columns="20" name="strm_user" noAutoComplete="true" promptBinding="SAU@sb@servletRequest" textBinding="destStrmUser@defaultBean@servletRequest"  shortDescBinding="SAU@sb@servletRequest" />

														 <uix:spacer height="10" width="10" />

                                                        <uix:messageTextInput columns="20" name="strm_pwd" noAutoComplete="true" promptBinding="SAP@sb@servletRequest" textBinding="destStrmSecretPwd@defaultBean@servletRequest" secret="true" tipBinding="CONF@sb@servletRequest" shortDescBinding="SAP@sb@servletRequest" />
														 <uix:spacer height="10" width="10" />
                                                    
                                                </uix:labeledFieldLayout>
                                            
                                        </uix:cellFormat>

										<uix:cellFormat vAlign="top">
										    <uix:styledText styleClass="OraInstructionText" textBinding="DB_TARGET_LIST@sb@servletRequest" labeledNodeId="tarDB" />
											<uix:dataScope currentDataBinding="tablesList@servletRequest">
															<uix:table name="targetList" id="targetList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest" 	formSubmitted="true" tableDataBinding="rowData" valueBinding="startIndex" maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize" partialRenderMode="true" summaryBinding="targetList@servletRequest" shortDescBinding="tableHeader@servletRequest" >
																<uix:column>
																	<uix:columnHeader>
																	<uix:sortableHeader textBinding="TARGET_NAME@sb@servletRequest" sortable="true"/>
																	</uix:columnHeader>
																	<uix:columnFormat columnDataFormat="textFormat"/>
																	<uix:text textBinding="TargetNameIndex" />
																</uix:column>
																<uix:column>
																	<uix:columnHeader>
																	<uix:sortableHeader textBinding="TARGET_VERSION@sb@servletRequest" sortable="true"/>
																	</uix:columnHeader>
																	<uix:columnFormat columnDataFormat="textFormat"/>
																	<uix:text textBinding="TargetVersion" />
																</uix:column>
																 <uix:column>
																	<uix:columnHeader>
																	<uix:sortableHeader textBinding="TARGET_HOST@sb@servletRequest" />
																	</uix:columnHeader>
																	<uix:columnFormat columnDataFormat="textFormat"/>
																	<uix:text textBinding="TargetHost" />
																</uix:column>

																<uix:tableActions>
																  <uix:cellFormat  rendered="true" >
																	<uix:button textBinding="ADD@sb@servletRequest" onClickBinding="showTargetLOV@servletRequest" />
																  </uix:cellFormat>                    
																</uix:tableActions>
																<uix:tableSelection>
																<uix:multipleSelection shortDescBinding="SELECT@dbBundle@servletRequest" selectedBinding="selectedItems" >
																<uix:submitButton textBinding="REMOVE@sb@servletRequest" shortDescBinding="REMOVE@sb@servletRequest" name="event" value="deleteRow"/>
																 </uix:multipleSelection>
																 
																</uix:tableSelection>
																
														 </uix:table>
														</uix:dataScope>
										</uix:cellFormat>
                                    
                                </uix:rowLayout>
                            
                        </uix:tableLayout>
                    
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            
                                <uix:submitButton textBinding="CANCEL@sb@servletRequest" name="event" value="cancel_user_dest" shortDescBinding="CANCEL@sb@servletRequest" />
                                <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="create_user_dest" shortDescBinding="OK@sb@servletRequest" />
                            
                        </uix:pageButtonBar>
                    </uix:pageButtons>
        
                    <uix:location>
                        <uix:train value="2">
                            
                                <uix:link textBinding="SRC_DB@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="DEST_DB@sb@servletRequest" />
                                <uix:link textBinding="CONFIG_REPLN@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="OBJ_SEL@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="REVIEW@sb@servletRequest" disabled="true" />
                            
                        </uix:train>
                    </uix:location>
        
                    <uix:pageStatus>
                        <uix:styledText styleClass="OraInstructionText" textBinding="SDB_CSA_MESG@sb@servletRequest"/>
                    </uix:pageStatus>


                     
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>

