<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>
<%
  response.setBufferSize(1024 * 15);
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:dataScope>
        <uix:document>
            <uix:metaContainer>
                <!-- Set the page title -->
                <uix:head titleBinding="title@servletRequest"/>
                <db:script src="/database/utils.js"/>   <%-- lovField support --%>
            </uix:metaContainer>
            <db:form name="editScripts" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/editScripts" />
                <uix:pageLayout titleBinding="RES@sb@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                       <oem:messageBox messageType="warning"
                        errorTableBinding="warning@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                       
                    <!-- main contents -->
                    <uix:contents>

                        <!-- Define the content of the page here -->

                        <uix:tableLayout>
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
 <uix:textInput
                textBinding="setupScript@defaultBean@servletRequest"
                name="new_script" rows="20" columns="156"
                readOnly="false"
shortDescBinding="SUMMARY_OPERATIONS@streamBundle@servletRequest" />

                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>

    <uix:spacer height="10" />
    <uix:tableLayout>
      <uix:contents>
        <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat hAlign="right">
              <uix:contents>
                <%--uix:styledText textBinding="SSS@sb@servletRequest" styleClass="OraInstructionText"/--%>
              </uix:contents>
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:contents>
                <uix:spacer height="10" width="10"/>
              </uix:contents>
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:contents>
<%--uix:submitButton textBinding="SAVE@sb@servletRequest" name="event" value="uploadSetupSql" shortDescBinding="SSS@sb@servletRequest" /--%>
              </uix:contents>
            </uix:cellFormat>
         </uix:contents>
        </uix:rowLayout>

                            </uix:contents>
                        </uix:tableLayout>

                        <!-- Contents of the page ends here -->
                    </uix:contents>


                    <!-- navigation -->

                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
								<uix:submitButton textBinding="SUBMIT@streamBundle@servletRequest" name="event" value="updateScripts" shortDescBinding="SSS@sb@servletRequest" />
                                <uix:submitButton textBinding="CANCEL@sb@servletRequest" name="event" value="okSave" shortDescBinding="CANCEL@sb@servletRequest" />
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
						 <%@ include file="train.jspf" %>

                    <uix:pageStatus>
                        <uix:styledText styleClass="OraInstructionText" textBinding="EDIT_SCRIPTS_MSG@sb@servletRequest"/>
                    </uix:pageStatus>

                    
                </uix:pageLayout>
            </db:form>
        </uix:document>
    </uix:dataScope>
</uix:renderingContext>
