<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/utils.js"/>

    <uix:bundle name="stream" class="oracle.sysman.db.rsc.streams.StreamsMsg" />
    <uix:bundle name="cap"    class="oracle.sysman.db.rsc.streams.CaptureMsg" />
    <uix:document> 

        <uix:metaContainer>
            <uix:head titleBinding="STREAMS@servletRequest" />
        </uix:metaContainer>
     <db:form name="showSetupOptions" method="get" destination="/console/database/dist/streams/setup" copyParams="target,type, QTABLENAME, oname, sname">
        <uix:pageLayout titleBinding="STREAMS@stream" styleClass="OraInstructionText" >	
            <%@ include file="/database/global.jspf" %>
            <!-- main contents -->
           <oem:messageBox messageType="info"  errorTableBinding="info@servletRequest"  titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"  errorTableBinding="errors@servletRequest"  titleTextKey="titleText" mainTextKey="mainText"/>
			
           
				
                    <uix:formValue name="pageName" value="/database/dist/streams/setup/errorRecovery"/>
					<uix:formValue name="script_id" valueBinding="LAST_SETUP_ERROR_SCRID@servletRequest"/>

								 <uix:header textBinding="RECOVERY_OPTIONS@stream" renderedBinding="SHOW_RECOVERY_OPTIONS@servletRequest">
									<uix:stackLayout>
										<uix:spacer height="10" />
										<uix:styledText textBinding="LASTRUN_ERROR_INFO@stream" styleClass="OraInstructionText" />
										<uix:spacer height="10" />
										<uix:tableLayout>
											<uix:rowLayout>
												<uix:cellFormat hAlign="right">
													<uix:styledText textBinding="BLOCK_NUM@stream" styleClass="OraInstructionText" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:spacer width="10"  height="10"/>									
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:styledText textBinding="LAST_SETUP_ERROR_BLKNM@servletRequest" styleClass="OraDataText" />
												</uix:cellFormat>
											</uix:rowLayout>
											<uix:rowLayout>
												<uix:cellFormat hAlign="right">
													<uix:styledText textBinding="SCRIPT_ID@stream" styleClass="OraInstructionText" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:spacer width="10" height="10" />									
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:styledText textBinding="LAST_SETUP_ERROR_SCRID@servletRequest" styleClass="OraDataText" />
												</uix:cellFormat>
											</uix:rowLayout>
											
											<uix:rowLayout>
												<uix:cellFormat hAlign="right">
													<uix:styledText textBinding="ERROR_MSG@stream" styleClass="OraInstructionText" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:spacer width="10"  height="10"/>									
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:styledText textBinding="LAST_SETUP_ERROR_MSG@servletRequest" styleClass="OraDataText" />
												</uix:cellFormat>
											</uix:rowLayout>
										</uix:tableLayout>
										
										
										<uix:spacer height="10" />
										<uix:styledText textBinding="CLEAR_ERROR_TEXT@stream" styleClass="OraInstructionText" />
										<uix:spacer height="10" />
										<uix:tableLayout>
											<uix:rowLayout>
												<uix:cellFormat>
													<uix:messageRadioButton textBinding="FORWARD@stream" name="repl_type"  value="FORWARD" selectedBinding="SHOW_RECOVERY_OPTIONS@servletRequest" shortDescBinding="FORWARD_INFO@stream" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:spacer width="10" />
													<uix:styledText text=" - " styleClass="OraInstructionText"/>
													<uix:spacer width="10" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:styledText textBinding="FORWARD_INFO@stream" styleClass="OraInstructionText"/>
												</uix:cellFormat>
											</uix:rowLayout>
											<uix:rowLayout>
												<uix:cellFormat>
													<uix:messageRadioButton textBinding="ROLLBACK@stream" name="repl_type"  value="ROLLBACK"  shortDescBinding="ROLLBACK_INFO@stream" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:spacer width="10" />
													<uix:styledText text=" - " styleClass="OraInstructionText"/>
													<uix:spacer width="10" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:styledText textBinding="ROLLBACK_INFO@stream"styleClass="OraInstructionText" />
												</uix:cellFormat>
											</uix:rowLayout>
											<uix:rowLayout>
												<uix:cellFormat>
													<uix:messageRadioButton textBinding="PURGE@stream" name="repl_type"  value="PURGE"  shortDescBinding="PURGE_INFO@stream" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:spacer width="10" />
													<uix:styledText text=" - " styleClass="OraInstructionText"/>
													<uix:spacer width="10" />
												</uix:cellFormat>
												<uix:cellFormat>
													<uix:styledText textBinding="PURGE_INFO@stream" styleClass="OraInstructionText"/>
												</uix:cellFormat>
											</uix:rowLayout>
										</uix:tableLayout>
									
									
							
						</uix:stackLayout>
					 </uix:header>
					
				   
					
            
                
				 <uix:pageButtons>
					<uix:pageButtonBar>
						<uix:button textBinding="CANCEL@stream" destinationBinding="CANCELURL@servletRequest" shortDescBinding="CANCEL@streams" />
						<uix:submitButton textBinding="CONTINUE@stream"  name="event" value="continue" shortDescBinding="CONTINUE@streams" />
				 </uix:pageButtonBar>
				 </uix:pageButtons>

			
        </uix:pageLayout> 
		 </db:form> 
    </uix:document> 
</uix:renderingContext> 

