<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js" />
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:dataScope>
        <uix:document>
            <uix:metaContainer>
                <!-- Set the page title -->
                <uix:head titleBinding="title@defaultBean@servletRequest"/>
                <db:script src="/database/utils.js"/>   <%-- lovField support --%>
            </uix:metaContainer>
            <db:form name="globalRuleExcludeTable" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/globalRuleExcludeTable" />
                <uix:pageLayout titleBinding="OSET@sb@servletRequest">
                    <uix:messages>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                    </uix:messages>
                    <%@ include file="/database/global.jspf" %>       

                    <!-- main contents -->
                    <uix:contents>
                        <!-- Define the content of the page here -->
                        <uix:spacer height="10" width="10" />           
                        <oem:table name="tableDataSource"
                            beanKey="defaultBean"
                            formSubmitted="true"
                            dataSourceProp="tableDataSource"
                            width="35%"
                            blockSize="100"
                            summaryBinding="PSUMM@sb@servletRequest">

                            <%-- column footer button --%>
                            <uix:columnFooter>
                                <uix:submitButton formName="globalRuleExcludeTable" textBinding="ADD5@sb@servletRequest" 
                                shortDescBinding="ADD5@sb@servletRequest" 
                                name="event" 
                                value="add5more"
                                rendered="true"/>
                            </uix:columnFooter>

                        </oem:table>
                    </uix:contents>


                    <!-- navigation -->
         
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@sb@servletRequest" name="event" value="cancelExcludeTable" shortDescBinding="CANCEL@sb@servletRequest" />
                                <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="okExcludeTable" shortDescBinding="OK@sb@servletRequest" />
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
						<%@ include file="train.jspf" %>       
                    <uix:pageStatus>
                        <uix:styledText styleClass="OraInstructionText" textBinding="EXTTABMSG@sb@servletRequest"/>
                    </uix:pageStatus>
    
                    
                </uix:pageLayout>
            </db:form>
        </uix:document>
    </uix:dataScope>
</uix:renderingContext>

