<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       propagateLOV.jsp
  -- Controller: db/adm/dist/SetupController.java 
  -- Description: Stream Propagate LOV for process selection page
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SP@sb@servletRequest"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>
      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('propDataSource');
          var selectedIndex = proxy.getSelectedRow();
              if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('Selected', selectedIndex);
            lovField.value = selectedElement.value;
            window.close();
          }
        }
      </script>
    </uix:metaContainer>
    <uix:body>

   <db:form name="propagate_lov_form" 
            destination="/database/dist/streams/setup"
            copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:pageLayout titleBinding="SSP@sb@servletRequest">
        <uix:formValue name="pageName" value="/database/dist/streams/setup/propagateLOV"/>
        <uix:formValue name="event" value="selectProcess"/>


          <uix:tableLayout cellSpacing="2" width="80%">

            <%-- Search Criteria and Instruction --%>
              <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="PN@sb@servletRequest">
                    <oem:table name="propDataSource" beanKey="defaultBean" blockSize="10"
                        destinationBinding="destination" formSubmitted="true"
                        dataSourceProp="propDataSource" width="90%" 
                        summaryBinding="PSUMM@sb@servletRequest"
                        alternateTextBinding="NO_ITEMS_FOUND@sb@servletRequest">
                        <uix:tableSelection>
                          <uix:singleSelection shortDescBinding="SELECT@sb@servletRequest"
                                               selectedIndex="0"/>
                        </uix:tableSelection>
                    </oem:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@sb@servletRequest" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@sb@servletRequest" destinationBinding="selectPropagateDestination@servletRequest"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

