<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>
<%
  response.setBufferSize(1024 * 15);
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:dataScope>
        <uix:document>
            <uix:metaContainer>
                <!-- Set the page title -->
                <uix:head titleBinding="title@servletRequest"/>
                <db:script src="/database/utils.js"/>   <%-- lovField support --%>
            </uix:metaContainer>
            <db:form name="saveScripts" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/saveScripts" />
                <uix:pageLayout titleBinding="RSS@sb@servletRequest">
                    <%@ include file="/database/global.jspf" %>

                    <!-- main contents -->
                    <uix:contents>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

                        <!-- Define the content of the page here -->
                        <uix:tableLayout>
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:styledText textBinding="SS1@sb@servletRequest" styleClass="OraInstructionText" />
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:bulletedList rows="3">
                                                    <uix:contents>
                                                        <uix:styledText textBinding="SS2@sb@servletRequest" styleClass="OraInstructionText" />
                                                        <uix:styledText textBinding="SS4@sb@servletRequest" styleClass="OraInstructionText" />
                                                        <uix:styledText textBinding="SS3@sb@servletRequest" styleClass="OraInstructionText" />
                                                    </uix:contents>
                                                </uix:bulletedList>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>

                        <uix:tableLayout>
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="10" />
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>

    <uix:spacer height="10" />
    <uix:tableLayout>
      <uix:contents>
        <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat hAlign="right">
              <uix:contents>
                <uix:styledText textBinding="SSS@sb@servletRequest" styleClass="OraInstructionText"/>
              </uix:contents>
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:contents>
                <uix:spacer height="10" width="10"/>
              </uix:contents>
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:contents>
<uix:submitButton textBinding="SAVE@sb@servletRequest" name="event" value="downloadSetupSql" shortDescBinding="SSS@sb@servletRequest" />
              </uix:contents>
            </uix:cellFormat>
         </uix:contents>
        </uix:rowLayout>

                            </uix:contents>
                        </uix:tableLayout>

                        <!-- Contents of the page ends here -->
                    </uix:contents>


                    <!-- navigation -->

                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="okSave" shortDescBinding="OK@sb@servletRequest" />
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>

                    <uix:location>
                        <uix:train value="5">
                            <uix:contents>
                                <uix:link textBinding="SRC_DB@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="DEST_DB@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="CONFIG_REPLN@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="OBJ_SEL@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="REVIEW@sb@servletRequest"  />
                            </uix:contents>
                        </uix:train>
                    </uix:location>

                    <uix:pageStatus>
                        <uix:styledText styleClass="OraInstructionText" textBinding="SAVE_SCRIPTS_MSG@sb@servletRequest"/>
                    </uix:pageStatus>

                    
                </uix:pageLayout>
            </db:form>
        </uix:document>
    </uix:dataScope>
</uix:renderingContext>
