<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js" />
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="java.util.Vector" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:dataScope>
        <uix:document>
            <uix:metaContainer>
                <!-- Set the page title -->
                <uix:head titleBinding="title@defaultBean@servletRequest"/>
                <db:script src="/database/utils.js"/>   <%-- lovField support --%>
            </uix:metaContainer>
            <db:form name="schemaRuleExcludeTable" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/schemaRuleExcludeTable" />
          
                <uix:pageLayout titleBinding="OSET@sb@servletRequest">
                    <uix:messages>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>  
                    </uix:messages>
                    <%@ include file="/database/global.jspf" %>       

                    <!-- main contents -->
                          
                    <uix:contents>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
            
                        <!-- Define the content of the page here -->
             
                        <oem:table name="excludeTableSchemaRuleDataSource"
                            beanKey="defaultBean"
                            formSubmitted="true"
                            dataSourceProp="excludeTableSchemaRuleDataSource"
                            width="35%"
                            blockSize="100"
                            summaryBinding="PSUMM@sb@servletRequest">

                            <%-- column footer button --%>
                            <uix:columnFooter>
                                <uix:submitButton formName="schemaRuleExcludeTable" textBinding="ADD5@sb@servletRequest" 
                                shortDescBinding="ADD5@sb@servletRequest" 
                                name="event" 
                                value="add5more"
                                rendered="true"/>
                            </uix:columnFooter>

                        </oem:table>
                    </uix:contents>


                    <!-- navigation -->
         
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@sb@servletRequest" name="event" value="cancelExcludeTable" shortDescBinding="CANCEL@sb@servletRequest"  />
                                <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="okExcludeTable" shortDescBinding="OK@sb@servletRequest" />
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
        
                    <uix:location>
                        <uix:train value="4">
                            <uix:contents>
                                <uix:link textBinding="SRC_DB@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="DEST_DB@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="CONFIG_REPLN@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="OBJ_SEL@sb@servletRequest" />
                                <uix:link textBinding="REVIEW@sb@servletRequest" disabled="true" />
                            </uix:contents>
                        </uix:train>
                    </uix:location>

                    <uix:pageStatus>
                        <uix:styledText styleClass="OraInstructionText" textBinding="EXTTABMSG@sb@servletRequest"/>
                    </uix:pageStatus>
        
                      
                </uix:pageLayout>
            </db:form>
        </uix:document>
    </uix:dataScope>
</uix:renderingContext>

