<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>


<SCRIPT LANGUAGE="JavaScript">

function setReplicationButtonState (val) {
  if(val=="1") {
    showSetupOptions.repl_type[0].disabled=false;
    showSetupOptions.repl_type[1].disabled=false;
    showSetupOptions.repl_type[2].disabled=false;
    showSetupOptions.repl_type[3].disabled=false;
  }
  else if(val=="0") {
    showSetupOptions.repl_type[0].disabled=true;
    showSetupOptions.repl_type[1].disabled=true;
    showSetupOptions.repl_type[2].disabled=true;
    showSetupOptions.repl_type[3].disabled=true;
  }
}
</SCRIPT>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/utils.js"/>
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>

    <uix:bundle name="stream" class="oracle.sysman.db.rsc.streams.StreamsMsg" />
    <uix:bundle name="cap"    class="oracle.sysman.db.rsc.streams.CaptureMsg" />
    <uix:document> 

        <uix:metaContainer>
            <uix:head titleBinding="STREAMS@servletRequest" />
        </uix:metaContainer>
 <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
     <db:form name="showSetupOptions" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, QTABLENAME, oname, sname">
        <uix:pageLayout titleBinding="STREAMS@stream" styleClass="OraInstructionText" >	
            <%@ include file="/database/global.jspf" %>
            <!-- main contents -->
           <oem:messageBox messageType="info"       
                        destTableBinding="msgUrls@servletRequest"
                        errorTableBinding="info@servletRequest" 
                        titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="warning"
                            errorTableBinding="warning@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
           <oem:messageBox messageType="error" destTableBinding="msgUrls@servletRequest"  errorTableBinding="errors@servletRequest"  titleTextKey="titleText" mainTextKey="mainText"/>
			
			<uix:formValue name="pageName" value="/database/dist/streams/setup/showSetupOptions"/>
			<uix:formValue name="target" value="target@servletRequest"/>
			<uix:formValue name="type" value="type@servletRequest"/>
							<uix:tableLayout width="100%">
                              <uix:rowLayout>
                                  <uix:cellFormat vAlign="top" columnSpan="3">
  <uix:flowLayout>
                        <uix:styledText styleClass="OraInstructionText" textBinding="strmCreateInfo@servletRequest"/>
                        <uix:switcher childNameBinding="dvEnabled@servletRequest">
                            <uix:case name="true">                            
                                <uix:styledText styleClass="OraInstructionText" textBinding="CLICK@stream"
                                />
                            </uix:case>
                            <uix:default>
                                <uix:link textBinding="CLICK@stream"
                                destinationBinding="createStrmAdmin@servletRequest"/>
                            </uix:default>
                            </uix:switcher>
            </uix:flowLayout>
             </uix:cellFormat>
 </uix:rowLayout>
								<uix:rowLayout>
											<uix:cellFormat>
												<uix:spacer height="10" />									
											</uix:cellFormat>
										</uix:rowLayout>
							    <uix:rowLayout>
								<uix:cellFormat width="55%" vAlign="top">

									<uix:tableLayout >
										<uix:rowLayout>
											<uix:cellFormat>
												<uix:spacer height="10" />									
											</uix:cellFormat>
										</uix:rowLayout>
										<%--uix:rowLayout>
											<uix:cellFormat hAlign="left"  columnSpan="4">
												<uix:styledText textBinding="STREAMS_SETUP_TYPE@stream" styleClass="OraInstructionText" />
											</uix:cellFormat>
										</uix:rowLayouti--%>
										<uix:rowLayout>
											<uix:cellFormat>
												<uix:spacer height="10" />									
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:cellFormat >
												<uix:messageRadioButton textBinding="SETUP_REPLICATION@stream" name="setup_type"  value="replication"  shortDescBinding="SETUPWIZINFO@stream"  selectedBinding="SELECT_WIZARDS@servletRequest" 
																		disabledBinding="SHOW_RECOVERY_OPTIONS@servletRequest" onClick="setReplicationButtonState(1)"/>
											</uix:cellFormat>
										</uix:rowLayout>
                                     <uix:rowLayout>
                                     	<uix:cellFormat  hAlign="center"  columnSpan="3"> 
										<uix:tableLayout >
										<uix:rowLayout>
											<uix:cellFormat >
												<uix:messageRadioButton textBinding="REPLICATE_DB@stream" name="repl_type"  value="global"  shortDescBinding="SETUP_DB_INFO@stream"  selectedBinding="SELECT_WIZARDS@servletRequest" 
																		disabledBinding="SHOW_RECOVERY_OPTIONS@servletRequest" tipBinding="TIP_REPLICATE_DB@stream"/>
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:cellFormat >
												<uix:messageRadioButton textBinding="REPLICATE_SCHEMAS@stream" name="repl_type"  value="schema"  shortDescBinding="SETUP_SCHEMAS_INFO@stream" disabledBinding="SHOW_RECOVERY_OPTIONS@servletRequest" tipBinding="TIP_REPLICATE_SCHEMA@stream"/>
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout renderedBinding="is10g@servletRequest">
											<uix:cellFormat >
												<uix:messageRadioButton textBinding="REPLICATE_TTS@stream"  name="repl_type"  value="tts"  shortDescBinding="SETUP_TTS_INFO@stream" 
																		disabledBinding="SHOW_RECOVERY_OPTIONS@servletRequest" tipBinding="TIP_REPLICATE_TTS@stream"/>
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:cellFormat>
												<uix:messageRadioButton textBinding="REPLICATE_TABLES@stream" name="repl_type"  value="table"  shortDescBinding="SETUP_TABLES_INFO@stream" disabledBinding="SHOW_RECOVERY_OPTIONS@servletRequest" tipBinding="TIP_REPLICATE_TABLES@stream"/>
											</uix:cellFormat>
										</uix:rowLayout>
                                      </uix:tableLayout>
                                      </uix:cellFormat>
                                      </uix:rowLayout>
								    	<uix:rowLayout>
											<uix:cellFormat>
												<uix:spacer height="10" />									
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout renderedBinding="is10g@servletRequest">
											<uix:cellFormat>
												<uix:messageRadioButton textBinding="SETUP_DWNSTRM@stream" name="setup_type"  value="downstream" shortDescBinding="SETUP_DWNSTRM_INFO@stream" onClick="setReplicationButtonState(0)"  tipBinding="TIP_SETUP_DOWNSTREAM@stream"/>
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout rendered="false">
											<uix:cellFormat>
												<uix:spacer height="10" />									
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout rendered="false">
											<uix:cellFormat>
												<uix:messageRadioButton textBinding="CREATE_STRMADMN@stream" name="setup_type"  value="createStrmAdmin" shortDescBinding="SETUP_STRMADMN_INFO@stream" onClick="setReplicationButtonState(0)"  tipBinding="TIP_CREATE_STRM_ADMIN@stream"/>
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:cellFormat>
												<uix:spacer height="10" />									
											</uix:cellFormat>
										</uix:rowLayout>
										<uix:rowLayout>
											<uix:cellFormat>
												<uix:messageRadioButton textBinding="CREATE_QUEUE@stream" name="setup_type"  value="createq" shortDescBinding="SETUP_AQ_INFO@stream" onClick="setReplicationButtonState(0)"  tipBinding="TIP_CREATE_QUEUE@stream"/>
											</uix:cellFormat>
										</uix:rowLayout>
									   <uix:rowLayout>
										<uix:cellFormat>
											
											 <uix:header textBinding="HOST_CREDS@stream">
												<uix:spacer width="10" height="10" />
												<uix:styledText styleClass="OraInstructionText" textBinding="HOST_TIP@stream"/>
												<uix:spacer width="10" height="10" />
											   
											   <%@ include file="/credentials.jspf" %>
											 </uix:header>
											
										</uix:cellFormat>
									</uix:rowLayout>
									</uix:tableLayout>
								</uix:cellFormat>
								<uix:cellFormat width="100%" vAlign="top">
										<uix:contentContainer textBinding="OVERVIEW@stream"   width="100%" background="light">
							              
										      
											  <uix:bulletedList>
											  <uix:contents>
												<uix:styledText styleClass="OraInstructionText"     textBinding="TIP_SETUP_OPT_1@stream"/>
												  <uix:styledText styleClass="OraInstructionText"     textBinding="TIP_SETUP_OPT_2@stream"/>
													  
												  <uix:styledText styleClass="OraInstructionText"  textBinding="TIP_SETUP_OPT_3@stream" renderedBinding="is10g@servletRequest"/>
													  
												  <uix:styledText styleClass="OraInstructionText"  textBinding="TIP_SETUP_OPT_4@stream" renderedBinding="is10g@servletRequest"/>
												  <uix:styledText styleClass="OraInstructionText"  textBinding="TIP_SETUP_OPT_5@stream"/>
													  
												  <uix:styledText styleClass="OraInstructionText"  textBinding="TIP_SETUP_OPT_6@stream"/>
												  <uix:styledText styleClass="OraInstructionText"  textBinding="TIP_SETUP_OPT_7@stream"/>
											  </uix:contents>
											  </uix:bulletedList>
											  
							             
						                 </uix:contentContainer>
									</uix:cellFormat>
								</uix:rowLayout>
 
							</uix:tableLayout>
                
				 <uix:pageButtons>
					<uix:pageButtonBar>
						<uix:button textBinding="CANCEL@stream" destinationBinding="CANCELURL@servletRequest" shortDescBinding="CANCEL@streams" />
						<uix:submitButton textBinding="CONTINUE@stream"  name="event" value="continue" shortDescBinding="CONTINUE@streams" />
				 </uix:pageButtonBar>
				 </uix:pageButtons>

<%@ include file="../streamsLinks.jspf" %> 			
        </uix:pageLayout> 
                <uix:pageStatus>
                 </uix:pageStatus>
		 </db:form> 
      </uix:body>
    </uix:document> 
</uix:renderingContext> 

