<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>
<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
          </uix:metaContainer>
          
          <uix:body onLoad="document.forms[0].setAttribute('autocomplete', 'OFF');">
          
          <db:form name="source_db_form" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/setup/sourceDB" />
                  
          
          <uix:pageLayout titleBinding="CSSD@sb@servletRequest">
          <uix:messages>
                        <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <%@ include file="/database/global.jspf" %>

          <!-- main contents -->
          <uix:contents>

       <uix:tableLayout width="975">
     <uix:contents>
       <uix:rowLayout vAlign="top">
         <uix:contents>
           <uix:cellFormat>
             <uix:contents>
               <uix:spacer height="10" width="10"/>
             </uix:contents>
           </uix:cellFormat>
         </uix:contents>
       </uix:rowLayout>

       <uix:rowLayout vAlign="top">
         <uix:contents>
           <uix:cellFormat>
             <uix:contents>

             <uix:tableLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                       <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" textBinding="SRC_DB@sb@servletRequest"/>
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
                         <uix:spacer width="10" height="10" />
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
                        <uix:styledText textBinding="instanceName@servletRequest" styleClass="OraDataText"/>
                       </uix:contents>
                    </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat>
                       <uix:contents>
                         <uix:spacer width="10" height="5" />
                       </uix:contents>
                    </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout >
                    <uix:cellFormat hAlign="right">
                       <uix:contents>
                        <uix:styledText styleClass="OraInstructionText" textBinding="STRM_ADMIN@sb@servletRequest" labeledNodeId="strm_admin" />
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
                         <uix:spacer width="10" height="10" />
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
                          <uix:textInput columns="20" id="strm_admin" name="strm_admin" noAutoComplete="true" textBinding="srcStrmUser@defaultBean@servletRequest" shortDescBinding="STRM_ADMIN@sb@servletRequest" />
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
  <uix:spacer width="3" height="10" />
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
                         <uix:submitButton formName="source_db_form" name="event" value="create_src_user" textBinding="CREATE_STRM_ADMIN@sb@servletRequest" shortDescBinding="CREATE_STRM_ADMIN@sb@servletRequest" />
                       </uix:contents>
                    </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                    <uix:cellFormat>
                       <uix:contents>
                         <uix:spacer width="10" height="5" />
                       </uix:contents>
                    </uix:cellFormat>
                </uix:rowLayout>
                
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                       <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" textBinding="PASSWORD@sb@servletRequest" labeledNodeId="strm_pwd" />
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
                         <uix:spacer width="10" height="10" />
                       </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                       <uix:contents>
                          <uix:textInput columns="20" name="strm_pwd" id="strm_pwd" secret="true" textBinding="srcStrmSecretPwd@defaultBean@servletRequest" noAutoComplete="true" shortDescBinding="PASSWORD@sb@servletRequest" />
                       </uix:contents>
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>

             </uix:contents>
           </uix:cellFormat>

           <uix:cellFormat hAlign="right">
             <uix:contents>
               <uix:contentContainer textBinding="OVERVIEW@sb@servletRequest"
	                             width="400"
	                             background="light">
	          <uix:contents>
	              <uix:stackLayout>
	                  <uix:contents>
	                      <uix:styledText styleClass="OraInstructionText"
	                      textBinding="OVERVIEW_STR1@sb@servletRequest"/>
	                      <uix:spacer height="10"/>
	                      <uix:styledText styleClass="OraInstructionText"
	                      textBinding="OVERVIEW_STR2@sb@servletRequest"/>
	                      <uix:styledText styleClass="OraInstructionText"
	                      textBinding="OVERVIEW_STR3@sb@servletRequest"/>
	                      <uix:styledText styleClass="OraInstructionText"
	                      textBinding="OVERVIEW_STR4@sb@servletRequest"/>
	                  </uix:contents>
	              </uix:stackLayout>
	          </uix:contents>
                 </uix:contentContainer>
             </uix:contents>
           </uix:cellFormat>
         </uix:contents>
       </uix:rowLayout>
     </uix:contents>
   </uix:tableLayout>
   <uix:spacer height="10" width="10"/>

             <!-- page contents end here -->

          </uix:contents>

         <!-- navigation -->

        <uix:pageButtons>
             <uix:pageButtonBar>
                <uix:contents>
                    <uix:button textBinding="CANCEL@sb@servletRequest" destinationBinding="cancelURL@servletRequest" shortDescBinding="CANCEL@sb@servletRequest" />
                    <uix:navigationBar maxValue="5" formSubmitted="true" />
                </uix:contents>
             </uix:pageButtonBar>
        </uix:pageButtons>
        
        <uix:location>
           <uix:train>
             <uix:contents>
                <uix:link textBinding="SRC_DB@sb@servletRequest" />
                <uix:link textBinding="DEST_DB@sb@servletRequest" />
                <uix:link textBinding="CONFIG_REPLN@sb@servletRequest" />
                <uix:link textBinding="OBJ_SEL@sb@servletRequest" />
                <uix:link textBinding="REVIEW@sb@servletRequest" />
             </uix:contents>
           </uix:train>
        </uix:location>
       

  </uix:pageLayout>
  </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>


