<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
            <db:form name="source_db_form" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/sourceDBCreateAdmin" />
                <uix:pageLayout titleBinding="SDB_CSA@sb@servletRequest">
                    <uix:messages>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                    </uix:messages>
                    <%@ include file="/database/global.jspf" %>

                    <!-- main contents -->
                    <uix:contents>

                        <uix:spacer height="10" width="10" />
                        <uix:tableLayout width="680">
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:labeledFieldLayout>
                                                    <uix:contents>
                                                        <uix:messageTextInput columns="18" noAutoComplete="true" name="sys_user" promptBinding="SYS_USER@sb@servletRequest" textBinding="srcSYSUser@defaultBean@servletRequest" shortDescBinding="SYS_USER@sb@servletRequest" />
                                                        <uix:messageTextInput noAutoComplete="true" columns="18" name="sys_pwd" promptBinding="SYS_PWD@sb@servletRequest" textBinding="srcSYSSecretPwd@defaultBean@servletRequest" secret="true" shortDescBinding="SYS_PWD@sb@servletRequest" />
                                                        <uix:messageTextInput noAutoComplete="true" columns="18" name="strm_user" promptBinding="SAU@sb@servletRequest" textBinding="srcStrmUser@defaultBean@servletRequest" shortDescBinding="SAU@sb@servletRequest" />
                                                        <uix:messageTextInput noAutoComplete="true" columns="18" name="strm_pwd" promptBinding="SAP@sb@servletRequest" tipBinding="CONF@sb@servletRequest" textBinding="srcStrmSecretPwd@defaultBean@servletRequest" secret="true" shortDescBinding="SAP@sb@servletRequest" />
                                                        <uix:spacer height="1" width="1"/>
                                                    </uix:contents>
                                                </uix:labeledFieldLayout>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                    </uix:contents>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@sb@servletRequest" name="event" value="cancel_user_src" shortDescBinding="CANCEL@sb@servletRequest" />
                                <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="create_user_src" shortDescBinding="OK@sb@servletRequest" />
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
        
                    <uix:location>
                        <uix:train>
                            <uix:contents>
                                <uix:link textBinding="SRC_DB@sb@servletRequest" />
                                <uix:link textBinding="DEST_DB@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="CONFIG_REPLN@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="OBJ_SEL@sb@servletRequest" disabled="true" />
                                <uix:link textBinding="REVIEW@sb@servletRequest" disabled="true" />
                            </uix:contents>
                        </uix:train>
                    </uix:location>
        
                    <uix:pageStatus>
                        <uix:styledText styleClass="OraInstructionText" textBinding="SDB_CSA_MESG@sb@servletRequest"/>
                    </uix:pageStatus>


                     
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>

