<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ page import="java.util.Vector" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
    <oem:setURLEncoder id="renderingContext"/>
    <uix:dataScope>
        <uix:document>
            <uix:metaContainer>
                <!-- Set the page title -->
                <uix:head titleBinding="title@servletRequest"/>
                <db:script src="/database/utils.js"/>   <%-- lovField support --%>
            </uix:metaContainer>
            <db:form name="summaryPage" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
                <uix:formValue name="pageName" value="/database/dist/streams/setup/summaryPage" />
                <uix:pageLayout titleBinding="CSR@sb@servletRequest">
                    <%@ include file="/database/global.jspf" %>       

                    <!-- main contents -->
                    <uix:contents>
                        <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
						<oem:messageBox messageType="warning"
                            errorTableBinding="warning@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <!-- Define the content of the page here -->
                      <uix:tableLayout>
                           <uix:rowLayout>
                              <uix:cellFormat width="100%" columnSpan="4">
                                                <uix:contents>
                                                    <uix:styledText textBinding="SETUP_SUMMARY_TEXT@sb@servletRequest" styleClass="OraInstructionText"/>
                                                </uix:contents>
                                            </uix:cellFormat>

                              </uix:rowLayout>
                           <uix:rowLayout>
								<uix:cellFormat vAlign="top" width="50%" >
                                   <uix:stackLayout>
									<uix:header textBinding="SRC_DB@sb@servletRequest" styleClass="OraHeaderSubSub">
									 <uix:labeledFieldLayout >
										<uix:contents childDataBinding="srcSummary@defaultBean@servletRequest">
										  <uix:styledText styleClass="OraInstructionText" textBinding="name"/>

										  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="value"/>
											</uix:contents>
									  </uix:labeledFieldLayout>
                                   </uix:header>
                                  </uix:stackLayout>
                                </uix:cellFormat>
								<uix:cellFormat vAlign="top" width="50%" >
                                   <uix:stackLayout>
									<uix:header textBinding="DEST_DB@sb@servletRequest" styleClass="OraHeaderSubSub">
									 <uix:labeledFieldLayout >
										<uix:contents childDataBinding="destSummary@defaultBean@servletRequest">
										  <uix:styledText styleClass="OraInstructionText" textBinding="name"/>

										  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="value"/>
											</uix:contents>
									  </uix:labeledFieldLayout>
									</uix:header>
                                  </uix:stackLayout>
                                </uix:cellFormat>
                           </uix:rowLayout>
						</uix:tableLayout> 
                        <%--uix:header textBinding="SUMMARY_OPERATIONS@streamBundle@servletRequest" styleClass="OraHeaderSubSub">
                            <uix:textInput
			    textBinding="actions@defaultBean@servletRequest"
			    name="summary_page" rows="20" columns="100"
			    readOnly="true"
shortDescBinding="SUMMARY_OPERATIONS@streamBundle@servletRequest" />
			</uix:header--%>
		    <uix:spacer height="10"/>
			 <uix:switcher childNameBinding="objectPane@defaultBean@servletRequest">
               <uix:case name="true">

				<uix:hideShowHeader id="showObjList" textBinding="OBJ_SEL@sb@servletRequest"  formSubmitted="true"  
                      disclosedBinding="showObjList@servletRequest">
			   <uix:contents>
                <uix:tableLayout>
                           <uix:rowLayout>
								<uix:cellFormat vAlign="top" width="50%" renderedBinding="isNotGlobal@servletRequest">
                                   <uix:stackLayout>
									<uix:header textBinding="selectionText@defaultBean@servletRequest" styleClass="OraHeaderSubSub">
                                      <oem:table
										  width="100%"
										  blockSize="10"
										  name="selectedObjectPane"
										  dataSourceProp="selectedObjectPane"
										  beanKey="defaultBean"
										  copyParams="target,type"
										  alternateTextBinding="NO_ITEMS_TO_DISPLAY@sb@servletRequest" summaryBinding="REVIEW@sb@servletRequest">
									   </oem:table>
									 </uix:header>
                                  </uix:stackLayout>
                                </uix:cellFormat>
								<uix:cellFormat vAlign="top" width="50%"  renderedBinding="excludedSchemas@servletRequest">
                                   <uix:stackLayout>
									<uix:header textBinding="EXCLUDED_SCHEMAS@sb@servletRequest" styleClass="OraHeaderSubSub">
                                      <oem:table
										  width="100%"
										  blockSize="10"
										  name="excludedSchemasPane"
										  dataSourceProp="excludedSchemasPane"
										  beanKey="defaultBean"
										  copyParams="target,type"
										  alternateTextBinding="NO_ITEMS_TO_DISPLAY@sb@servletRequest" summaryBinding="REVIEW@sb@servletRequest">
									   </oem:table>
									    
									</uix:header>
                                  </uix:stackLayout>
                                </uix:cellFormat>
   								<uix:cellFormat vAlign="top" width="50%"  renderedBinding="excludedTables@servletRequest" >
                                   <uix:stackLayout>
									<uix:header textBinding="EXCLUDED_TABLES@sb@servletRequest" styleClass="OraHeaderSubSub">
                                      <oem:table
										  width="100%"
										  blockSize="10"
										  name="excludedTablesPane"
										  dataSourceProp="excludedTablesPane"
										  beanKey="defaultBean"
										  copyParams="target,type"
										  alternateTextBinding="NO_ITEMS_TO_DISPLAY@sb@servletRequest" summaryBinding="REVIEW@sb@servletRequest">
									   </oem:table>
									    
									</uix:header>
                                  </uix:stackLayout>
                                </uix:cellFormat>
                           </uix:rowLayout>
						</uix:tableLayout> 
                     </uix:contents>
			 </uix:hideShowHeader>
            </uix:case>
           </uix:switcher>
		    <!-- page contents end here -->

                    </uix:contents>

                    <!-- navigation -->
         
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:button textBinding="CANCEL@sb@servletRequest" destinationBinding="cancelURL@servletRequest" shortDescBinding="CANCEL@sb@servletRequest" />
									  <uix:submitButton textBinding="EDIT_SCRIPT@sb@servletRequest" name="event" value="editScripts" shortDescBinding="EDIT_SCRIPT@sb@servletRequest" />
                                <uix:navigationBar formSubmitted="true" maxValueBinding="maxPages@defaultBean@servletRequest"  valueBinding="currentPage@defaultBean@servletRequest" name="wizardNavigation"/>
                                    <uix:submitButton textBinding="SUBMIT@streamBundle@servletRequest" name="event" value="finish" shortDescBinding="SUBMIT@streamBundle@servletRequest" />
								<uix:switcher childNameBinding="is10gR2@servletRequest">
								  <uix:case name="true">


                                  </uix:case>
                                 </uix:switcher>

              	


                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
					 <%@ include file="train.jspf" %>

                    <uix:pageStatus>
                    </uix:pageStatus>
        
                     
                </uix:pageLayout>
            </db:form>
        </uix:document>
    </uix:dataScope>
</uix:renderingContext>

                  
        
