
<%--
  -- Page:       tableLOV.jsp
  -- Controller: db/adm/dist/SetupController.java 
  -- Description: Table selection LOV for excluding tables
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
    request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));

%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELTABLE@sb@servletRequest"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>
      <script>
      		  function submitMainForm()
			  {
					var iNumberOfCheckBoxes=0;
					var iCheckBoxCount=0;
					var sCheckBoxNamePrefix='tableLOVList:selected:';
					var sToBeAddedSubComponentsIndexes='';
					var iSelectedCheckBoxCount=0;
					for(var i=0;i<document.forms[0].elements.length;i++)
					{
						var sElemenetName=document.forms[0].elements[i].name;
						var sCheckBoxName=sCheckBoxNamePrefix+iCheckBoxCount;
						if(sCheckBoxName==sElemenetName)
						{
							if(document.forms[0].elements[i].checked)
							{
								if(iSelectedCheckBoxCount==0)
								{
									sToBeAddedSubComponentsIndexes=document.forms[0].elements[i].value;  
								}
								else
								{
									sToBeAddedSubComponentsIndexes = sToBeAddedSubComponentsIndexes + ',' + document.forms[0].elements[i].value;
								}
								iSelectedCheckBoxCount++;
							}                                          
							iCheckBoxCount++;
						}
					}
					top.window.opener.document.forms[0].event.value="tableSelected";
					top.window.opener.document.forms[0].ToBeAddedSubComponentsIndexes.value=sToBeAddedSubComponentsIndexes;
					top.window.opener.document.forms[0].submit();
					top.close();
			  }
      </script>
    </uix:metaContainer>
    <uix:body>

   <db:form name="tableLOV" 
            destination="/console/database/dist/streams/setup" 
            copyParams="target,type,cancelURL,sname,oname,otype, tableLOVList">
      <uix:pageLayout titleBinding="SELTABLE@sb@servletRequest">
        <uix:formValue name="pageName" value="/database/dist/streams/setup/tableLOV"/>
        <uix:formValue name="event" value="selectTable"/>

		 

          <uix:tableLayout cellSpacing="2" >

            <%-- Search Criteria and Instruction --%>
              <uix:rowLayout>
                <uix:stackLayout>

				<uix:header textBinding="SEARCH@applyBundle@servletRequest">
                     <uix:stackLayout>
					
                         <uix:styledText textBinding="SEARCH_INFO@applyBundle@servletRequest" styleClass="OraInstructionText"/>
                         <uix:tableLayout >
                             <uix:rowLayout >
							 <uix:cellFormat hAlign="left" wrappingDisabled="false">
                                     <uix:styledText styleClass="OraInstructionText" labeledNodeId="schema" textBinding="SCHEMA@sb@servletRequest" />
                                 </uix:cellFormat>
								  <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
				    <uix:textInput name="schema" id="schema"   textBinding="schemaName@servletRequest" shortDescBinding="SCHEMA@applyBundle@servletRequest"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" >
                                     <uix:styledText styleClass="OraInstructionText" labeledNodeId="tableName" textBinding="TABLE@applyBundle@servletRequest"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:textInput columns="20" name="tableName" id="tableName" shortDescBinding="TABLE@applyBundle@servletRequest"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:submitButton name="event" value="searchTables"  textBinding="GO@applyBundle@servletRequest" shortDescBinding="GO@applyBundle@servletRequest"  />
                                 </uix:cellFormat>
                             </uix:rowLayout>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:rowLayout width="360">
                                 <uix:cellFormat hAlign="left" >
                                   <uix:contents/>
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" >
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" >
                                   <uix:contents/>
                                 </uix:cellFormat>
                             </uix:rowLayout>
                         </uix:tableLayout>
                         <uix:styledText textBinding="TO_RUN@applyBundle@servletRequest" styleClass="OraInlineInfoText"/>
                       
                     </uix:stackLayout>
                 </uix:header>
                 

                  <uix:header textBinding="TABLE@sb@servletRequest">
                    <uix:dataScope currentDataBinding="tableLOVList@defaultBean@servletRequest">
										
											<uix:table name="tableLOVList" id="tableLOVList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest" 	formSubmitted="true" width="100%" tableDataBinding="rowData" valueBinding="startIndex" maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize" partialRenderMode="true"	summaryBinding="PSUMM@sb@servletRequest" shortDescBinding="PSUMM@sb@servletRequest" >
												<uix:column>
													<uix:columnHeader>
													<uix:sortableHeader textBinding="SCHEMA@sb@servletRequest" sortable="true"/>
													</uix:columnHeader>
													<uix:columnFormat columnDataFormat="textFormat"/>
													<uix:text textBinding="schemaIndex" />
												</uix:column>
												<uix:column>
													<uix:columnHeader>
													<uix:sortableHeader textBinding="TABLE@sb@servletRequest" sortable="true"/>
													</uix:columnHeader>
													<uix:columnFormat columnDataFormat="textFormat"/>
													<uix:text textBinding="tableIndex" />
												</uix:column>
												<uix:tableSelection>
												<uix:multipleSelection shortDescBinding="SELECT@dbBundle@servletRequest" selectedBinding="selectedItems" >
												 </uix:multipleSelection>
												 
												</uix:tableSelection>
												
											</uix:table>
										 </uix:dataScope>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@sb@servletRequest" onClick="top.close()" />
            <uix:submitButton textBinding="SELECT@sb@servletRequest"  onClick="submitMainForm()"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>
