<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>

<%@ page import="oracle.sysman.db.rsc.streams.StreamsMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("streamBundle", new BundleDataObject(NLSUtil.getBundle(StreamsMsg.class.getName(), request)));
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/>
<uix:dataScope>
<uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="title@defaultBean@servletRequest"/>
            <db:script src="/database/utils.js"/>   <%-- lovField support --%>
          </uix:metaContainer>
          <db:form name="tableRuleSubsetTable" method="post" destination="/console/database/dist/streams/setup" copyParams="target,type, otype,objectType,sname, oname">
          <uix:formValue name="pageName" value="/database/dist/streams/setup/tableRuleSubsetTable" />
          <uix:pageLayout titleBinding="OSST@sb@servletRequest">
          <%@ include file="/database/global.jspf" %>       

          <!-- main contents -->
          <uix:contents>
             <oem:messageBox messageType="info"
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
<!-- Define the content of the page here -->
             
              <oem:table name="subsetTableDataSource"
                           beanKey="defaultBean"
                           formSubmitted="true"
                           dataSourceProp="subsetTableDataSource"
                           width="50%" blockSize="20"
                           summaryBinding="PSUMM@sb@servletRequest">
              </oem:table>
              </uix:contents>


         <!-- navigation -->
         
        <uix:pageButtons>
             <uix:pageButtonBar>
                <uix:contents>
                    <uix:submitButton textBinding="CANCEL@sb@servletRequest" name="event" value="cancelSubsetTable" />
                    <uix:submitButton textBinding="OK@sb@servletRequest" name="event" value="okSubsetTable" />
                </uix:contents>
             </uix:pageButtonBar>
        </uix:pageButtons>
        
        <uix:location>
           <uix:train value="4">
             <uix:contents>
                <uix:link textBinding="SRC_DB@sb@servletRequest" disabled="true" />
                <uix:link textBinding="DEST_DB@sb@servletRequest" disabled="true" />
                <uix:link textBinding="CONFIG_REPLN@sb@servletRequest" disabled="true" />
                <uix:link textBinding="OBJ_SEL@sb@servletRequest" />
                <uix:link textBinding="REVIEW@sb@servletRequest" disabled="true" />
             </uix:contents>
           </uix:train>
        </uix:location>
        
        <uix:pageStatus>
             <uix:styledText styleClass="OraInstructionText" textBinding="SSPAGEMSG@sb@servletRequest"/>
        </uix:pageStatus>
        
       
  </uix:pageLayout>
  </db:form>
 </uix:document>
</uix:dataScope>
</uix:renderingContext>

