
<%--
  -- Page:       targetListLOV.jsp
  -- Controller: db/adm/dist/SetupController.java 
  -- Description: Target selection LOV 
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.streams.StrmSetupMsg" %>
<%@ page import="oracle.sysman.db.rsc.inst.DBMsg" %>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("sb", new BundleDataObject(NLSUtil.getBundle(StrmSetupMsg.class.getName(), request)));
  request.setAttribute("dbBundle", new BundleDataObject(NLSUtil.getBundle(DBMsg.class.getName(), request)));
    request.setAttribute("applyBundle", new BundleDataObject(NLSUtil.getBundle(ApplyMsg.class.getName(), request)));

%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="ALL_DATABASE_TARGETS@sb@servletRequest"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      
	  <script language="JavaScript" >
			<%@ include file="/database/LOV.js"%>
			</script>
      <script>
      		  function submitMainForm()
			  {
					var iNumberOfCheckBoxes=0;
					var iCheckBoxCount=0;
					var sCheckBoxNamePrefix='targetLOVList:selected:';
					var sToBeAddedSubComponentsIndexes='';
					var iSelectedCheckBoxCount=0;
					for(var i=0;i<document.forms[0].elements.length;i++)
					{
						var sElementName=document.forms[0].elements[i].name;
						var sCheckBoxName=sCheckBoxNamePrefix+iCheckBoxCount;
						if(sCheckBoxName==sElementName)
						{
							if(document.forms[0].elements[i].checked)
							{
								if(iSelectedCheckBoxCount==0)
								{
									sToBeAddedSubComponentsIndexes=document.forms[0].elements[i].value;  
								}
								else
								{
									sToBeAddedSubComponentsIndexes = sToBeAddedSubComponentsIndexes + ',' + document.forms[0].elements[i].value;
								}
								iSelectedCheckBoxCount++;
							}                                          
							iCheckBoxCount++;
						}
					}
					top.window.opener.document.forms[0].event.value="targetSelected";
					top.window.opener.document.forms[0].ToBeAddedSubComponentsIndexes.value=sToBeAddedSubComponentsIndexes;
					top.window.opener.document.forms[0].submit();
					top.close();
			  }
      </script>
    </uix:metaContainer>
    <uix:body>

   <db:form name="targetLOV"             
            copyParams="target,type,cancelURL">
      <uix:pageLayout titleBinding="SELTABLE@sb@servletRequest">
        <uix:formValue name="pageName" value="/database/dist/streams/setup/targetListLOV"/>
        <uix:formValue name="event" value="selectTarget"/>

		 

          <uix:tableLayout cellSpacing="2" width="80%">

            <%-- Search Criteria and Instruction --%>
              <uix:rowLayout>
                <uix:stackLayout>

				<uix:header textBinding="SEARCH_TARGETS@sb@servletRequest">
                     <uix:stackLayout>
					
                         <uix:styledText textBinding="SEARCH_TARGETS@sb@servletRequest" styleClass="OraInstructionText"/>
                         <uix:tableLayout width="80%">
                             <uix:rowLayout>
							 <uix:cellFormat>
                                     <uix:spacer height="10"/>
                                 </uix:cellFormat>
								<uix:cellFormat>
                                     <uix:styledText styleClass="OraInstructionText" labeledNodeId="targetName" textBinding="TARGET_NAME@sb@servletRequest"/>
                                 </uix:cellFormat>
								  <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
								 <uix:textInput name="targetName" id="targetName"   textBinding="targetName@servletRequest" shortDesc=""/>
                                 </uix:cellFormat>
								 </uix:rowLayout>

								 <uix:rowLayout>
                                 <uix:cellFormat>
                                     <uix:spacer height="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" width="120">
                                     <uix:styledText styleClass="OraInstructionText" labeledNodeId="targetVersion" textBinding="TARGET_VERSION@sb@servletRequest"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:textInput columns="20" name="targetVersion" id="targetVersion" textBinding="version@servletRequest" shortDesc=""/>
                                 </uix:cellFormat>
								 </uix:rowLayout>
								 <uix:rowLayout>
                                 <uix:cellFormat>
                                     <uix:spacer height="10"/>
                                 </uix:cellFormat>
								 <uix:cellFormat hAlign="left" width="120">
                                     <uix:styledText styleClass="OraInstructionText" labeledNodeId="Host" textBinding="HOST@sb@servletRequest"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:spacer height="10" width="10"/>
                                 </uix:cellFormat>
                                 <uix:cellFormat>
                                     <uix:textInput columns="20" name="host" id="host" textBinding="host@servletRequest" shortDesc=""/>
                                 </uix:cellFormat>
                                  </uix:rowLayout>
				<uix:rowLayout>
                                 <uix:cellFormat>
                                     <uix:submitButton name="event" value="searchTargets"  textBinding="GO@applyBundle@servletRequest" shortDescBinding="GO@applyBundle@servletRequest"  />
                                 </uix:cellFormat>
                             </uix:rowLayout>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:spacer height="10" width="10"/>
                             <uix:rowLayout width="360">
                                 <uix:cellFormat hAlign="left" width="100">
                                   <uix:contents/>
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" width="120">
                                 </uix:cellFormat>
                                 <uix:cellFormat hAlign="left" width="100">
                                   <uix:contents/>
                                 </uix:cellFormat>
                             </uix:rowLayout>
                         </uix:tableLayout>
                         
                     </uix:stackLayout>
                 </uix:header>
                 

                  <uix:header textBinding="TABLE@sb@servletRequest">
                    <uix:dataScope currentDataBinding="targetLOVList@servletRequest">
										
											<uix:table name="targetLOVList" id="tableLOVList" alternateTextBinding="NO_ITEMS_FOUND@applyBundle@servletRequest" 	formSubmitted="true" width="75%" tableDataBinding="rowData" valueBinding="startIndex" maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize" partialRenderMode="true"	summaryBinding="PSUMM@sb@servletRequest" shortDescBinding="PSUMM@sb@servletRequest" >
												<uix:column>
													<uix:columnHeader>
													<uix:sortableHeader textBinding="TARGET_NAME@sb@servletRequest" sortable="true"/>
													</uix:columnHeader>
													<uix:columnFormat columnDataFormat="textFormat"/>
													<uix:text textBinding="targetNameIndex" />
												</uix:column>
												<uix:column>
													<uix:columnHeader>
													<uix:sortableHeader textBinding="TARGET_VERSION@sb@servletRequest" sortable="true"/>
													</uix:columnHeader>
													<uix:columnFormat columnDataFormat="textFormat"/>
													<uix:text textBinding="targetVersionIndex" />
												</uix:column>
												<uix:column>
													<uix:columnHeader>
													<uix:sortableHeader textBinding="TARGET_HOST@sb@servletRequest" sortable="true"/>
													</uix:columnHeader>
													<uix:columnFormat columnDataFormat="textFormat"/>
													<uix:text textBinding="hostNameIndex" />
												</uix:column>
												<uix:column>
													<uix:columnHeader>
													<uix:sortableHeader textBinding="TARGET_TYPE@dbBundle@servletRequest" sortable="true"/>
													</uix:columnHeader>
													<uix:columnFormat columnDataFormat="textFormat"/>
													<uix:text textBinding="targetTypeIndex" />
												</uix:column>
												<uix:tableSelection>
												<uix:multipleSelection shortDesc="SELECT@dbBundle@servletRequest" selected="selectedItems" >
												 </uix:multipleSelection>
												 
												</uix:tableSelection>
												
											</uix:table>
										 </uix:dataScope>  
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@sb@servletRequest" onClick="top.close()" />
            <uix:submitButton textBinding="SELECT@sb@servletRequest"  onClick="submitMainForm()"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>
