<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %> 
<%@ page import="oracle.sysman.db.rsc.streams.PerfAdvisorMsgID"%>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsOverviewBean" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/utils.js"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>   
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
   
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="setupOverview" method="post" destination="/console/database/dist/streams/setupOverview" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/dist/streams/setupOverview"/>    
                <uix:pageLayout titleBinding="STREAMS@streamsMsgs">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                     destTableBinding="msgUrls@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                   
                    <uix:contents>
                      <uix:header textBinding="REP_MANAGEMENT@dbInstMsgs">
                             <uix:contentContainer width="100%" background="light">

                                <uix:styledText styleClass="OraInstructionText"     textBinding="EM_STREAMS_FUNCTIONS@streamsMsgs"/>
                                  <uix:bulletedList>
                                  <uix:contents>
                                      <uix:styledText styleClass="OraInstructionText"     textBinding="EM_STREAMS_FUNCTIONS1@streamsMsgs"/>
                                      <uix:styledText styleClass="OraInstructionText"     textBinding="EM_STREAMS_FUNCTIONS2@streamsMsgs"/>

                                      <uix:styledText styleClass="OraInstructionText"  textBinding="EM_STREAMS_FUNCTIONS3@streamsMsgs"/>

                                      <uix:styledText styleClass="OraInstructionText"  textBinding="EM_STREAMS_FUNCTIONS4@streamsMsgs"/>
                                      <uix:styledText styleClass="OraInstructionText"  textBinding="EM_STREAMS_FUNCTIONS5@streamsMsgs"/>

                                  </uix:contents>
                                  </uix:bulletedList>


                             </uix:contentContainer>
                    
                        </uix:header>
                   
                    </uix:contents>  
             
                <!-- To add common related links  -->                    
                <jsp:include page="queue/relatedLinksInclude.jsp" />
                <uix:ref refID="relatedLinksInclude" />
                
                </uix:pageLayout>
            </db:form>
        </uix:body>                  
    </uix:document>
</uix:renderingContext>

