<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %> 
<%@ page import="oracle.sysman.db.rsc.streams.PerfAdvisorMsgID"%>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsOverviewBean" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/utils.js"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>   
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
    <uix:bundle name="captureMsgs" class="oracle.sysman.db.rsc.streams.CaptureMsg"/>
    <uix:bundle name="paMsgs" class="oracle.sysman.db.rsc.streams.PerfAdvisorMsg"/>
	<uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
		<uix:case name="true">
			<uix:rawText>
	<meta http-equiv="Refresh" content="<%=request.getAttribute("refreshHomeValue")%>; URL=<%=request.getAttribute("autoRefreshUrl") %>" />

			</uix:rawText>
		</uix:case>
	</uix:switcher>

   
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="streamsComponents" method="post" destination="/console/database/dist/streams/streamsOverview" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/dist/streams/streamsComponents"/>    
                <uix:pageLayout titleBinding="REP_MANAGEMENT@dbInstMsgs">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:switcher childNameBinding="display@servletRequest">
                        <uix:case name="true">
                            <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                            textBinding="CONFIRMATION@aqMsgs"/>
                        </uix:case>
                    </uix:switcher>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <uix:subTabLayout>
                    
                         <%@ include file="repTab.jspf" %>                 
                    
                    <uix:contents>
                    <spacer height="10" width="10"/>
                        
                    <%--Begin Refresh interval Selection row--%>
               <uix:tableLayout width="100%">
                    <uix:contents>
                        <uix:rowLayout>
                            <uix:contents>
                                <uix:cellFormat width="100%" hAlign="right">
                                    <uix:contents>
                                    <uix:rowLayout>
                                    <uix:contents>

<%
 String refreshInProgress = (String) session.getAttribute("StreamsRefreshInProgress");
 if (refreshInProgress != null && refreshInProgress.equals("true"))
 {
%>
	<uix:image source="/em/images/database/dist/process.gif"
                 shortDescBinding="REFRESHING@streamsMsgs" />       
       <uix:spacer width="5" />
       <uix:messageStyledText styleClass="OraInstructionText"            
	    textBinding="REFRESHING@streamsMsgs" />
       <uix:spacer width="5" />
<%
 }
%>


                                    <uix:styledText styleClass="OraTipText" textBinding="LAST_REFRESH@dbMsgs"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:submitButton textBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
                                              <uix:spacer height="10" width="10"/>  
                                              <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel"
                                                      onChange="submitForm('streamsComponents', true, {'event':'refreshStatistics'})"
                                                      selectedValueBinding="refreshHomeSelected@servletRequest">
                                                      <uix:option textBinding="AUTOMATIC_REFRESH@streamsMsgs"
                                                      value="RT_60"/> 
                                                      <uix:option textBinding="MANUAL_REFRESH@streamsMsgs"
                                                      value="RT_MAN"/>
                                              </uix:messageChoice>
                                              </uix:contents>
                                            </uix:rowLayout>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:contents>
                        </uix:rowLayout>
                    </uix:contents>
               </uix:tableLayout>
             <%--End Refresh interval Selection row--%>

<%----------------------------------------------------%>

<%--	hgrid changes 
	                   <uix:spacer height="20" width="10"/>
                        <%@ include file="componentList.jspf" %> 

--%>

                    <uix:spacer height="20" width="10"/>
                    <%@ include file="componentGrid.jspf" %>


                        <!-- To add related links  -->
                    </uix:contents>  
                </uix:subTabLayout> 
			   <%@ include file="streamsLinks.jspf" %> 

<%--
                <!-- To add common related links  -->                    
                <jsp:include page="queue/relatedLinksInclude.jsp" />
                <uix:ref refID="relatedLinksInclude" />
--%>
                
                </uix:pageLayout>
            </db:form>
        </uix:body>                  
    </uix:document>
</uix:renderingContext>

