<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<uix:renderingContext id="renderingContext">
  <db:script src="/database/utils.js"/>
  <oem:setURLEncoder id="renderingContext"/>
  <db:script src="/database/LOV.js"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="strmstupMsgs" class="oracle.sysman.db.rsc.streams.StrmSetupMsg"/>
  <uix:bundle name="captureMsgs" class="oracle.sysman.db.rsc.streams.CaptureMsg"/>
  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText>
		<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />      
	  </uix:rawText>
    </uix:case>
  </uix:switcher>
  <uix:document>
    <uix:metaContainer>
      <%--<uix:head titleBinding="STREAMS@streamsMsgs"/> --%>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <db:form name="streamsDashboard" method="post" destination="/console/database/dist/streams" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/dist/streams/streamsDashboard"/>
        <uix:pageLayout titleBinding="STREAMS@streamsMsgs">
          <%@ include file="/database/global.jspf"%>
          <uix:subTabLayout>

            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:contents>
                  <uix:link destinationBinding="OVERVIEWDEST@servletRequest" textBinding="OVERVIEW@streamsMsgs"/>
		  <uix:link destinationBinding="DASHBOARD_DEST@servletRequest" textBinding="DASHBOARD@streamsMsgs"/>
		  <uix:link destinationBinding="TOPOLOGY_DEST@servletRequest" textBinding="TOPOLOGY@streamsMsgs"/>
                  <uix:link destinationBinding="CAPTUREDEST@servletRequest" textBinding="CAPTURE@streamsMsgs"/>
                  <uix:link destinationBinding="PROPAGATEDEST@servletRequest" textBinding="PROPAGATION@streamsMsgs"/>
                  <uix:link destinationBinding="APPLYDEST@servletRequest" textBinding="APPLY@streamsMsgs"/>
                  <uix:link destinationBinding="MESSAGINGDEST@servletRequest" textBinding="MESSAGING@streamsMsgs"/>
                </uix:contents>
              </uix:subTabBar>
            </uix:subTabs>

				<uix:tableLayout width="100%">
						<uix:contents>
							<uix:rowLayout>
								<uix:contents>
									<uix:cellFormat width="100%" hAlign="right">
										<uix:contents>
										<uix:rowLayout>
										<uix:contents>
										<uix:styledText styleClass="OraTipText" textBinding="LAST_REFRESH@dbMsgs"/>
											<uix:spacer height="10" width="10"/>
											<uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
											<uix:spacer height="10" width="10"/>
											<uix:submitButton textBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
											  <uix:spacer height="10" width="10"/>  
											  <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel"
												  onChange="submitForm('streamsDashboard', true, {'event':'refreshStatistics'})"
												  selectedValueBinding="refreshHomeSelected@servletRequest">
												  <uix:option textBinding="MANUAL_REFRESH@aqMsgs"
												  value="RT_MAN"/>
												  <uix:option textBinding="AUTOMATIC_REFRESH@aqMsgs"
												  value="RT_60"/> 
											  </uix:messageChoice>
 											  <uix:messageChoice prompt="Show Data for" name="duration" id="duration"
												  onChange="submitForm('streamsDashboard', true, {'event':'changeDataDur'})"
												  selectedValueBinding="duration@streamsDashboardObj@servletRequest">
												  <uix:option textBinding="DT_2@streamsMsgs"	  value="DT_2"/>
												  <uix:option textBinding="DT_12@streamsMsgs"	  value="DT_12"/>
												  <uix:option textBinding="DT_1D@streamsMsgs"	  value="DT_1D"/>
												  <uix:option textBinding="DT_7D@streamsMsgs"	  value="DT_7D"/>
											  </uix:messageChoice>
											  </uix:contents>
											</uix:rowLayout>
										</uix:contents>
									</uix:cellFormat>
								</uix:contents>
							</uix:rowLayout>
						</uix:contents>
					</uix:tableLayout>

<%-- 
subtitleBinding="CAPTURE_LATENCY_CHART_DET@streamsMsgs"  
subtitleBinding="PROP_LATENCY_CHART_DET@streamsMsgs"
subtitleBinding="APPLY_LATENCY_CHART_DET@streamsMsgs"
subtitleBinding="CAPTURE_THRP_CHART_DET@streamsMsgs"
subtitleBinding="PROP_THRP_CHART_DET@streamsMsgs"
subtitleBinding="APPLY_THRP_CHART_DET@streamsMsgs"
--%>

			<uix:tableLayout width="100%">
				<uix:rowLayout>
					<uix:cellFormat hAlign="center">                        
						<oem:chart titleBinding="CAPTURE_LATENCY_CHART_TITLE@streamsMsgs"
						 chartType="timeSeriesChart"
						 width="250"
						 height="180" 
						 orientation="vertical"
						 seriesColorsAutomatic="true"
						 seriesSymbolsAutomatic="true"
						 legendPosition="south"
						 >
						  <uix:contents>
							<oem:sqlChartDataSource 
								  sqlPreparedStatementBinding="captureLatencyStmt@streamsDashboardObj@servletRequest"
								  />
							<oem:chartColumn                                   
								isKey="true" 
								displayLabelBinding="CPN@strmstupMsgs"
								sourceIndex="2"
							  />
							<oem:chartColumn
								isTimeColumn="true"
								displayLabelBinding="TIME@captureMsgs"
								sourceIndex="1"
							  />
							<oem:chartColumn                                   
								displayLabelBinding="LATENCY@streamsMsgs"
								sourceIndex="0"
								itemColor="red"
							  />

						  </uix:contents>
						</oem:chart>
					
					</uix:cellFormat>
					
					<uix:cellFormat>
					<uix:spacer width="15" height="20" />
					</uix:cellFormat>

					<uix:cellFormat hAlign="center" renderedBinding="is11gR1@servletRequest">                        
						<oem:chart titleBinding="PROP_LATENCY_CHART_TITLE@streamsMsgs"
						 chartType="timeSeriesChart"
						 width="250"
						 height="180" 
						 orientation="vertical"
						 seriesColorsAutomatic="true"
						 seriesSymbolsAutomatic="true"
						 legendPosition="south"
						 >
						  <uix:contents>
							<oem:sqlChartDataSource 
								  sqlPreparedStatementBinding="propagationLatencyStmt@streamsDashboardObj@servletRequest"
								  />
							<oem:chartColumn                                   
								isKey="true" 
								displayLabelBinding="PPN@strmstupMsgs"
								sourceIndex="2"
							  />
							<oem:chartColumn
								isTimeColumn="true"
								displayLabelBinding="TIME@captureMsgs"
								sourceIndex="1"
							  />
							<oem:chartColumn                                   
								displayLabelBinding="LATENCY@streamsMsgs"
								sourceIndex="0"
								itemColor="red"
							  />

						  </uix:contents>
						</oem:chart>
					
					</uix:cellFormat>

					<uix:cellFormat>
					<uix:spacer width="15" height="20" />
					</uix:cellFormat>

					<uix:cellFormat hAlign="center">                        
						<oem:chart titleBinding="APPLY_LATENCY_CHART_TITLE@streamsMsgs"
						 chartType="timeSeriesChart"
						 width="250"
						 height="180" 
						 orientation="vertical"
						 seriesColorsAutomatic="true"
						 seriesSymbolsAutomatic="true"
						 legendPosition="south"
						 >
						  <uix:contents>
							<oem:sqlChartDataSource 
								  sqlPreparedStatementBinding="applyLatencyStmt@streamsDashboardObj@servletRequest"
								  />
							<oem:chartColumn                                   
								isKey="true" 
								displayLabelBinding="APN@strmstupMsgs"
								sourceIndex="2"
							  />
							<oem:chartColumn
								isTimeColumn="true"
								displayLabelBinding="TIME@captureMsgs"
								sourceIndex="1"
							  />
							<oem:chartColumn                                   
								displayLabelBinding="LATENCY@streamsMsgs"
								sourceIndex="0"
								itemColor="red"
							  />

						  </uix:contents>
						</oem:chart>
					
					</uix:cellFormat>

					<uix:cellFormat>
					<uix:spacer width="15" height="20" />
					</uix:cellFormat>


				</uix:rowLayout>
				<uix:rowLayout>
					<uix:cellFormat hAlign="center">                        
						<oem:chart titleBinding="CAPTURE_THRP_CHART_TITLE@streamsMsgs"
						 chartType="timeSeriesChart"
						 width="250"
						 height="180" 
						 orientation="vertical"
						 seriesColorsAutomatic="true"
						 seriesSymbolsAutomatic="true"
						 legendPosition="south"
						 >
						  <uix:contents>
							<oem:sqlChartDataSource 
								  sqlPreparedStatementBinding="captureThroughputStmt@streamsDashboardObj@servletRequest"
								  />
							<oem:chartColumn                                   
								isKey="true" 
								displayLabelBinding="CPN@strmstupMsgs"
								sourceIndex="2"
							  />
							<oem:chartColumn
								isTimeColumn="true"
								displayLabelBinding="TIME@captureMsgs"
								sourceIndex="1"
							  />
							<oem:chartColumn                                   
								displayLabelBinding="THRP@streamsMsgs"
								sourceIndex="0"
								itemColor="red"
							  />

						  </uix:contents>
						</oem:chart>
					
					</uix:cellFormat>
					
					<uix:cellFormat>
					<uix:spacer width="15" height="20" />
					</uix:cellFormat>

			<%--<uix:cellFormat hAlign="center" columnSpan = "3">     --%>
					<uix:cellFormat hAlign="center">                        
						<oem:chart titleBinding="PROP_THRP_CHART_TITLE@streamsMsgs"
						 chartType="timeSeriesChart"
						 width="250"
						 height="180" 
						 orientation="vertical"
						 seriesColorsAutomatic="true"
						 seriesSymbolsAutomatic="true"
						 legendPosition="south"
						 >
						  <uix:contents>
							<oem:sqlChartDataSource 
								  sqlPreparedStatementBinding="propagationThroughputStmt@streamsDashboardObj@servletRequest"
								  />
							<oem:chartColumn                                   
								isKey="true" 
								displayLabelBinding="PPN@strmstupMsgs"
								sourceIndex="2"
							  />
							<oem:chartColumn
								isTimeColumn="true"
								displayLabelBinding="TIME@captureMsgs"
								sourceIndex="1"
							  />
							<oem:chartColumn                                   
								displayLabelBinding="THRP@streamsMsgs"
								sourceIndex="0"
								itemColor="red"
							  />

						  </uix:contents>
						</oem:chart>
					
					</uix:cellFormat>

					<uix:cellFormat>
					<uix:spacer width="15" height="20" />
					</uix:cellFormat>

					<uix:cellFormat hAlign="center">                        
						<oem:chart titleBinding="APPLY_THRP_CHART_TITLE@streamsMsgs"
						 chartType="timeSeriesChart"
						 width="250"
						 height="180" 
						 orientation="vertical"
						 seriesColorsAutomatic="true"
						 seriesSymbolsAutomatic="true"
						 legendPosition="south"
						 >
						  <uix:contents>
							<oem:sqlChartDataSource 
								  sqlPreparedStatementBinding="applyThroughputStmt@streamsDashboardObj@servletRequest"
								  />
							<oem:chartColumn                                   
								isKey="true" 
								displayLabelBinding="APN@strmstupMsgs"
								sourceIndex="2"
							  />
							<oem:chartColumn
								isTimeColumn="true"
								displayLabelBinding="TIME@captureMsgs"
								sourceIndex="1"
							  />
							<oem:chartColumn                                   
								displayLabelBinding="THRP@streamsMsgs"
								sourceIndex="0"
								itemColor="red"
							  />

						  </uix:contents>
						</oem:chart>
					
					</uix:cellFormat>

				</uix:rowLayout>
			</uix:tableLayout>

            <uix:tableLayout width="100%">
                       
                        <uix:rowLayout>
                            <uix:header textBinding="RELATED_LINKS@streamsMsgs">
                                <uix:bulletedList>
                                    <db:link destination="/console/database/dist/streams/setup?event=configStrm&previousPage=overviewMain" 
                                                                    copyParams="type,target"
                                                                    textBinding="STREAMS_REPL_SETUP_WIZ@captureMsgs"/>

                                    <db:link destination="/console/database/dist/streams/tts?event=replicateTTS&previousPage=overviewMain" copyParams="type, target" textBinding="TTS_WIZ_LINK@streamsMsgs" />
                                    <db:link destination="/console/database/dist/streams?event=removeStreams&backURL=overviewMain" 
                                                                    copyParams="type,target"
                                                                    textBinding="REM_STRM_CONF@captureMsgs"/>
                                </uix:bulletedList>
                                <uix:spacer height="10" width="10"/>
                            </uix:header>
                        </uix:rowLayout>
                       
                        </uix:tableLayout>
                  
          </uix:subTabLayout>
          <%--<jsp:include page="queue/relatedLinksInclude.jsp" />
                    <uix:ref refID="relatedLinksInclude" /> --%>
          <uix:tabs/>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
