<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %> 
<%@ page import="oracle.sysman.db.rsc.streams.PerfAdvisorMsgID"%>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsConstants" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsOverviewBean" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsStatusInfo" %>
<%@ page import="oracle.sysman.emo.dist.streams.StreamsDashboardChartDS" %>
<%@ page import="java.util.HashMap" %>
<%@ page import="java.util.Iterator" %>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>  
    <db:script src="/database/utils.js"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>   
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>   
    <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
    <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
    <uix:bundle name="captureMsgs" class="oracle.sysman.db.rsc.streams.CaptureMsg"/>
     <uix:bundle name="paMsgs" class="oracle.sysman.db.rsc.streams.PerfAdvisorMsg"/>

    <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
        <uix:rawText>
            <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshHomeValue")%>; URL=<%=request.getAttribute("autoRefreshUrl") %>" />
        </uix:rawText>
    </uix:case>
  </uix:switcher>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <uix:body>
            <db:form name="streamsOverview" method="post" destination="/console/database/dist/streams/streamsOverview" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/dist/streams/streamsOverview"/>    
                <uix:pageLayout titleBinding="REP_MANAGEMENT@dbInstMsgs">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:switcher childNameBinding="display@servletRequest">
                        <uix:case name="true">
                            <uix:messageBox messageBinding="SUCC@servletRequest"    messageType="confirmation"
                            textBinding="CONFIRMATION@aqMsgs"/>
                        </uix:case>
                    </uix:switcher>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
        <uix:subTabLayout>
                    
            <%@ include file="repTab.jspf" %>                  
                    
            
            <spacer height="10" width="10"/>
            <%--Begin Refresh interval Selection row--%>
               <uix:tableLayout width="100%">
                    
                        <uix:rowLayout>
                            
                                <uix:cellFormat width="100%" hAlign="right">
                                    
                                    <uix:rowLayout>
                                    

<%
 String refreshInProgress = (String) session.getAttribute("StreamsRefreshInProgress");
 if (refreshInProgress != null && refreshInProgress.equals("true"))
 {
%>
    <uix:image source="/em/images/database/ha/ha_process.gif" 
               shortDescBinding="REFRESHING@streamsMsgs" />                 
      <uix:spacer width="5" />
      <uix:messageStyledText styleClass="OraInstructionText" 
	   textBinding="REFRESHING@streamsMsgs"   />
      <uix:spacer width="5" /> 
<%
 }
%>

                                    <uix:styledText styleClass="OraTipText" textBinding="LAST_REFRESH@dbMsgs"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                                            <uix:spacer height="10" width="10"/>
                                            <uix:submitButton textBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
                                              <uix:spacer height="10" width="10"/>  
                                              <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel"
                                                      onChange="submitForm('streamsOverview', true, {'event':'refreshStatistics'})"
                                                      selectedValueBinding="refreshHomeSelected@servletRequest">
                                                      <uix:option textBinding="AUTOMATIC_REFRESH@streamsMsgs"
                                                      value="RT_60"/> 
                                                      <uix:option textBinding="MANUAL_REFRESH@streamsMsgs"
                                                      value="RT_MAN"/>
                                              </uix:messageChoice>
                                             
                                              
                                            </uix:rowLayout>
                                    
                                </uix:cellFormat>
                            
                        </uix:rowLayout>
                    
               </uix:tableLayout>
             <%--End Refresh interval Selection row--%>

<%
StreamsOverviewBean bean= (StreamsOverviewBean) request.getAttribute("MAIN_OVERVIEW_BEAN");
StreamsDashboardChartDS chartbean= (StreamsDashboardChartDS) request.getAttribute("streamsDashboardObj");
StreamsStatusInfo infoBean = null;
if (bean != null)
    infoBean = bean.getStreamsStatusInfo();
%>

              <uix:spacer height="10" width="10"/>
             <uix:tableLayout width="100%">
                <%--Summary  begin --%>

               <uix:rowLayout>

              <%--General Summary Begin --%>
<%-----------------------------------------------------------------------------------
               <uix:cellFormat vAlign="top" width="30%" columnSpan="3">  
                 <uix:header textBinding="GENERAL@streamsMsgs">
                                  
                  <uix:tableLayout width="100%">
%-- enable when designator comes into picture
                    <uix:rowLayout width="100%" >
                      <uix:cellFormat vAlign="top">
                        <uix:checkBox
                         name="isDesiganted"
                         checkedBinding="isDesignated@MAIN_OVERVIEW_BEAN@servletRequest"
                         renderedBinding= "isDesignated@MAIN_OVERVIEW_BEAN@servletRequest" 
                         textBinding="DESIGNATED_TEXT@streamsMsgs"  />
                        <uix:spacer  width="10"/>
                        <db:link destination="/console/database/dist/streams/capture?event=captureMain"
                         copyParams="type,target"
                         renderedBinding= "isDesignated@MAIN_OVERVIEW_BEAN@servletRequest" 
                         textBinding="CHANGE_DESIGNATION_TEXT@streamsMsgs" />
                      </uix:cellFormat>
                    </uix:rowLayout>
--%
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="right"  width="70%">
                        <uix:styledText styleClass="OraPromptText"
                            textBinding="STREAMS_POOL_ALLOCATED@streamsMsgs"/>
                      </uix:cellFormat>
                      <uix:spacer  width="2"/>
                      <uix:cellFormat hAlign="left" >
                        <db:link destinationBinding="streamsPoolAllocURL@MAIN_OVERVIEW_BEAN@servletRequest"
                         copyParams="type,target"
                         textBinding= "streamsPoolAllocated@MAIN_OVERVIEW_BEAN@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                      <uix:cellFormat hAlign="right" width="70%">
                        <uix:styledText styleClass="OraPromptText"
                            textBinding="STREAMS_POOL_USED@streamsMsgs"/>
                      </uix:cellFormat>
                      <uix:spacer  width="2"/>
                      <uix:cellFormat hAlign="left" >
		         <uix:rowLayout>
		<uix:switcher childNameBinding="streamsPoolAlertSeverity@MAIN_OVERVIEW_BEAN@servletRequest">
		   <uix:case name="Critical">
		       <uix:image source="/em/images/criticalind_status.gif"/>            
		   </uix:case>
		   <uix:case name="Warning">
		       <uix:image source="/em/images/warningind_status.gif"/>       
		   </uix:case>
		</uix:switcher>
                      <uix:spacer  width="3"/>
		<uix:switcher childNameBinding="targetType@MAIN_OVERVIEW_BEAN@servletRequest">
		   <uix:case name="rac_database">
                        <db:link destination="/console/database/dist/streams/capture?event=captureMain"
                         copyParams="type,target"
                         textBinding="streamsPoolUsed@MAIN_OVERVIEW_BEAN@servletRequest" />
		   </uix:case>
		   <uix:default>
                        <uix:styledText styleClass="OraPromptText"
                             textBinding="streamsPoolUsed@MAIN_OVERVIEW_BEAN@servletRequest"/>
		   </uix:default>
		</uix:switcher>
			</uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>

%---- till designated and monitored clearly define 
    <uix:switcher childNameBinding="isDesignated@MAIN_OVERVIEW_BEAN@servletRequest">
       <uix:case name="false">
    <uix:rowLayout>
      <uix:cellFormat vAlign="top" width="55%">
         <uix:styledText styleClass="OraPromptText" 
	            textBinding="STREAMS_MONITOR@dbInstMsgs"/>
    <uix:spacer  width="10"/>
    <uix:styledText styleClass="OraPromptText"
		    textBinding="streamsMonitor@MAIN_OVERVIEW_BEAN@servletRequest"/>
      </uix:cellFormat>
    </uix:rowLayout>

       </uix:case>
    </uix:switcher>
--%

</uix:tableLayout>
                 </uix:header>
                </uix:cellFormat>
<%----------------------------------------------------------------------------------------%>
               <%--General Summary End --%>
               






               <%--Component summary begin --%>
                 <uix:cellFormat vAlign="top" width="33%">
                    <uix:header textBinding="COMPONENT_SUMMARY@streamsMsgs" shortDescBinding="COMPONENT_SUMMARY_TIP@streamsMsgs" >
			 

                        <uix:tableLayout width="100%" >
                         <uix:rowLayout width="100%">

							<uix:cellFormat width="30%">

							 <uix:tableLayout width="100%" >
							   <uix:rowLayout>
			 
								<uix:cellFormat width="40%" hAlign="right" > 
										<uix:messageStyledText styleClass="OraInstructionText" textBinding="CAPTURE@streamsMsgs"/>
		       					</uix:cellFormat>

								<uix:cellFormat width="30%">
									<uix:rowLayout>
			     
										<uix:spacer width="7"/>
										<%
										if (infoBean.getCaptureCount() == 0)
										{
										%>
											<uix:styledText styleClass="OraPromptText" textBinding="N_A@aqMsgs"/>
										<%
										}
										else
										{
										 
										if (infoBean.getCaptureCrit() != 0)
										{
										%>
																  <uix:image source="/em/images/criticalind_status.gif" shortDescBinding="criticalCapNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" />
																  <uix:spacer width="2"/>
																  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=capture"
																		   copyParams="type,target"
																		   textBinding="captureCrit@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" 
																		   shortDescBinding="CRITICAL_CAPTURE_PROCS@servletRequest"/>
													  <uix:spacer width="7"/>
										<% 
										}
										if (infoBean.getCaptureWarn() != 0)
										{
										%>
																  <uix:image source="/em/images/warningind_status.gif" shortDescBinding="warningCapNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" />
																  <uix:spacer width="2"/>
																  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=capture"
																	  copyParams="type,target"
																	  textBinding="captureWarn@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
																	  shortDescBinding="WARNING_CAPTURE_PROCS@servletRequest" />
													  <uix:spacer width="7"/>
										<% 
										}
										if (infoBean.getCaptureHealthy() != 0)
										{
										%>
										<uix:image source="/em/images/okind_status.gif" 
										 shortDescBinding="healthyCapNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" 
										 renderedBinding="showCheckMarks@MAIN_OVERVIEW_BEAN@servletRequest" />
										<uix:spacer width="2"/>
									    <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=capture"
										  copyParams="type,target"
										  textBinding="captureHealthy@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
										  shortDescBinding="HEALTHY_CAPTURE_PROCS@servletRequest" />
										  <% 
										 }
										 }
										 %>
			   
									</uix:rowLayout>
								</uix:cellFormat>
			 
							</uix:rowLayout>
							<uix:rowLayout width="100%">
			 
								<uix:cellFormat  width="40%" hAlign="right" >
									<uix:messageStyledText styleClass="OraInstructionText" textBinding="PROPAGATION@streamsMsgs"/>
								</uix:cellFormat>

								<uix:cellFormat width="30%">
									<uix:rowLayout>
			     
										<uix:spacer width="7"/>
										<% 
										if (infoBean.getPropagationCount() == 0)
										{
										%>
											<uix:styledText styleClass="OraPromptText" textBinding="N_A@aqMsgs"/>
										<% 
										}
										else
										{
										if (infoBean.getPropagationCrit() != 0)
										{
										%>
																  <uix:image source="/em/images/criticalind_status.gif" shortDescBinding="criticalPropNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" />
																  <uix:spacer width="2"/>
													  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=propagation"
																		copyParams="type,target"
																		textBinding="propagationCrit@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
																		shortDescBinding="CRITICAL_PROPAGATION_PROCS@servletRequest" />
													  <uix:spacer width="7"/>
										<%
										}
										if (infoBean.getPropagationWarn() != 0)
										{
										%>
																  <uix:image source="/em/images/warningind_status.gif" shortDescBinding="warningPropNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" />
																  <uix:spacer width="2"/>
													  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=propagation"
																		copyParams="type,target"
																		textBinding="propagationWarn@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
																		shortDescBinding="WARNING_PROPAGATION_PROCS@servletRequest" />
													  <uix:spacer width="7"/>
										<%
										}
										if (infoBean.getPropagationHealthy() != 0)
										{
										%>
																  <uix:image source="/em/images/okind_status.gif" 
															 shortDescBinding="healthyPropNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" 
															 renderedBinding="showCheckMarks@MAIN_OVERVIEW_BEAN@servletRequest" />
																  <uix:spacer width="2"/>
													  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=propagation"
																		copyParams="type,target"
																		textBinding="propagationHealthy@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
																		shortDescBinding="HEALTHY_PROPAGATION_PROCS@servletRequest" />
										<%
										}
										}
										%>
			   
									</uix:rowLayout>
								</uix:cellFormat>

								<uix:spacer width="5"/>
		      

							</uix:rowLayout>
<%-- --%>
							<uix:rowLayout width="100%">
			 
								<uix:cellFormat  width="40%" hAlign="right" >
									<uix:messageStyledText styleClass="OraInstructionText" textBinding="APPLY@streamsMsgs"/>
								</uix:cellFormat>

								<uix:cellFormat width="30%">
									<uix:rowLayout>
			     
										<uix:spacer width="7"/>
										<% 
										if (infoBean.getApplyCount() == 0)
										{
										%>
											<uix:styledText styleClass="OraPromptText" textBinding="N_A@aqMsgs"/>
										<% 
										}
										else
										{
										if (infoBean.getApplyCrit() != 0)
										{
										%>
																  <uix:image source="/em/images/criticalind_status.gif" shortDescBinding="criticalAppNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" />
																  <uix:spacer width="2"/>
													  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=apply"
																  copyParams="type,target"
																  textBinding="applyCrit@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
																  shortDescBinding="CRITICAL_APPLY_PROCS@servletRequest" />
													  <uix:spacer width="7"/>
										<%
										}
										if (infoBean.getApplyWarn() != 0)
										{
										%>
																  <uix:image source="/em/images/warningind_status.gif" shortDescBinding="warningAppNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" />
																  <uix:spacer width="2"/>
													  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=apply"
																  copyParams="type,target"
																  textBinding="applyWarn@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
																  shortDescBinding="WARNING_APPLY_PROCS@servletRequest" />
													  <uix:spacer width="7"/>
										<%
										}
										if (infoBean.getApplyHealthy() != 0)
										{
										%>
																  <uix:image source="/em/images/okind_status.gif" shortDescBinding="healthyAppNames@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
															 renderedBinding="showCheckMarks@MAIN_OVERVIEW_BEAN@servletRequest"  />
																  <uix:spacer width="2"/>
													  <db:link destination="/console/database/dist/streams/streamsOverview?event=search&compType=apply"
																  copyParams="type,target"
																  textBinding="applyHealthy@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest"
																  shortDescBinding="HEALTHY_APPLY_PROCS@servletRequest" />
										<%
										}
										}
										%>
			   
									</uix:rowLayout>
								</uix:cellFormat>

								<uix:cellFormat>
									<uix:spacer width="5"/>
								</uix:cellFormat>
								<uix:cellFormat  width="40%"> 
                         

								</uix:cellFormat>
						<%--		<uix:cellFormat  width="30%"/> 

							</uix:rowLayout>
						</uix:cellFormat> --%>
                        <uix:spacer width="5"/>
			 
					</uix:rowLayout>
<%----%>
				</uix:tableLayout>

							</uix:cellFormat>


<%
if ( (infoBean != null && infoBean.getComponentCount() > 0) ) 
{
%>
							<uix:cellFormat hAlign="left" width="40%" vAlign="top">
								<uix:rowLayout width="100%">
									<uix:cellFormat hAlign="right"  width="40%">
										<uix:styledText styleClass="OraPromptText"
												textBinding="STREAMS_POOL_ALLOCATED@streamsMsgs"/>
									</uix:cellFormat>
								</uix:rowLayout>
                                                                <uix:rowLayout width="100%">
                                                                      <uix:cellFormat hAlign="right" width="40%">
                                                                        <uix:styledText styleClass="OraPromptText"
                                                                            textBinding="STREAMS_POOL_USED@streamsMsgs"/>
                                                                      </uix:cellFormat>
                                                                  </uix:rowLayout>
							</uix:cellFormat>
							<uix:cellFormat hAlign="left" width="30%" vAlign="top">
								<uix:rowLayout>
								  <uix:spacer width="10"/>
								  <uix:spacer width="7"/>
								  <db:link destinationBinding="streamsPoolAllocURL@MAIN_OVERVIEW_BEAN@servletRequest"
									 copyParams="type,target"
									 textBinding= "streamsPoolAllocated@MAIN_OVERVIEW_BEAN@servletRequest"/>
								</uix:rowLayout>
                                                                <uix:rowLayout>
                                                                <uix:cellFormat hAlign="left" width="30%">
 
                                                                    <uix:rowLayout>
                                                                            <uix:spacer width="7"/>
                                                                                    <uix:switcher childNameBinding="streamsPoolAlertSeverity@MAIN_OVERVIEW_BEAN@servletRequest">
                                                                                            <uix:case name="Critical">
                                                                                                            <uix:image source="/em/images/criticalind_status.gif"/>            
                                                                                            </uix:case>
                                                                                            <uix:case name="Warning">
                                                                                                            <uix:image source="/em/images/warningind_status.gif"/>       
                                                                                            </uix:case>
                                                                                            <uix:default>
                                                                                                            <uix:image source="/em/images/okind_status.gif"/>       
                                                                                            </uix:default>
                                                                                    </uix:switcher>
                                                                                    <uix:spacer  width="2"/>
                                                                                    <uix:switcher childNameBinding="targetType@MAIN_OVERVIEW_BEAN@servletRequest">
                                                                                            <uix:case name="rac_database">
                                                                                                    <db:link destination="/console/database/dist/streams/capture?event=captureMain"
                                                                                                     copyParams="type,target"
                                                                                                     textBinding="streamsPoolUsed@MAIN_OVERVIEW_BEAN@servletRequest" />
                                                                                       </uix:case>
                                                                                       <uix:default>
                                                                                                    <uix:styledText styleClass="OraPromptText"
                                                                                                    textBinding="streamsPoolUsed@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                                                            </uix:default>
                                                                                    </uix:switcher>
                    
                                                                    </uix:rowLayout>
                                                              </uix:cellFormat>
                                                          </uix:rowLayout>
						   </uix:cellFormat>

<%
}
%>  
					</uix:rowLayout>

                 </uix:tableLayout>
			 
                    </uix:header>
                 </uix:cellFormat>
               
        <%--   Componnet summary end --%>






               
               <%--Path summary begin --%>
               <uix:cellFormat vAlign="top" width="33%" >

				<uix:header textBinding="PATH_SUMMARY@streamsMsgs" renderedBinding="isPrivilegedUser@servletRequest" shortDescBinding="PATH_SUMMARY_TIP@streamsMsgs" >
										  <%--<uix:messageStyledText styleClass="OraInstructionText" textBinding="paRanOnceInSession@servletRequest"/>
   <uix:messageStyledText styleClass="OraInstructionText" textBinding="refreshInProgress@MAIN_OVERVIEW_BEAN@servletRequest"/>
--%>

	<uix:switcher childNameBinding="paRanOnceInSession@servletRequest">              
       	<uix:case name="true">

					<uix:tableLayout width="100%">

						<uix:rowLayout width="100%">
						   <uix:cellFormat vAlign="top" width="55%">							 
								 <uix:tableLayout>
									<uix:rowLayout>
									   <uix:cellFormat hAlign="right">
										  <uix:messageStyledText styleClass="OraInstructionText" textBinding="PATH_COUNT@streamsMsgs" 
     shortDescBinding="PATH_COUNT_TIP@streamsMsgs" />
										</uix:cellFormat>
										<uix:cellFormat>
										   <uix:spacer height="10" width="10"/>
										</uix:cellFormat>
										<uix:cellFormat hAlign="left">
										   <db:link destination="/console/database/dist/streams/streamsOverview?event=search&displayLevel=pathLevel"
										   copyParams="type,target"
										   textBinding="pathCount@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" 
										   shortDescBinding="PATH_TOTAL@servletRequest" />
										 </uix:cellFormat>
								</uix:rowLayout>

								<uix:rowLayout>
									   <uix:cellFormat hAlign="right">
										  <uix:messageStyledText styleClass="OraInstructionText" textBinding="PATH_UNAVAILABLE@streamsMsgs" 
      shortDescBinding="PATH_UNAVAILABLE_TIP@streamsMsgs"/>
										</uix:cellFormat>
										<uix:cellFormat>
										   <uix:spacer height="10" width="10"/>
										</uix:cellFormat>
										<uix:cellFormat hAlign="left">
										   <db:link destination="/console/database/dist/streams/streamsOverview?event=search&displayLevel=pathLevel"
										   copyParams="type,target"
										   textBinding="unavailPathCount@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" 
										   shortDescBinding="PATH_UNAVAIL@servletRequest" />
										 </uix:cellFormat>
								  </uix:rowLayout>

									<uix:rowLayout>
									   <uix:cellFormat hAlign="right">
										  <uix:messageStyledText styleClass="OraInstructionText" textBinding="PATH_ERRORS@streamsMsgs"
     shortDescBinding="PATH_ERRORS_TIP@streamsMsgs" />
										</uix:cellFormat>
										<uix:cellFormat>
										   <uix:spacer height="10" width="10"/>
										</uix:cellFormat>
										<uix:cellFormat hAlign="left">
										   <db:link destination="/console/database/dist/streams/streamsOverview?event=search&displayLevel=pathLevel"
										   copyParams="type,target"
										   textBinding="errorPathCount@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" 
										   shortDescBinding="PATH_ERRORS@servletRequest" />
										 </uix:cellFormat>
								  </uix:rowLayout>

<%------------- include bottle neck in problem path count and show stauts down / unavial as new row
									<uix:rowLayout>
									   <uix:cellFormat hAlign="right">
										  <uix:messageStyledText styleClass="OraInstructionText" textBinding="PATH_BOTTLENECKS@streamsMsgs"/>
										</uix:cellFormat>
										<uix:cellFormat>
										   <uix:spacer height="10" width="10"/>
										</uix:cellFormat>
										<uix:cellFormat hAlign="left">
										   <db:link destination="/console/database/dist/streams/streamsOverview?event=search&displayLevel=pathLevel"
										   copyParams="type,target"
										   textBinding="bottleneckPathCount@streamsStatusInfo@MAIN_OVERVIEW_BEAN@servletRequest" 
										   shortDescBinding="PATH_BOTTLENECKS@servletRequest" />
										 </uix:cellFormat>
								  </uix:rowLayout>
------------%>


								   </uix:tableLayout>
							</uix:cellFormat>
						</uix:rowLayout>


					</uix:tableLayout> 
					   </uix:case>
				   <uix:default>
				<uix:messageStyledText styleClass="OraInstructionText" textBinding="LOADING@streamsMsgs"/>
				   </uix:default>
				</uix:switcher>
				</uix:header>

                </uix:cellFormat>
               <%--Path summary end --%>


               <%--Summary  end --%>
              </uix:rowLayout>
              </uix:tableLayout>
              <%--Charts  begin --%>
                 

<%--<uix:messageStyledText styleClass="OraInstructionText" textBinding="paRanOnceInSession@servletRequest"/> 
<uix:messageStyledText styleClass="OraInstructionText" textBinding="refreshInProgress@MAIN_OVERVIEW_BEAN@servletRequest"/>
--%>
  <uix:header textBinding="DASHBOARD@streamsMsgs"  renderedBinding="dashBoardRendered@servletRequest">
<uix:switcher childNameBinding="paRanOnceInSession@servletRequest">              
       <uix:case name="true">

			<uix:tableLayout>
			 <uix:rowLayout>
			  
				 <uix:tableLayout>
                 <uix:rowLayout>				 
                  
               <uix:cellFormat> 
              <uix:messageChoice promptBinding="VIEW@streamsMsgs" name="graphType" id="graphType"
                          onChange="submitForm('streamsOverview', true, {'event':'changeGraphType'})"
			  selectedValueBinding="graphType@streamsDashboardObj@servletRequest">
                          
           <uix:switcher childNameBinding="showPathOption@servletRequest">
             <uix:case name="true">

<%
if ((chartbean != null) && ((chartbean.getLegendLengthLat() == 5 )|| (chartbean.getLegendLengthThrp() == 5)) && (infoBean.getPathCount() > 5))
{
%>
                          <uix:option textBinding="PATH_LEVEL_TOP5@streamsMsgs"      value="path" />
<%
} else {
%>
                          <uix:option textBinding="PATH_LEVEL@paMsgs"      value="path" />
<%
}
%>
	     </uix:case>
	   </uix:switcher>
<%
if ((chartbean != null ) && (chartbean.getLegendLengthCap() == 5 || chartbean.getLegendLengthProp() == 5 || chartbean.getLegendLengthApl() == 5))
{
%>
	   <uix:option textBinding="COMPONENT_LEVEL_TOP5@streamsMsgs" value="component"/>
<%
} else {
%>
	   <uix:option textBinding="COMPONENT_LEVEL@paMsgs" value="component"/>
<%
}
%>
              </uix:messageChoice>
              </uix:cellFormat>
              <uix:cellFormat>
              <uix:spacer width="10"/>
              </uix:cellFormat>
              <uix:cellFormat> 

<%
if ((infoBean != null && infoBean.getPathCount() > 5) || (chartbean.getGraphType().equals("component")))
{
%>		     

                    <uix:messageChoice promptBinding="STATISTICS@streamsMsgs" name="statType" id="statType"
                          onChange="submitForm('streamsOverview', true, {'event':'changeStatType'})"
			  selectedValueBinding="statType@streamsDashboardObj@servletRequest">
                          <uix:option textBinding="LATENCY@streamsMsgs"      value="latency"/>
                          <uix:option textBinding="THRP@streamsMsgs"   value="throughput"/>
                    </uix:messageChoice>
<%
}
%>
			  </uix:cellFormat>
              <uix:cellFormat>
			  <uix:spacer width="10"/>
              </uix:cellFormat>
              <uix:cellFormat>

			  <uix:messageChoice prompt="Show Data for" name="duration" id="duration"
                                                      onChange="submitForm('streamsOverview', true, {'event':'changeDataDur'})"
                                                      selectedValueBinding="duration@streamsDashboardObj@servletRequest">
                                                      <uix:option textBinding="DT_1@streamsMsgs"	  value="DT_1"/>
                                                      <uix:option textBinding="DT_12@streamsMsgs"	  value="DT_12"/>
                                                      <uix:option textBinding="DT_1D@streamsMsgs"	  value="DT_1D"/>
                                              </uix:messageChoice>
              </uix:cellFormat>
			  

	        </uix:rowLayout>
	      </uix:tableLayout>
			  
           </uix:rowLayout>
            <uix:rowLayout>
             <uix:spacer height="10"/>
            </uix:rowLayout>
            <uix:rowLayout>

             <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                 
                  <%@ include file="streamsPerformance.jspf" %>
                  
                  </uix:cellFormat>
              </uix:rowLayout>
              <%--Charts  end --%>

              </uix:tableLayout>
			  </uix:rowLayout>
			</uix:tableLayout>
</uix:case>
   <uix:default>
<uix:messageStyledText styleClass="OraInstructionText" textBinding="LOADING@streamsMsgs"/>
   </uix:default>
</uix:switcher>			
		 </uix:header>
<%--    
  </uix:rowLayout>
</uix:tableLayout>
--%>
             <!-- To add related links  -->
            
        </uix:subTabLayout> 
	 <%@ include file="streamsLinks.jspf" %> 

                </uix:pageLayout>
            </db:form>
        </uix:body>                  
    </uix:document>
</uix:renderingContext>
