<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ include file="/oemNoscript.jspf" %>
<% 
  String dbVersion = (String)request.getAttribute("DBVERSION");
%>

<uix:renderingContext id="renderingContext">
  <db:script src="/database/utils.js"/>
  <oem:setURLEncoder id="renderingContext"/>
  <db:script src="/database/LOV.js"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="aqMsgs" class="oracle.sysman.db.rsc.streams.AQMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="captureMsgs" class="oracle.sysman.db.rsc.streams.CaptureMsg"/>
  <uix:switcher childNameBinding="autoHomeRefresh@servletRequest">
    <uix:case name="true">
      <uix:rawText>
		<meta http-equiv="Refresh" content="60; URL=<%=request.getAttribute("autoRefreshUrl") %>" />      
	  </uix:rawText>
    </uix:case>
  </uix:switcher>
  <uix:document>
    <uix:metaContainer>
      <%--<uix:head titleBinding="STREAMS@streamsMsgs"/> --%>
      <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
    <script>
        function openLegend(legendUrl)
        {
          window.open(legendUrl, 'Legends', 'width=600, height=500');
        }

      </script>
    <uix:body>
      <db:form name="streamsTopology" method="post" destination="/console/database/dist/streams/streamsOverview" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/dist/streams/streamsTopology"/>
        <uix:pageLayout titleBinding="REP_MANAGEMENT@dbInstMsgs">
          <%@ include file="/database/global.jspf"%>
          <uix:subTabLayout>
                <%@ include file="repTab.jspf"%>
            <uix:contents>
              <spacer height="10" width="10"/>
              <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat width="100%" hAlign="right">
                        <uix:contents>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESH@aqMsgs"/>
                              <uix:spacer height="10" width="10"/>
                              <uix:styledText styleClass="OraTipLabel" textBinding="TIMESTAMP@servletRequest"/>
                              <uix:spacer height="10" width="10"/>
                              <uix:submitButton textBinding="REFRESH@dbMsgs" name="event" value="refreshStatistics"/>
                            </uix:contents>
                          </uix:rowLayout>
                          <uix:rowLayout hAlign="right">
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="30" width="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                              <uix:rowLayout>
                                <uix:messageChoice promptBinding="VIEW_DATA@dbMsgs" name="refreshHome" id="ViewLabel" onChange="submitForm('streamsTopology', true, {'event':'refreshStatistics'})" selectedValueBinding="refreshHomeSelected@servletRequest">
                                  <uix:option textBinding="MANUAL_REFRESH@aqMsgs" value="RT_MAN"/>
                                  <uix:option textBinding="AUTOMATIC_REFRESH@aqMsgs" value="RT_60"/>
                                </uix:messageChoice>
                              </uix:rowLayout>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
              <uix:spacer height="10" width="10"/>

<%--
              <uix:tableLayout width="100%">
                <uix:contents>
                  <uix:rowLayout width="100%">
                    <uix:contents>
                      <uix:cellFormat vAlign="top" width="55%">
                        <uix:contents>
                          <uix:tableLayout width="100%">
                            <uix:contents>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat vAlign="top" width="48%">
                                    <uix:contents>
                                      <uix:header textBinding="CAPTURE@streamsMsgs">
                                        <uix:contents>
                                          <uix:spacer height="10" width="10"/>
                                          <uix:tableLayout>
                                            <uix:contents>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:messageStyledText styleClass="OraInstructionText" textBinding="CAPTURE_PROCS@streamsMsgs"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <db:link destination="/console/database/dist/streams/capture?event=captureMain" copyParams="type,target" textBinding="captureProcs@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="DBVERSION@@servletRequest">
                                                        <uix:case name="10g">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="CAPTURE_ERRORS@streamsMsgs"/>
                                                        </uix:case>
                                                        <uix:case name="9i">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="ABORTED_CAPTURE@streamsMsgs"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="captureErrorsStatus@MAIN_OVERVIEW_BEAN@servletRequest">
                                                        <uix:case name="true">
                                                          <uix:image source="/em/images/criticalind_status.gif"/>
                                                        </uix:case>
                                                        <uix:case name="false">
                                                          <uix:image source="/em/images/okind_status.gif"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="CaptureErrors@servletRequest">
                                                        <uix:case name="Y">
                                                          <db:link destination="/console/database/dist/streams/overviewDetails?event=streamsErrors&streamsType=capture" copyParams="type,target" textBinding="captureErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                        <uix:case name="N">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="captureErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                            </uix:contents>
                                          </uix:tableLayout>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:contents>
                                      <uix:spacer height="10" width="5"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:cellFormat vAlign="top" width="45%">
                                    <uix:contents>
                                      <uix:header textBinding="PROPAGATION@streamsMsgs">
                                        <uix:contents>
                                          <uix:spacer height="10" width="10"/>
                                          <uix:tableLayout>
                                            <uix:contents>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:messageStyledText styleClass="OraInstructionText" textBinding="PROPAGATION_JOBS@streamsMsgs"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <db:link destination="/console/database/dist/streams/propagate?event=propagateMain" copyParams="type,target" textBinding="propagationJobs@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:messageStyledText styleClass="OraInstructionText" textBinding="PROPAGATION_ERRORS@streamsMsgs"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="propagationErrorsStatus@MAIN_OVERVIEW_BEAN@servletRequest">
                                                        <uix:case name="true">
                                                          <uix:image source="/em/images/criticalind_status.gif"/>
                                                        </uix:case>
                                                        <uix:case name="false">
                                                          <uix:image source="/em/images/okind_status.gif"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="PropErrors@servletRequest">
                                                        <uix:case name="Y">
                                                          <db:link destination="/console/database/dist/streams/overviewDetails?event=streamsErrors&streamsType=propagation" copyParams="type,target" textBinding="propagationErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                        <uix:case name="N">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="propagationErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                      </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                            </uix:contents>
                                          </uix:tableLayout>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat>
                                    <uix:contents>
                                      <uix:spacer height="30" width="10"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat vAlign="top" width="48%">
                                    <uix:contents>
                                      <uix:header textBinding="APPLY@streamsMsgs">
                                        <uix:contents>
                                          <uix:spacer height="10" width="10"/>
                                          <uix:tableLayout>
                                            <uix:contents>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:messageStyledText styleClass="OraInstructionText" textBinding="APPLY_PROCS@streamsMsgs"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <db:link destination="/console/database/dist/streams/apply?event=applyMain" copyParams="type,target" textBinding="applyProcs@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                     <uix:switcher childNameBinding="DBVERSION@@servletRequest">
                                                        <uix:case name="10g">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="APPLY_ERRORS@streamsMsgs"/>
                                                        </uix:case>
                                                        <uix:case name="9i">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="ABORTED_APPLY@streamsMsgs"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="applyErrorsStatus@MAIN_OVERVIEW_BEAN@servletRequest">
                                                        <uix:case name="true">
                                                          <uix:image source="/em/images/criticalind_status.gif"/>
                                                        </uix:case>
                                                        <uix:case name="false">
                                                          <uix:image source="/em/images/okind_status.gif"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="ApplyErrors@servletRequest">
                                                        <uix:case name="Y">
                                                          <db:link destination="/console/database/dist/streams/overviewDetails?event=streamsErrors&streamsType=apply" copyParams="type,target" textBinding="applyErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                        <uix:case name="N">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="applyErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                            </uix:contents>
                                          </uix:tableLayout>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:contents>
                                      <uix:spacer height="10" width="5"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:cellFormat vAlign="top">
                                    <uix:contents>
                                      <uix:header textBinding="MESSAGING@streamsMsgs">
                                        <uix:contents>
                                          <uix:spacer height="10" width="10"/>
                                          <uix:tableLayout>
                                            <uix:contents>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:messageStyledText styleClass="OraInstructionText" textBinding="QUEUE_TABLES@streamsMsgs"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <db:link destination="/console/database/dist/streams/queueTable?otype=schema&objectType=QTABLE" copyParams="type,target" textBinding="QTables@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:messageStyledText styleClass="OraInstructionText" textBinding="QUEUES@streamsMsgs"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <db:link destination="/console/database/dist/streams/queue?otype=schema&objectType=QUEUE" copyParams="type,target" textBinding="queues@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                              <uix:rowLayout>
                                                <uix:contents>
                                                  <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                      <uix:messageStyledText styleClass="OraInstructionText" textBinding="QUEUE_PROPAGATION_ERRORS@streamsMsgs"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="QPropagationErrorsStatus@MAIN_OVERVIEW_BEAN@servletRequest">
                                                        <uix:case name="true">
                                                          <uix:image source="/em/images/criticalind_status.gif"/>
                                                        </uix:case>
                                                        <uix:case name="false">
                                                          <uix:image source="/em/images/okind_status.gif"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat>
                                                    <uix:contents>
                                                      <uix:spacer height="10" width="10"/>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                  <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                      <uix:switcher childNameBinding="QPropagationErrorsStatus@MAIN_OVERVIEW_BEAN@servletRequest">
                                                        <uix:case name="true">
                                                          <db:link destination="/console/database/dist/streams/overviewDetails" copyParams="type,target" textBinding="QPropagationErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                        <uix:case name="false">
                                                          <uix:messageStyledText styleClass="OraInstructionText" textBinding="QPropagationErrors@MAIN_OVERVIEW_BEAN@servletRequest"/>
                                                        </uix:case>
                                                      </uix:switcher>
                                                    </uix:contents>
                                                  </uix:cellFormat>
                                                </uix:contents>
                                              </uix:rowLayout>
                                            </uix:contents>
                                          </uix:tableLayout>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
                            </uix:contents>
                          </uix:tableLayout>
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:contents>
                          <uix:spacer height="10" width="10"/>
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:cellFormat width="45%">
                        <uix:contents>
                          <uix:contentContainer width="100%" textBinding="OVERVIEW@streamsMsgs" background="light">
                            <uix:contents>
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="STREAMS_OVERVIEW@streamsMsgs"/>
                                  <uix:spacer height="10" width="10"/>
                                  <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="CAPTURE_OVERVIEW@streamsMsgs"/>
                                  <uix:spacer height="10" width="10"/>
                                  <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="PROPAGATION_OVERVIEW@streamsMsgs"/>
                                  <uix:spacer height="10" width="10"/>
                                  <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="APPLY_OVERVIEW@streamsMsgs"/>
                                  <uix:spacer height="10" width="10"/>
                                  <uix:messageStyledText styleClass="OraInlineInfoText" textBinding="MESSAGING_OVERVIEW@streamsMsgs"/>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:contentContainer>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
--%>

              <uix:spacer height="5" width="5"/>
              <uix:messageStyledText styleClass="OraInstructionText" textBinding="TOPO_INSTR@streamsMsgs"/>
              <oem:topology topoPageType="streamsTopoPageType" keyParameters="type, target" summaryBinding="tmp" refreshEvent="refreshStatistics" width="100%" height="60%"/>
              <uix:tableLayout>
                <uix:contents>
                  <uix:rowLayout hAlign="left">
                    <db:link onClickBinding="legendDest@servletRequest"
		    textBinding="LEGEND@streamsMsgs"/>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
              <!-- To add related links  -->
              <%-- End Contents to show the stats --%>
            </uix:contents>
          </uix:subTabLayout>
		  <%@ include file="streamsLinks.jspf" %> 
          <%--<jsp:include page="queue/relatedLinksInclude.jsp" />
                    <uix:ref refID="relatedLinksInclude" /> --%>
          <uix:tabs/>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
