<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
 <%@ include file="/em2go/em2goHrGlobal.jspf" %>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="pluralDisplayName@objectSearchBean@servletRequest"/>
</uix:metaContainer>
<uix:body>
<uix:contents>


<db:form name="dbObjectsList" method="post" destination="/console/database/em2go/databaseObjectsSearch"
         copyParams="target,type,otype">
<uix:formValue name="pageName" value="/database/em2go/dbObjectsList"/>
  
  <%@ include file="/em2go/em2goBreadCrumbs.jspf" %>
  <uix:rowLayout>
  </uix:rowLayout>
    <uix:flowLayout>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"/>
    <uix:styledText styleClass="OraInlineInfoText" textBinding="mainText@info@servletRequest"/>
   </uix:flowLayout>
 
 <uix:flowLayout>
    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"/>
    <uix:styledText styleClass="OraInlineErrorText" textBinding="mainText@errors@servletRequest"/>
   </uix:flowLayout>     
             

   <uix:rowLayout>
      <uix:contents>
        <uix:cellFormat wrappingDisabled="true">
          <uix:flowLayout>
             <uix:contents>
        
              <uix:styledText styleClass="OraPromptText" textBinding="pluralDisplayName@objectSearchBean@servletRequest"/>
          		 
		  
                <uix:textInput name="objectName" textBinding="objectName@objectSearchBean@servletRequest"/>
                <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" 
                                onFocus="true" selected="true" name="event" value="search"/>
            <%-- uix:messageText messageBinding="objectName@errors@servletRequest"
                          messageType="error"/ --%>
		      </uix:contents>
		     </uix:flowLayout>
       </uix:cellFormat>
       </uix:contents>
       
    </uix:rowLayout>

                 <uix:switcher childNameBinding="canCreate@objectSearchBean@servletRequest">
                  <uix:case name="true">
                    <uix:submitButton textBinding="CREATE@uixDBObjectBundle@servletRequest" name="event" value="create"/>
                  </uix:case>
                </uix:switcher>

                <%-- Do not add formSubmitted=true; it ruins source and changes next link to a button --%>          
                <oem:table name="objectsTwoDUIDataSource" 
                     width="100%" beanKey="objectSearchBean" blockSize="10"
                     dataSourceProp="objectsTwoDUIDataSource"
                     alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
                     copyParams="target,type" />



</db:form>
</uix:contents>
</uix:body>
<%-- END: HTML Form --%>

</uix:document>
  <%@ include file="/em2go/em2goThinFooter.jspf" %> 
</uix:renderingContext>
<%-- END: Content --%> 




